/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.support.adapters;

import cn.toutatis.xvoid.axolotl.excel.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.constant.RowLevelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.support.CellGetInfo;
import cn.toutatis.xvoid.axolotl.excel.support.DataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.support.adapters.AbstractDataCastAdapter;
import cn.toutatis.xvoid.toolkit.constant.Regex;
import cn.toutatis.xvoid.toolkit.constant.Time;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.util.Date;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

public class DefaultStringAdapter
extends AbstractDataCastAdapter<String>
implements DataCastAdapter<String> {
    @Override
    public String cast(CellGetInfo cellGetInfo, CastContext<String> context) {
        Object cellValue = cellGetInfo.getCellValue();
        if (!cellGetInfo.isAlreadyFillValue()) {
            return context.getCastType().cast(cellValue);
        }
        ReaderConfig<?> readerConfig = this.getReaderConfig();
        EntityCellMappingInfo<?> entityCellMappingInfo = this.getEntityCellMappingInfo();
        Map<RowLevelReadPolicy, Object> excludePolicies = entityCellMappingInfo.getExcludePolicies();
        return switch (cellGetInfo.getCellType()) {
            case CellType.STRING -> {
                String cellValueString = (String)cellValue;
                if (!excludePolicies.containsKey((Object)RowLevelReadPolicy.TRIM_CELL_VALUE) && readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.TRIM_CELL_VALUE)) {
                    cellValueString = Regex.convertSingleLine((String)cellValueString).replace("\u00a0", "");
                }
                if (Validator.strIsNumber((String)cellValueString) && !excludePolicies.containsKey((Object)RowLevelReadPolicy.CAST_NUMBER_TO_DATE) && readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.CAST_NUMBER_TO_DATE) && DateUtil.isCellDateFormatted((Cell)cellGetInfo.get_cell())) {
                    cellValueString = Time.regexTime((String)context.getDataFormat(), (Date)DateUtil.getJavaDate((double)Double.parseDouble(cellValueString)));
                }
                yield cellValueString;
            }
            case CellType.NUMERIC -> {
                if (!excludePolicies.containsKey((Object)RowLevelReadPolicy.CAST_NUMBER_TO_DATE) && readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.CAST_NUMBER_TO_DATE) && DateUtil.isCellDateFormatted((Cell)cellGetInfo.get_cell())) {
                    cellValue = Time.regexTime((String)context.getDataFormat(), (Date)DateUtil.getJavaDate((double)((Double)cellValue)));
                    yield "%s".formatted(cellValue);
                }
                if ((Double)cellValue % 1.0 == 0.0) {
                    yield "" + ((Double)cellValue).intValue();
                }
                yield String.format("%.2f", (Double)cellValue);
            }
            case CellType.BOOLEAN, CellType.FORMULA -> cellValue.toString();
            default -> null;
        };
    }

    @Override
    public boolean support(CellType cellType, Class<String> clazz) {
        return true;
    }
}

