/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.support.tika;

import cn.toutatis.xvoid.axolotl.excel.constant.CommonMimeType;
import cn.toutatis.xvoid.axolotl.excel.support.tika.DetectResult;
import cn.toutatis.xvoid.toolkit.file.FileToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;

public class TikaShell {
    private static final Logger LOGGER = LoggerToolkit.getLogger(TikaShell.class);
    private static final Tika tika = new Tika();
    public static final MimeType MS_EXCEL = CommonMimeType.MS_EXCEL;
    public static final MimeType OOXML_EXCEL = CommonMimeType.OOXML_EXCEL;

    public static DetectResult detect(File file, MimeType mimeType) {
        return TikaShell.detect(file, mimeType, false);
    }

    public static DetectResult detect(File file, MimeType mimeType, boolean alreadyPreCheck) {
        return TikaShell.detect(file, mimeType, false, alreadyPreCheck);
    }

    public static DetectResult detectThrowException(File file, MimeType mimeType) {
        return TikaShell.detect(file, mimeType, true, false);
    }

    public static DetectResult detect(File file, MimeType mimeType, boolean throwException, boolean alreadyPreCheck) {
        DetectResult preCheck = alreadyPreCheck ? new DetectResult(true) : TikaShell.preCheckFileNormal(file);
        if (preCheck.isDetect()) {
            try {
                DetectResult detectResult = new DetectResult(false);
                detectResult.setWantedMimeType(mimeType);
                String fileSuffix = "." + FileToolkit.getFileSuffix((File)file).toLowerCase();
                List extensions = mimeType.getExtensions();
                int idx = -1;
                for (int i = 0; i < extensions.size(); ++i) {
                    String extension = (String)extensions.get(i);
                    if (!extension.equalsIgnoreCase(fileSuffix)) continue;
                    idx = i;
                    break;
                }
                LOGGER.debug("\u6587\u4ef6\u540e\u7f00\uff1a[" + fileSuffix + "], \u53ef\u5339\u914d\u7684\u540e\u7f00\uff1a" + mimeType.getExtensions() + ", \u5339\u914d\u7684\u540e\u7f00\u7d22\u5f15\uff1a[" + idx + "]");
                if (idx == -1) {
                    String msg = "[" + file.getName() + "]\u6587\u4ef6\u540e\u7f00\u4e0d\u5339\u914d";
                    detectResult.setCurrentFileStatus(DetectResult.FileStatus.FILE_SUFFIX_PROBLEM);
                    if (throwException) {
                        throw new IOException(msg);
                    }
                    return detectResult.returnInfo(msg);
                }
                MimeType detectMimeType = MimeTypes.getDefaultMimeTypes().forName(tika.detect(file));
                LOGGER.debug("\u6587\u4ef6\u5a92\u4f53\u7c7b\u578b\uff1a" + tika.detect(file) + ", \u671f\u671b\u5a92\u4f53\u7c7b\u578b\uff1a" + mimeType);
                if (detectMimeType.equals((Object)mimeType)) {
                    return new DetectResult(true, detectMimeType);
                }
                detectResult.setCatchMimeType(detectMimeType);
                detectResult.setCurrentFileStatus(DetectResult.FileStatus.FILE_MIME_TYPE_PROBLEM);
                String msg = file.getName() + "\u6587\u4ef6\u5a92\u4f53\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5a92\u4f53\u7c7b\u578b\uff1a" + tika.detect(file) + ", \u671f\u671b\u5a92\u4f53\u7c7b\u578b\uff1a" + mimeType;
                if (throwException) {
                    throw new IOException(msg);
                }
                return detectResult.returnInfo(msg);
            }
            catch (IOException e) {
                String msg = file.getName() + "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25";
                if (throwException) {
                    throw new IOException(msg);
                }
                LOGGER.error(msg, (Throwable)e);
                DetectResult detectResult = new DetectResult(false, DetectResult.FileStatus.FILE_MIME_TYPE_PROBLEM, msg);
                detectResult.setWantedMimeType(mimeType);
                return detectResult;
            }
        }
        if (throwException) {
            throw new IOException(preCheck.getMessage());
        }
        return preCheck;
    }

    public static MimeType getMimeType(File file) {
        DetectResult preCheck = TikaShell.preCheckFileNormal(file);
        if (preCheck.isDetect()) {
            try {
                return MimeTypes.getDefaultMimeTypes().forName(tika.detect(file));
            }
            catch (IOException | MimeTypeException e) {
                String msg = "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25";
                LOGGER.error(file.getName() + msg, e);
                throw new IOException(msg);
            }
        }
        LOGGER.error(file.getName() + preCheck.getMessage());
        throw new IOException(preCheck.getMessage());
    }

    public static DetectResult preCheckFileNormalThrowException(File file) {
        return TikaShell.preCheckFileNormal(file, true);
    }

    public static DetectResult preCheckFileNormal(File file) {
        return TikaShell.preCheckFileNormal(file, false);
    }

    public static DetectResult preCheckFileNormal(File file, boolean throwException) {
        if (file == null || !file.exists()) {
            String msg = "\u6587\u4ef6\u4e0d\u5b58\u5728";
            if (throwException) {
                throw new FileNotFoundException(msg);
            }
            return new DetectResult(false, DetectResult.FileStatus.FILE_SELF_PROBLEM, msg);
        }
        if (file.isDirectory()) {
            String msg = "\u9009\u62e9\u6587\u4ef6\u4e0d\u80fd\u662f\u76ee\u5f55";
            if (throwException) {
                throw new IOException(msg);
            }
            return new DetectResult(false, DetectResult.FileStatus.FILE_SELF_PROBLEM, msg);
        }
        return new DetectResult(true);
    }
}

