package cn.toutatis.xvoid.axolotl.toolkit;

import cn.toutatis.xvoid.axolotl.Meta;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import org.slf4j.Logger;

/**
 * Logger辅助类
 */
public class LoggerHelper {

    /**
     * 格式化字符串
     * @param message 格式化字符串
     * @param args 格式化参数
     * @return 格式化后的字符串
     */
    public static String format(String message,Object... args){
        /*JDK17*/
        /*return message.formatted(args);*/
        /*JDK8*/
        return String.format(message,args);
    }

    /**
     * 调试输出
     * @param logger 日志对象
     * @param message 消息内容
     */
    public static void debug(Logger logger,String message) {
        LoggerToolkitKt.debugWithModule(logger, Meta.MODULE_NAME,message);
    }

    public static void debug(Logger logger,String message,Object... args) {
        LoggerToolkitKt.debugWithModule(logger, Meta.MODULE_NAME,format(message, args));
    }

    public static void info(Logger logger,String message){
        LoggerToolkitKt.infoWithModule(logger,Meta.MODULE_NAME,message);
    }
}
