/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader;

import cn.toutatis.xvoid.axolotl.excel.reader.annotations.ColumnBind;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.IndexWorkSheet;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.KeepIntact;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.NamingWorkSheet;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.SpecifyPositionBind;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.ExcelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.reader.support.AxolotlReadInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.clazz.ReflectToolkit;
import cn.toutatis.xvoid.toolkit.constant.Regex;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ReaderConfig<T> {
    private int sheetIndex = 0;
    private String sheetName;
    private int initialRowPositionOffset = 0;
    private Class<T> castClass;
    private int startIndex = 0;
    private int endIndex = -1;
    private int[] sheetColumnEffectiveRange = new int[]{0, -1};
    private boolean readAsObject = false;
    private String needRecordInfo;
    private List<EntityCellMappingInfo<?>> indexMappingInfos;
    private List<EntityCellMappingInfo<?>> positionMappingInfos;
    private Map<ExcelReadPolicy, Object> rowReadPolicyMap = new HashMap<ExcelReadPolicy, Object>();
    private boolean readClassAnnotation = false;
    private int searchHeaderMaxRows = -1;

    public ReaderConfig() {
        this(true);
    }

    public ReaderConfig(Class<T> castClass) {
        this(true);
        this.setCastClass(castClass);
    }

    public ReaderConfig(boolean withDefaultConfig) {
        if (withDefaultConfig) {
            this.rowReadPolicyMap.putAll(this.defaultReadPolicy());
        }
    }

    public ReaderConfig(Class<T> castClass, boolean withDefaultConfig) {
        if (withDefaultConfig) {
            this.rowReadPolicyMap.putAll(this.defaultReadPolicy());
        }
        this.setCastClass(castClass);
    }

    private Map<ExcelReadPolicy, Object> defaultReadPolicy() {
        HashMap<ExcelReadPolicy, Object> defaultReadPolicies = new HashMap<ExcelReadPolicy, Object>();
        for (ExcelReadPolicy policy : ExcelReadPolicy.values()) {
            if (!policy.isDefaultPolicy()) continue;
            defaultReadPolicies.put(policy, policy.getValue());
        }
        return defaultReadPolicies;
    }

    public void setCastClass(Class<T> castClass) {
        this.setCastClass(castClass, true);
    }

    public void setCastClass(Class<T> castClass, boolean readClassAnnotation) {
        if (List.class.isAssignableFrom(castClass)) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u4e00\u822cPOJO\u7c7b\u578b");
        }
        this.castClass = castClass;
        if (readClassAnnotation) {
            this.processClassAnnotation();
        }
        this.processEntityFieldMappingToCell();
    }

    private void processClassAnnotation() {
        NamingWorkSheet namingWorkSheet = this.castClass.getAnnotation(NamingWorkSheet.class);
        if (namingWorkSheet != null) {
            this.setSheetName(namingWorkSheet.sheetName());
            this.setInitialRowPositionOffset(namingWorkSheet.readRowOffset());
            this.setReadClassAnnotation(true);
            this.setSheetColumnEffectiveRange(namingWorkSheet.sheetColumnEffectiveRange());
            return;
        }
        IndexWorkSheet indexWorkSheet = this.castClass.getAnnotation(IndexWorkSheet.class);
        if (indexWorkSheet != null) {
            this.setSheetIndex(indexWorkSheet.sheetIndex());
            this.setInitialRowPositionOffset(indexWorkSheet.readRowOffset());
            this.setReadClassAnnotation(true);
            this.setSheetColumnEffectiveRange(indexWorkSheet.sheetColumnEffectiveRange());
        }
    }

    private void processEntityFieldMappingToCell() {
        List declaredFields = ReflectToolkit.getAllFields(this.castClass, (boolean)true);
        ArrayList indexPositionMappingInfos = new ArrayList();
        ArrayList positionMappingInfos = new ArrayList();
        boolean preciseLocalization = this.getReadPolicyAsBoolean(ExcelReadPolicy.DATA_BIND_PRECISE_LOCALIZATION);
        AtomicInteger idx = new AtomicInteger(-1);
        for (Field declaredField : declaredFields) {
            SpecifyPositionBind specifyPositionBind;
            idx.getAndIncrement();
            EntityCellMappingInfo entityCellMappingInfo = new EntityCellMappingInfo(declaredField.getType());
            entityCellMappingInfo.setFieldIndex(idx.get());
            entityCellMappingInfo.setFieldName(declaredField.getName());
            KeepIntact keepIntact = declaredField.getAnnotation(KeepIntact.class);
            if (keepIntact != null) {
                ExcelReadPolicy[] excludePolicies = keepIntact.excludePolicies();
                entityCellMappingInfo.setExcludePolicies(Arrays.stream(excludePolicies).collect(Collectors.toMap(policy -> policy, policy -> true)));
            }
            if ((specifyPositionBind = declaredField.getAnnotation(SpecifyPositionBind.class)) != null) {
                entityCellMappingInfo.setMappingType(EntityCellMappingInfo.MappingType.POSITION);
                entityCellMappingInfo.setFormat(specifyPositionBind.format());
                entityCellMappingInfo.setDataCastAdapter(specifyPositionBind.adapter());
                String position = specifyPositionBind.value().toUpperCase();
                String[] alphaNumeric = Regex.splitAlphaNumeric((String)position);
                if (alphaNumeric.length == 2) {
                    String columnString = alphaNumeric[0];
                    boolean bigSheetColumn = columnString.length() > 1;
                    int simpleIdx = columnString.charAt(0) - 65;
                    int columnIndex = bigSheetColumn ? (simpleIdx + 1) * 26 + (columnString.charAt(1) - 65) : simpleIdx;
                    entityCellMappingInfo.setColumnPosition(columnIndex);
                    entityCellMappingInfo.setRowPosition(Integer.parseInt(alphaNumeric[1]) - 1);
                    positionMappingInfos.add(entityCellMappingInfo);
                    continue;
                }
                throw new IllegalArgumentException("\u6307\u5b9a\u5355\u5143\u683c\u4f4d\u7f6e\u683c\u5f0f\u9519\u8bef");
            }
            ColumnBind columnBind = declaredField.getAnnotation(ColumnBind.class);
            if (columnBind != null) {
                entityCellMappingInfo.setMappingType(EntityCellMappingInfo.MappingType.INDEX);
                entityCellMappingInfo.setColumnPosition(columnBind.columnIndex());
                String headerName = columnBind.headerName();
                if (Validator.strNotBlank((Object)headerName)) {
                    entityCellMappingInfo.setHeaderName(headerName);
                    entityCellMappingInfo.setHeaderNameIndex(columnBind.sameHeaderIdx());
                }
                entityCellMappingInfo.setDataCastAdapter(columnBind.adapter());
                entityCellMappingInfo.setFormat(columnBind.format());
                indexPositionMappingInfos.add(entityCellMappingInfo);
                continue;
            }
            if (declaredField.getType() == AxolotlReadInfo.class && this.needRecordInfo == null) {
                this.needRecordInfo = declaredField.getName();
                continue;
            }
            if (preciseLocalization) continue;
            entityCellMappingInfo.setMappingType(EntityCellMappingInfo.MappingType.UNKNOWN);
            entityCellMappingInfo.setColumnPosition(idx.get());
            indexPositionMappingInfos.add(entityCellMappingInfo);
        }
        if (this.castClass != Object.class && this.castClass != Map.class && positionMappingInfos.isEmpty() && indexPositionMappingInfos.isEmpty()) {
            throw new IllegalArgumentException(LoggerHelper.format("\u7c7b[%s]\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u5355\u5143\u683c\u6620\u5c04\u6ce8\u89e3", this.castClass.getSimpleName()));
        }
        this.positionMappingInfos = positionMappingInfos;
        this.indexMappingInfos = indexPositionMappingInfos;
    }

    public boolean getReadPolicyAsBoolean(ExcelReadPolicy policy) {
        if (policy.getType() != ExcelReadPolicy.Type.BOOLEAN) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u7279\u6027\u4e0d\u662f\u4e00\u4e2a\u5e03\u5c14\u7c7b\u578b");
        }
        return this.rowReadPolicyMap.containsKey((Object)policy) && (Boolean)this.rowReadPolicyMap.get((Object)policy) != false;
    }

    public void setBooleanReadPolicy(ExcelReadPolicy policy, boolean value) {
        if (policy.getType() != ExcelReadPolicy.Type.BOOLEAN) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u7279\u6027\u4e0d\u662f\u4e00\u4e2a\u5e03\u5c14\u7c7b\u578b");
        }
        this.rowReadPolicyMap.put(policy, value);
    }

    public T getCastClassInstance() {
        if (this.castClass != null) {
            try {
                if (this.castClass == Map.class) {
                    if (this.getReadPolicyAsBoolean(ExcelReadPolicy.SORTED_READ_SHEET_DATA)) {
                        return (T)new LinkedHashMap();
                    }
                    return (T)new HashMap();
                }
                return this.castClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u7c7b\u578b\u5b9e\u4f8b\u5316\u5931\u8d25:" + e.getMessage());
            }
        }
        throw new IllegalArgumentException("\u8f6c\u6362\u7c7b\u578b\u4e3a\u7a7a");
    }

    public void setSheetColumnEffectiveRangeStart(int start) {
        if (start < 0) {
            throw new IllegalArgumentException("\u5f00\u59cb\u4f4d\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        this.sheetColumnEffectiveRange[0] = start;
    }

    public void setSheetColumnEffectiveRangeEnd(int end) {
        this.sheetColumnEffectiveRange[1] = end;
    }

    public void setSheetColumnEffectiveRange(int start, int end) {
        this.setSheetColumnEffectiveRangeStart(start);
        this.setSheetColumnEffectiveRangeEnd(end);
    }

    public String toString() {
        return "ReaderConfig(sheetIndex=" + this.getSheetIndex() + ", sheetName=" + this.getSheetName() + ", initialRowPositionOffset=" + this.getInitialRowPositionOffset() + ", castClass=" + this.getCastClass() + ", startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ", sheetColumnEffectiveRange=" + Arrays.toString(this.getSheetColumnEffectiveRange()) + ", readAsObject=" + this.isReadAsObject() + ", needRecordInfo=" + this.getNeedRecordInfo() + ", indexMappingInfos=" + this.getIndexMappingInfos() + ", positionMappingInfos=" + this.getPositionMappingInfos() + ", rowReadPolicyMap=" + this.getRowReadPolicyMap() + ", readClassAnnotation=" + this.isReadClassAnnotation() + ", searchHeaderMaxRows=" + this.getSearchHeaderMaxRows() + ")";
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getInitialRowPositionOffset() {
        return this.initialRowPositionOffset;
    }

    public Class<T> getCastClass() {
        return this.castClass;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int[] getSheetColumnEffectiveRange() {
        return this.sheetColumnEffectiveRange;
    }

    public boolean isReadAsObject() {
        return this.readAsObject;
    }

    public String getNeedRecordInfo() {
        return this.needRecordInfo;
    }

    public List<EntityCellMappingInfo<?>> getIndexMappingInfos() {
        return this.indexMappingInfos;
    }

    public List<EntityCellMappingInfo<?>> getPositionMappingInfos() {
        return this.positionMappingInfos;
    }

    public Map<ExcelReadPolicy, Object> getRowReadPolicyMap() {
        return this.rowReadPolicyMap;
    }

    public boolean isReadClassAnnotation() {
        return this.readClassAnnotation;
    }

    public int getSearchHeaderMaxRows() {
        return this.searchHeaderMaxRows;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setInitialRowPositionOffset(int initialRowPositionOffset) {
        this.initialRowPositionOffset = initialRowPositionOffset;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public void setSheetColumnEffectiveRange(int[] sheetColumnEffectiveRange) {
        this.sheetColumnEffectiveRange = sheetColumnEffectiveRange;
    }

    public void setReadAsObject(boolean readAsObject) {
        this.readAsObject = readAsObject;
    }

    public void setIndexMappingInfos(List<EntityCellMappingInfo<?>> indexMappingInfos) {
        this.indexMappingInfos = indexMappingInfos;
    }

    public void setPositionMappingInfos(List<EntityCellMappingInfo<?>> positionMappingInfos) {
        this.positionMappingInfos = positionMappingInfos;
    }

    public void setRowReadPolicyMap(Map<ExcelReadPolicy, Object> rowReadPolicyMap) {
        this.rowReadPolicyMap = rowReadPolicyMap;
    }

    public void setReadClassAnnotation(boolean readClassAnnotation) {
        this.readClassAnnotation = readClassAnnotation;
    }

    public void setSearchHeaderMaxRows(int searchHeaderMaxRows) {
        this.searchHeaderMaxRows = searchHeaderMaxRows;
    }

    protected void setNeedRecordInfo(String needRecordInfo) {
        this.needRecordInfo = needRecordInfo;
    }
}

