/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader.support.adapters;

import cn.toutatis.xvoid.axolotl.excel.reader.AxolotlExcelReader;
import cn.toutatis.xvoid.axolotl.excel.reader.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.ExcelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CellGetInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.support.DataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.adapters.AbstractDataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.constant.Regex;
import cn.toutatis.xvoid.toolkit.constant.Time;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;

public class DefaultDateTimeAdapter<NT>
extends AbstractDataCastAdapter<NT>
implements DataCastAdapter<NT> {
    private final Class<NT> dateClass;
    private final Logger LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);

    public DefaultDateTimeAdapter(Class<NT> dateClass) {
        this.dateClass = dateClass;
    }

    @Override
    public NT cast(CellGetInfo cellGetInfo, CastContext<NT> context) {
        Object cellValue = cellGetInfo.getCellValue();
        if (!cellGetInfo.isAlreadyFillValue()) {
            return null;
        }
        ReaderConfig<?> readerConfig = this.getReaderConfig();
        EntityCellMappingInfo<?> entityCellMappingInfo = this.getEntityCellMappingInfo();
        Map<ExcelReadPolicy, Object> excelPolicies = entityCellMappingInfo.getExcludePolicies();
        switch (cellGetInfo.getCellType()) {
            case STRING: {
                if (this.dateClass == LocalDateTime.class) {
                    LocalDateTime localDateTime;
                    cellValue = this.checkTrimFeature2NewString(excelPolicies, readerConfig, context, cellValue);
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(context.getDataFormat());
                    try {
                        localDateTime = LocalDateTime.parse((CharSequence)cellValue, formatter);
                    }
                    catch (DateTimeParseException timeParseException) {
                        if (timeParseException.getMessage().contains("Unable to obtain LocalDateTime from")) {
                            localDateTime = LocalDate.parse(cellValue.toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd")).atStartOfDay();
                        }
                        throw this.throwTimeParseException(context, cellValue, timeParseException);
                    }
                    return this.dateClass.cast(localDateTime);
                }
                if (this.dateClass == Date.class) {
                    cellValue = this.checkTrimFeature2NewString(excelPolicies, readerConfig, context, cellValue);
                    SimpleDateFormat format = new SimpleDateFormat(context.getDataFormat());
                    try {
                        Date date = Time.parseData((SimpleDateFormat)format, (String)cellValue.toString());
                        return this.dateClass.cast(date);
                    }
                    catch (Exception parseException) {
                        throw this.throwTimeParseException(context, cellValue, parseException);
                    }
                }
                if (this.dateClass == LocalDate.class) {
                    LocalDate localDate;
                    cellValue = this.checkTrimFeature2NewString(excelPolicies, readerConfig, context, cellValue);
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(context.getDataFormat());
                    try {
                        localDate = LocalDate.parse((CharSequence)cellValue, formatter);
                    }
                    catch (DateTimeParseException timeParseException) {
                        throw this.throwTimeParseException(context, cellValue, timeParseException);
                    }
                    return this.dateClass.cast(localDate);
                }
            }
            case NUMERIC: {
                if (DateUtil.isValidExcelDate((double)((Double)cellValue))) {
                    Date javaDate = DateUtil.getJavaDate((double)((Double)cellValue));
                    if (this.dateClass == Date.class) {
                        return this.dateClass.cast(javaDate);
                    }
                    if (this.dateClass == LocalDateTime.class) {
                        Instant instant = javaDate.toInstant();
                        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                        return this.dateClass.cast(zonedDateTime.toLocalDateTime());
                    }
                    if (this.dateClass == LocalDate.class) {
                        Instant instant = javaDate.toInstant();
                        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                        return this.dateClass.cast(zonedDateTime.toLocalDate());
                    }
                } else {
                    throw new AxolotlExcelReadException(context, String.format("\u8bfb\u53d6\u503c[%s]\u65e0\u6cd5\u8f6c\u6362\u65e5\u671f\u683c\u5f0f,\u8bf7\u81ea\u884c\u8f6c\u6362\u683c\u5f0f", cellValue));
                }
            }
            case BLANK: {
                return null;
            }
        }
        throw new AxolotlExcelReadException(context, String.format("\u5355\u5143\u683c\u4f4d\u7f6e:[%s]\u8bfb\u53d6\u7c7b\u578b[%s]\u65e0\u6cd5\u8f6c\u6362\u65e5\u671f\u683c\u5f0f", context.getHumanReadablePosition(), cellGetInfo.getCellType()));
    }

    private AxolotlExcelReadException throwTimeParseException(CastContext<?> context, Object cellValue, Exception exception) {
        exception.printStackTrace();
        String message = LoggerHelper.format("\u8bf7\u6307\u5b9a\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f,\u83b7\u53d6\u4e3a:[%s],\u5c1d\u8bd5\u8f6c\u6362\u4e3a:[%s]", cellValue, context.getDataFormat());
        LoggerHelper.debug(this.LOGGER, LoggerHelper.format(message + ",\u9519\u8bef\u4fe1\u606f: [%s]\n", exception.getMessage()));
        return new AxolotlExcelReadException(context, message);
    }

    private Object checkTrimFeature2NewString(Map<ExcelReadPolicy, Object> excelPolicies, ReaderConfig<?> readerConfig, CastContext<?> context, Object cellValue) {
        if (context.getDataFormat().contains(" ")) {
            LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u65e5\u671f\u683c\u5f0f\u5316:[%s] \u5e26\u6709\u7a7a\u683c,\u4e0d\u8fdb\u884c [TRIM_CELL_VALUE] \u7279\u6027\u5904\u7406", context.getDataFormat()));
            return cellValue;
        }
        if (!excelPolicies.containsKey((Object)ExcelReadPolicy.TRIM_CELL_VALUE) && readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.TRIM_CELL_VALUE)) {
            return Regex.convertSingleLine((String)cellValue.toString());
        }
        return cellValue;
    }

    @Override
    public boolean support(CellType cellType, Class<NT> clazz) {
        return !(cellType != CellType.STRING && cellType != CellType.NUMERIC && cellType != CellType.BLANK || clazz != Date.class && clazz != LocalDateTime.class && clazz != LocalDate.class);
    }
}

