/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer;

import cn.toutatis.xvoid.axolotl.common.CommonMimeType;
import cn.toutatis.xvoid.axolotl.excel.writer.AxolotlExcelWriter;
import cn.toutatis.xvoid.axolotl.excel.writer.exceptions.AxolotlWriteException;
import cn.toutatis.xvoid.axolotl.excel.writer.support.WriteContext;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.axolotl.toolkit.tika.DetectResult;
import cn.toutatis.xvoid.axolotl.toolkit.tika.TikaShell;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;
import org.slf4j.Logger;

public abstract class AxolotlAbstractExcelWriter
implements AxolotlExcelWriter {
    protected Logger LOGGER;
    protected SXSSFWorkbook workbook;
    protected WriteContext writeContext;

    protected SXSSFWorkbook initWorkbook(File templateFile) {
        SXSSFWorkbook workbook;
        block9: {
            if (templateFile != null) {
                LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u6b63\u5728\u4f7f\u7528\u6a21\u677f\u6587\u4ef6[%s]\u4f5c\u4e3a\u5199\u5165\u6a21\u677f", templateFile.getAbsolutePath()));
                TikaShell.preCheckFileNormalThrowException(templateFile);
                DetectResult detect = TikaShell.detect(templateFile, CommonMimeType.OOXML_EXCEL);
                if (!detect.isWantedMimeType()) {
                    throw new AxolotlWriteException("\u8bf7\u4f7f\u7528xlsx\u6587\u4ef6\u4f5c\u4e3a\u5199\u5165\u6a21\u677f");
                }
                this.writeContext.setFile(templateFile);
                try (FileInputStream fis = new FileInputStream(templateFile);){
                    OPCPackage opcPackage = OPCPackage.open((InputStream)fis);
                    workbook = new SXSSFWorkbook(XSSFWorkbookFactory.createWorkbook((OPCPackage)opcPackage));
                    break block9;
                }
                catch (IOException | InvalidFormatException e) {
                    e.printStackTrace();
                    throw new AxolotlWriteException(LoggerHelper.format("\u6a21\u677f\u6587\u4ef6[%s]\u8bfb\u53d6\u5931\u8d25", templateFile.getAbsolutePath()));
                }
            }
            workbook = new SXSSFWorkbook();
        }
        return workbook;
    }

    protected XSSFSheet getWorkbookSheet(int sheetIndex) {
        XSSFSheet sheet = this.workbook.getXSSFWorkbook().getSheetAt(sheetIndex);
        if (sheet == null) {
            throw new AxolotlWriteException(LoggerHelper.format("\u5de5\u4f5c\u7c3f\u7d22\u5f15[%s]\u5bf9\u5e94\u7684\u5de5\u4f5c\u8868\u4e0d\u5b58\u5728", sheetIndex));
        }
        return sheet;
    }

    @Override
    public SXSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public void switchSheet(int sheetIndex) {
        LoggerHelper.debug(this.LOGGER, "\u5207\u6362\u5230\u5de5\u4f5c\u8868[%s]", sheetIndex);
        this.writeContext.setSwitchSheetIndex(sheetIndex);
    }
}

