/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer;

import cn.toutatis.xvoid.axolotl.excel.writer.AutoWriteConfig;
import cn.toutatis.xvoid.axolotl.excel.writer.AxolotlAbstractExcelWriter;
import cn.toutatis.xvoid.axolotl.excel.writer.components.Header;
import cn.toutatis.xvoid.axolotl.excel.writer.exceptions.AxolotlWriteException;
import cn.toutatis.xvoid.axolotl.excel.writer.style.AbstractStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AutoWriteContext;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.io.IOException;
import java.util.List;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;

public class AxolotlAutoExcelWriter
extends AxolotlAbstractExcelWriter {
    private final Logger LOGGER = LoggerToolkit.getLogger(AxolotlAutoExcelWriter.class);
    private final AutoWriteConfig writeConfig;
    private final AutoWriteContext writeContext;

    public AxolotlAutoExcelWriter(AutoWriteConfig autoWriteConfig) {
        this.writeConfig = autoWriteConfig;
        AutoWriteContext autoWriteContext = new AutoWriteContext();
        this.workbook = this.initWorkbook(null);
        autoWriteContext.setWorkbook(this.workbook);
        this.writeContext = autoWriteContext;
        ((AxolotlAbstractExcelWriter)this).writeContext = autoWriteContext;
        ((AxolotlAbstractExcelWriter)this).LOGGER = this.LOGGER;
    }

    public AxolotlWriteResult write(List<Header> headers, List<?> dataList) throws AxolotlWriteException {
        LoggerHelper.info(this.LOGGER, this.writeContext.getCurrentWrittenBatchAndIncrement(this.writeConfig.getSheetIndex()));
        if (this.writeContext.isFirstBatch(this.writeContext.getSwitchSheetIndex())) {
            // empty if block
        }
        SXSSFSheet sheet = this.workbook.createSheet();
        this.workbook.setSheetName(this.writeConfig.getSheetIndex(), this.writeConfig.getSheetName());
        ExcelStyleRender styleRender = this.writeConfig.getStyleRender();
        if (styleRender instanceof AbstractStyleRender) {
            AbstractStyleRender innerStyleRender = (AbstractStyleRender)styleRender;
            innerStyleRender.setWriteConfig(this.writeConfig);
            innerStyleRender.renderHeader(sheet);
        } else {
            styleRender.renderHeader(sheet);
        }
        styleRender.renderData(sheet, dataList);
        return null;
    }

    public AxolotlWriteResult write(List<?> dataList) throws AxolotlWriteException {
        LoggerHelper.info(this.LOGGER, this.writeContext.getCurrentWrittenBatchAndIncrement(this.writeConfig.getSheetIndex()));
        SXSSFSheet sheet = this.workbook.createSheet();
        this.workbook.setSheetName(this.writeConfig.getSheetIndex(), this.writeConfig.getSheetName());
        ExcelStyleRender styleRender = this.writeConfig.getStyleRender();
        styleRender.renderData(sheet, dataList);
        return null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.workbook.write(this.writeConfig.getOutputStream());
        this.workbook.close();
    }

    protected XSSFSheet getConfigBoundSheet() {
        return this.getWorkbookSheet(this.writeConfig.getSheetIndex());
    }
}

