/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.style;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class StyleHelper {
    public static final Map<String, Integer> PRESET_CELL_LENGTH_MAP = new HashMap<String, Integer>();
    public static Short STANDARD_TITLE_FONT_SIZE = 18;
    public static Short STANDARD_TEXT_FONT_SIZE = 12;
    public static final Integer SERIAL_NUMBER_LENGTH = 5120;

    public static Integer getPresetCellLength(String cellName) {
        return PRESET_CELL_LENGTH_MAP.getOrDefault(cellName, cellName.length() * 256 * 8);
    }

    public static CellStyle createStandardCellStyle(Workbook workbook, BorderStyle borderStyle, IndexedColors borderColor, boolean bold, String fontName, short fontSize) {
        CellStyle commonCellStyle = workbook.createCellStyle();
        commonCellStyle.setBorderTop(borderStyle);
        commonCellStyle.setBorderRight(borderStyle);
        commonCellStyle.setBorderBottom(borderStyle);
        commonCellStyle.setBorderLeft(borderStyle);
        commonCellStyle.setTopBorderColor(borderColor.getIndex());
        commonCellStyle.setRightBorderColor(borderColor.getIndex());
        commonCellStyle.setBottomBorderColor(borderColor.getIndex());
        commonCellStyle.setLeftBorderColor(borderColor.getIndex());
        commonCellStyle.setAlignment(HorizontalAlignment.CENTER);
        commonCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font = workbook.createFont();
        font.setFontName(fontName);
        font.setBold(bold);
        font.setFontHeightInPoints(fontSize);
        commonCellStyle.setFont(font);
        return commonCellStyle;
    }

    public static void renderMergeRegionStyle(Sheet sheet, CellRangeAddress cellRangeAddress, CellStyle style) {
        for (int rowNum = cellRangeAddress.getFirstRow(); rowNum <= cellRangeAddress.getLastRow(); ++rowNum) {
            Row currentRow = sheet.getRow(rowNum);
            if (currentRow == null) {
                currentRow = sheet.createRow(rowNum);
            }
            for (int colNum = cellRangeAddress.getFirstColumn(); colNum <= cellRangeAddress.getLastColumn(); ++colNum) {
                Cell currentCell = currentRow.getCell(colNum);
                if (currentCell == null) {
                    currentCell = currentRow.createCell(colNum);
                }
                currentCell.setCellStyle(style);
            }
        }
    }

    static {
        PRESET_CELL_LENGTH_MAP.put("\u59d3\u540d", 3500);
        PRESET_CELL_LENGTH_MAP.put("\u540d\u79f0", 5000);
        PRESET_CELL_LENGTH_MAP.put("\u8eab\u4efd\u8bc1", SERIAL_NUMBER_LENGTH);
        PRESET_CELL_LENGTH_MAP.put("\u8eab\u4efd\u8bc1\u53f7", SERIAL_NUMBER_LENGTH);
        PRESET_CELL_LENGTH_MAP.put("\u8eab\u4efd\u8bc1\u53f7\u7801", SERIAL_NUMBER_LENGTH);
        PRESET_CELL_LENGTH_MAP.put("\u6027\u522b", 2000);
        PRESET_CELL_LENGTH_MAP.put("\u5730\u5740", 12800);
    }
}

