/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.support;

import cn.toutatis.xvoid.axolotl.excel.writer.support.PlaceholderType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;

public class CellAddress
implements Cloneable,
Serializable {
    private PlaceholderType placeholderType;
    private String name;
    private String placeholder;
    private String cellValue;
    private String defaultValue;
    private int rowPosition;
    private int columnPosition;
    private CellStyle cellStyle;
    private int writtenRow = -1;
    private boolean cellMultipleMatchTemplate = false;
    private Cell _nonTemplateCell;
    private BigDecimal calculatedValue = new BigDecimal("-1");
    private CellRangeAddress mergeRegion;

    public CellAddress(String cellValue, int rowPosition, int columnPosition, CellStyle cellStyle) {
        this.cellValue = cellValue;
        this.rowPosition = rowPosition;
        this.columnPosition = columnPosition;
        this.cellStyle = cellStyle;
    }

    public void setRowPosition(int rowPosition) {
        ++this.writtenRow;
        this.rowPosition = rowPosition;
    }

    public boolean isInitializedWrite() {
        return this.writtenRow == -1;
    }

    public String replacePlaceholder(String value) {
        return this.cellValue.replace(this.placeholder, value);
    }

    public boolean isMergeCell() {
        return this.mergeRegion != null;
    }

    public CellAddress clone() {
        try {
            return (CellAddress)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public CellAddress deepClone() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        return (CellAddress)ois.readObject();
    }

    public PlaceholderType getPlaceholderType() {
        return this.placeholderType;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getCellValue() {
        return this.cellValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getRowPosition() {
        return this.rowPosition;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public int getWrittenRow() {
        return this.writtenRow;
    }

    public boolean isCellMultipleMatchTemplate() {
        return this.cellMultipleMatchTemplate;
    }

    public Cell get_nonTemplateCell() {
        return this._nonTemplateCell;
    }

    public BigDecimal getCalculatedValue() {
        return this.calculatedValue;
    }

    public CellRangeAddress getMergeRegion() {
        return this.mergeRegion;
    }

    public void setPlaceholderType(PlaceholderType placeholderType) {
        this.placeholderType = placeholderType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setCellValue(String cellValue) {
        this.cellValue = cellValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setColumnPosition(int columnPosition) {
        this.columnPosition = columnPosition;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public void setWrittenRow(int writtenRow) {
        this.writtenRow = writtenRow;
    }

    public void setCellMultipleMatchTemplate(boolean cellMultipleMatchTemplate) {
        this.cellMultipleMatchTemplate = cellMultipleMatchTemplate;
    }

    public void set_nonTemplateCell(Cell _nonTemplateCell) {
        this._nonTemplateCell = _nonTemplateCell;
    }

    public void setCalculatedValue(BigDecimal calculatedValue) {
        this.calculatedValue = calculatedValue;
    }

    public void setMergeRegion(CellRangeAddress mergeRegion) {
        this.mergeRegion = mergeRegion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellAddress)) {
            return false;
        }
        CellAddress other = (CellAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRowPosition() != other.getRowPosition()) {
            return false;
        }
        if (this.getColumnPosition() != other.getColumnPosition()) {
            return false;
        }
        if (this.getWrittenRow() != other.getWrittenRow()) {
            return false;
        }
        if (this.isCellMultipleMatchTemplate() != other.isCellMultipleMatchTemplate()) {
            return false;
        }
        PlaceholderType this$placeholderType = this.getPlaceholderType();
        PlaceholderType other$placeholderType = other.getPlaceholderType();
        if (this$placeholderType == null ? other$placeholderType != null : !((Object)((Object)this$placeholderType)).equals((Object)other$placeholderType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$placeholder = this.getPlaceholder();
        String other$placeholder = other.getPlaceholder();
        if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
            return false;
        }
        String this$cellValue = this.getCellValue();
        String other$cellValue = other.getCellValue();
        if (this$cellValue == null ? other$cellValue != null : !this$cellValue.equals(other$cellValue)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        CellStyle this$cellStyle = this.getCellStyle();
        CellStyle other$cellStyle = other.getCellStyle();
        if (this$cellStyle == null ? other$cellStyle != null : !this$cellStyle.equals(other$cellStyle)) {
            return false;
        }
        Cell this$_nonTemplateCell = this.get_nonTemplateCell();
        Cell other$_nonTemplateCell = other.get_nonTemplateCell();
        if (this$_nonTemplateCell == null ? other$_nonTemplateCell != null : !this$_nonTemplateCell.equals(other$_nonTemplateCell)) {
            return false;
        }
        BigDecimal this$calculatedValue = this.getCalculatedValue();
        BigDecimal other$calculatedValue = other.getCalculatedValue();
        if (this$calculatedValue == null ? other$calculatedValue != null : !((Object)this$calculatedValue).equals(other$calculatedValue)) {
            return false;
        }
        CellRangeAddress this$mergeRegion = this.getMergeRegion();
        CellRangeAddress other$mergeRegion = other.getMergeRegion();
        return !(this$mergeRegion == null ? other$mergeRegion != null : !this$mergeRegion.equals(other$mergeRegion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CellAddress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRowPosition();
        result = result * 59 + this.getColumnPosition();
        result = result * 59 + this.getWrittenRow();
        result = result * 59 + (this.isCellMultipleMatchTemplate() ? 79 : 97);
        PlaceholderType $placeholderType = this.getPlaceholderType();
        result = result * 59 + ($placeholderType == null ? 43 : ((Object)((Object)$placeholderType)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $placeholder = this.getPlaceholder();
        result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
        String $cellValue = this.getCellValue();
        result = result * 59 + ($cellValue == null ? 43 : $cellValue.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        CellStyle $cellStyle = this.getCellStyle();
        result = result * 59 + ($cellStyle == null ? 43 : $cellStyle.hashCode());
        Cell $_nonTemplateCell = this.get_nonTemplateCell();
        result = result * 59 + ($_nonTemplateCell == null ? 43 : $_nonTemplateCell.hashCode());
        BigDecimal $calculatedValue = this.getCalculatedValue();
        result = result * 59 + ($calculatedValue == null ? 43 : ((Object)$calculatedValue).hashCode());
        CellRangeAddress $mergeRegion = this.getMergeRegion();
        result = result * 59 + ($mergeRegion == null ? 43 : $mergeRegion.hashCode());
        return result;
    }

    public String toString() {
        return "CellAddress(placeholderType=" + (Object)((Object)this.getPlaceholderType()) + ", name=" + this.getName() + ", placeholder=" + this.getPlaceholder() + ", cellValue=" + this.getCellValue() + ", defaultValue=" + this.getDefaultValue() + ", rowPosition=" + this.getRowPosition() + ", columnPosition=" + this.getColumnPosition() + ", cellStyle=" + this.getCellStyle() + ", writtenRow=" + this.getWrittenRow() + ", cellMultipleMatchTemplate=" + this.isCellMultipleMatchTemplate() + ", _nonTemplateCell=" + this.get_nonTemplateCell() + ", calculatedValue=" + this.getCalculatedValue() + ", mergeRegion=" + this.getMergeRegion() + ")";
    }
}

