/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.themes;

import cn.toutatis.xvoid.axolotl.excel.writer.style.AbstractStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.AxolotlCommendatoryColors;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.StyleHelper;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AxolotlClassicalTheme
extends AbstractStyleRender
implements ExcelStyleRender {
    private SXSSFWorkbook workbook;
    private static final IndexedColors THEME_COLOR = AxolotlCommendatoryColors.BLUE_GREY;
    private int alreadyWriteRow = -1;

    @Override
    public AxolotlWriteResult init(SXSSFSheet sheet) {
        return null;
    }

    @Override
    public AxolotlWriteResult renderHeader(SXSSFSheet sheet) {
        this.workbook = sheet.getWorkbook();
        this.createTitleRow(sheet);
        CellStyle headerCellStyle = StyleHelper.createStandardCellStyle((Workbook)this.workbook, BorderStyle.MEDIUM, THEME_COLOR, true, "\u5b8b\u4f53", StyleHelper.STANDARD_TEXT_FONT_SIZE);
        SXSSFRow columnNamesRow = sheet.createRow(++this.alreadyWriteRow);
        columnNamesRow.setHeight((short)400);
        return null;
    }

    @Override
    public AxolotlWriteResult renderData(SXSSFSheet sheet, List<?> data) {
        CellStyle dataStyle = StyleHelper.createStandardCellStyle((Workbook)sheet.getWorkbook(), BorderStyle.MEDIUM, THEME_COLOR, false, "\u5b8b\u4f53", StyleHelper.STANDARD_TEXT_FONT_SIZE);
        for (Object datum : data) {
            SXSSFRow dataRow = sheet.createRow(++this.alreadyWriteRow);
            dataRow.setHeight((short)400);
            if (!(datum instanceof Map)) continue;
            Map map = (Map)datum;
            int colIdx = 0;
            for (Object o : map.keySet()) {
                SXSSFCell cell = dataRow.createCell(colIdx);
                Object dataObj = map.get(o);
                String innerData = dataObj == null ? "" : dataObj.toString();
                cell.setCellValue(innerData);
                cell.setCellStyle(dataStyle);
                ++colIdx;
            }
        }
        return null;
    }

    @Override
    public AxolotlWriteResult finish() {
        return null;
    }

    private void createTitleRow(SXSSFSheet sheet) {
        SXSSFRow titleRow = sheet.createRow(++this.alreadyWriteRow);
        titleRow.setHeight((short)600);
        SXSSFCell startPositionCell = titleRow.createCell(0);
        startPositionCell.setCellValue(this.writeConfig.getTitle());
        CellStyle titleCellStyle = StyleHelper.createStandardCellStyle((Workbook)this.workbook, BorderStyle.MEDIUM, THEME_COLOR, true, "\u5b8b\u4f53", StyleHelper.STANDARD_TITLE_FONT_SIZE);
        startPositionCell.setCellStyle(titleCellStyle);
    }
}

