package cn.toutatis.xvoid.axolotl.excel.reader.support.adapters;

import cn.toutatis.xvoid.axolotl.excel.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.AxolotlDefaultConfig;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.RowLevelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CellGetInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.support.DataCastAdapter;
import cn.toutatis.xvoid.toolkit.constant.Regex;
import cn.toutatis.xvoid.toolkit.constant.Time;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

import java.util.Map;

/**
 * 默认的String类型适配器
 * @author Toutatis_Gc
 */
public class DefaultStringAdapter extends AbstractDataCastAdapter<String> implements DataCastAdapter<String> {
    @Override
    public String cast(CellGetInfo cellGetInfo, CastContext<String> context) {
        Object cellValue = cellGetInfo.getCellValue();
        if (!cellGetInfo.isAlreadyFillValue()){
            return context.getCastType().cast(cellValue);
        }
        ReaderConfig<?> readerConfig = getReaderConfig();
        EntityCellMappingInfo<?> entityCellMappingInfo = getEntityCellMappingInfo();
        Map<RowLevelReadPolicy, Object> excludePolicies = entityCellMappingInfo.getExcludePolicies();
        switch (cellGetInfo.getCellType()) {
            case STRING:
                String cellValueString = (String) cellValue;
                if (!excludePolicies.containsKey(RowLevelReadPolicy.TRIM_CELL_VALUE)) {
                    if (readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.TRIM_CELL_VALUE)) {
                        cellValueString = Regex.convertSingleLine(cellValueString).replace(" ", "");
                    }
                }
                if (Validator.strIsNumber(cellValueString)) {
                    if (!excludePolicies.containsKey(RowLevelReadPolicy.CAST_NUMBER_TO_DATE)) {
                        if (readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.CAST_NUMBER_TO_DATE)) {
                            if (DateUtil.isCellDateFormatted(cellGetInfo.get_cell())) {
                                cellValueString = Time.regexTime(context.getDataFormat(), DateUtil.getJavaDate(Double.parseDouble(cellValueString)));
                            }
                        }
                    }
                }
                return cellValueString;

            case NUMERIC:
                if (!excludePolicies.containsKey(RowLevelReadPolicy.CAST_NUMBER_TO_DATE)) {
                    if (readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.CAST_NUMBER_TO_DATE)) {
                        if (DateUtil.isCellDateFormatted(cellGetInfo.get_cell())) {
                            cellValue = Time.regexTime(context.getDataFormat(), DateUtil.getJavaDate((Double) cellValue));
                            return String.format("%s", cellValue);
                        }
                    }
                }
                if ((Double) cellValue % 1 == 0) {
                    return Integer.toString(((Double) cellValue).intValue());
                } else {
                    return String.format("%." + AxolotlDefaultConfig.XVOID_DEFAULT_DECIMAL_SCALE + "f", (Double) cellValue);
                }

            case BOOLEAN:
            case FORMULA:
                return cellValue.toString();

            default:
                return null;
        }
    }

    @Override
    public boolean support(CellType cellType, Class<String> clazz) {
        return true;
    }
}
