/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader;

import cn.toutatis.xvoid.axolotl.excel.ReadConfigBuilder;
import cn.toutatis.xvoid.axolotl.excel.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.WorkBookContext;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.ColumnBind;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.RowLevelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CellGetInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.support.DataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.adapters.AbstractDataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.adapters.AutoAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.axolotl.excel.toolkit.tika.DetectResult;
import cn.toutatis.xvoid.axolotl.excel.toolkit.tika.TikaShell;
import cn.toutatis.xvoid.toolkit.constant.Time;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;
import org.slf4j.Logger;

public class AxolotlExcelReader<T> {
    private final Logger LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);
    private WorkBookContext workBookContext;
    private Validator validator;
    private final ReaderConfig<T> _sheetLevelReaderConfig;

    public AxolotlExcelReader(File excelFile) {
        this(excelFile, true);
    }

    public AxolotlExcelReader(File excelFile, boolean withDefaultConfig) {
        this(excelFile, Object.class, withDefaultConfig);
    }

    public AxolotlExcelReader(File excelFile, Class<T> clazz) {
        this(excelFile, clazz, true);
    }

    public AxolotlExcelReader(File excelFile, Class<T> clazz, boolean withDefaultConfig) {
        if (clazz == null) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u7684\u7c7b\u578b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.detectFileAndInitWorkbook(excelFile);
        this._sheetLevelReaderConfig = new ReaderConfig<T>(clazz, withDefaultConfig);
    }

    private void detectFileAndInitWorkbook(File excelFile) {
        DetectResult detectResult = TikaShell.detect(excelFile, TikaShell.OOXML_EXCEL, false);
        if (!detectResult.isDetect()) {
            DetectResult.FileStatus currentFileStatus = detectResult.getCurrentFileStatus();
            if (currentFileStatus == DetectResult.FileStatus.FILE_MIME_TYPE_PROBLEM || currentFileStatus == DetectResult.FileStatus.FILE_SUFFIX_PROBLEM) {
                detectResult = TikaShell.detect(excelFile, TikaShell.MS_EXCEL, false);
            } else {
                detectResult.throwException();
            }
        }
        if (detectResult.isDetect()) {
            this.workBookContext = new WorkBookContext(excelFile, detectResult);
        } else {
            detectResult.throwException();
        }
        try (FileInputStream fis = new FileInputStream(this.workBookContext.getFile());){
            Workbook workbook;
            if (detectResult.getCatchMimeType() == TikaShell.OOXML_EXCEL && excelFile.length() > 0x2800000L) {
                this.workBookContext.setEventDriven();
                OPCPackage opcPackage = OPCPackage.open((InputStream)fis);
                workbook = XSSFWorkbookFactory.createWorkbook((OPCPackage)opcPackage);
                opcPackage.close();
            } else {
                workbook = WorkbookFactory.create((InputStream)fis);
            }
            this.workBookContext.setWorkbook(workbook);
        }
        catch (IOException | InvalidFormatException | RecordFormatException e) {
            this.LOGGER.error("\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25", e);
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, e.getMessage());
        }
        try (ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();){
            this.validator = validatorFactory.getValidator();
        }
    }

    public <RT> RT readSheetDataAsObject(ReaderConfig<RT> readerConfig) {
        if (readerConfig != null) {
            readerConfig.setReadAsObject(true);
        }
        assert (readerConfig != null);
        Sheet sheet = this.searchSheet(readerConfig);
        this.preCheckAndFixReadConfig(readerConfig);
        this.processMergedCells(sheet);
        RT instance = readerConfig.getCastClassInstance();
        this.convertPositionCellToInstance(instance, readerConfig, sheet);
        this.validateConvertEntity(instance, readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.VALIDATE_READ_ROW_DATA));
        return instance;
    }

    public List<T> readSheetData() {
        return this.readSheetData(0);
    }

    public List<T> readSheetData(int start) {
        return this.readSheetData(this._sheetLevelReaderConfig.getSheetName(), this._sheetLevelReaderConfig.getSheetIndex(), 0, this.getRecordRowNumber(), start);
    }

    public List<T> readSheetData(int start, int end) {
        return this.readSheetData(this._sheetLevelReaderConfig.getSheetName(), this._sheetLevelReaderConfig.getSheetIndex(), start, end, 0);
    }

    public List<T> readSheetData(int start, int end, int initialRowPositionOffset) {
        return this.readSheetData(this._sheetLevelReaderConfig.getSheetName(), this._sheetLevelReaderConfig.getSheetIndex(), start, end, initialRowPositionOffset);
    }

    private List<T> readSheetData(String sheetName, int sheetIndex, int start, int end, int initialRowPositionOffset) {
        this._sheetLevelReaderConfig.setSheetName(sheetName);
        this._sheetLevelReaderConfig.setSheetIndex(sheetIndex);
        this._sheetLevelReaderConfig.setStartIndex(start);
        this._sheetLevelReaderConfig.setEndIndex(end);
        this._sheetLevelReaderConfig.setInitialRowPositionOffset(initialRowPositionOffset);
        return this.readSheetData(this._sheetLevelReaderConfig);
    }

    public <RT> List<RT> readSheetData(Class<RT> castClass, String sheetName) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, true);
        configBuilder.setSheetName(sheetName);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetData(Class<RT> castClass, int sheetIndex) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, true);
        configBuilder.setSheetIndex(sheetIndex);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetData(Class<RT> castClass) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, true);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetData(Class<RT> castClass, int sheetIndex, boolean withDefaultConfig, int startIndex, int endIndex, int initialRowPositionOffset) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, withDefaultConfig);
        configBuilder.setSheetIndex(sheetIndex).setStartIndex(startIndex).setEndIndex(endIndex).setInitialRowPositionOffset(initialRowPositionOffset);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetData(ReadConfigBuilder<RT> configBuilder) {
        return this.readSheetData(configBuilder.build());
    }

    public <RT> List<RT> readSheetData(ReaderConfig<RT> readerConfig) {
        ArrayList readResult = new ArrayList();
        Sheet sheet = this.searchSheet(readerConfig);
        this.preCheckAndFixReadConfig(readerConfig);
        if (sheet == null) {
            return readResult;
        }
        this.processMergedCells(sheet);
        this.readSheetData(sheet, readerConfig, readResult);
        return readResult;
    }

    private Sheet searchSheet(ReaderConfig<?> readerConfig) {
        Sheet sheet;
        if (readerConfig == null) {
            return null;
        }
        if (readerConfig.getSheetName() != null) {
            sheet = this.workBookContext.getWorkbook().getSheet(readerConfig.getSheetName());
            if (sheet != null) {
                readerConfig.setSheetIndex(sheet.getWorkbook().getSheetIndex(sheet));
            } else {
                readerConfig.setSheetIndex(-1);
            }
        } else {
            try {
                sheet = this.workBookContext.getWorkbook().getSheetAt(readerConfig.getSheetIndex());
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().contains("out of range")) {
                    throw e;
                }
                int numberOfSheets = this.workBookContext.getWorkbook().getNumberOfSheets() - 1;
                LoggerToolkitKt.warnWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)String.format("\u8868\u7d22\u5f15[%s]\u8d85\u51fa\u8303\u56f4[0-%s],\u5c06\u8fd4\u56de\u7a7a\u6570\u636e\u6216\u629b\u51fa\u5f02\u5e38", readerConfig.getSheetIndex(), numberOfSheets));
                sheet = null;
                readerConfig.setSheetIndex(-1);
            }
        }
        return sheet;
    }

    private void processMergedCells(Sheet sheet) {
        List mergedRegions = sheet.getMergedRegions();
        LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)"\u5f00\u59cb\u5904\u7406\u5de5\u4f5c\u8868\u5408\u5e76\u5355\u5143\u683c");
        for (CellRangeAddress mergedRegion : mergedRegions) {
            int firstRow = mergedRegion.getFirstRow();
            int lastRow = mergedRegion.getLastRow();
            int firstColumn = mergedRegion.getFirstColumn();
            int lastColumn = mergedRegion.getLastColumn();
            Cell leftTopCell = sheet.getRow(firstRow).getCell(firstColumn);
            LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)String.format("\u5904\u7406\u5408\u5e76\u5355\u5143\u683c[%s]", mergedRegion.formatAsString()));
            for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
                block8: for (int columnIndex = firstColumn; columnIndex <= lastColumn; ++columnIndex) {
                    Row row = sheet.getRow(rowIndex);
                    Cell cell = row.getCell(columnIndex);
                    if (cell == null) {
                        cell = row.createCell(columnIndex, leftTopCell.getCellType());
                    }
                    switch (leftTopCell.getCellType()) {
                        case STRING: {
                            cell.setCellValue(leftTopCell.getStringCellValue());
                            continue block8;
                        }
                        case NUMERIC: {
                            cell.setCellValue(leftTopCell.getNumericCellValue());
                            continue block8;
                        }
                        case BOOLEAN: {
                            cell.setCellValue(leftTopCell.getBooleanCellValue());
                            continue block8;
                        }
                        case FORMULA: {
                            cell.setCellValue(leftTopCell.getCellFormula());
                        }
                    }
                }
            }
        }
    }

    private <RT> void readSheetData(Sheet sheet, ReaderConfig<RT> readerConfig, List<RT> list) {
        int initialRowPositionOffset;
        int startIndex = readerConfig.getStartIndex();
        int endIndex = readerConfig.getEndIndex();
        if (startIndex == 0 && (initialRowPositionOffset = readerConfig.getInitialRowPositionOffset()) > 0) {
            this.LOGGER.debug("\u8df3\u8fc7\u524d{}\u884c", (Object)initialRowPositionOffset);
            startIndex += initialRowPositionOffset;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            RT instance = this.readRow(sheet, i, readerConfig);
            if (instance == null) continue;
            list.add(instance);
        }
    }

    private <RT> RT readRow(Sheet sheet, int rowNumber, ReaderConfig<RT> readerConfig) {
        RT instance = readerConfig.getCastClassInstance();
        Row row = sheet.getRow(rowNumber);
        if (row == null || this.blankRowCheck(row)) {
            if (readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.INCLUDE_EMPTY_ROW)) {
                return instance;
            }
            return null;
        }
        this.convertCellToInstance(row, instance, readerConfig);
        return instance;
    }

    private boolean blankRowCheck(Row row) {
        int isAllBlank = 0;
        int lastCellNum = row.getLastCellNum();
        for (int i = 0; i < lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() == CellType.BLANK) {
                ++isAllBlank;
                continue;
            }
            return false;
        }
        boolean blankRow = isAllBlank == lastCellNum;
        LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)String.format("\u884c[%s]\u6570\u636e\u4e3a\u7a7a", row.getRowNum()));
        return blankRow;
    }

    private <RT> void convertCellToInstance(Row row, RT instance, ReaderConfig<RT> readerConfig) {
        if (instance instanceof Map) {
            this.row2MapInstance((Map)instance, row, readerConfig);
        } else {
            this.row2SimplePOJO(instance, row, readerConfig);
        }
    }

    private <RT> void row2SimplePOJO(RT instance, Row row, ReaderConfig<RT> readerConfig) {
        this.convertPositionCellToInstance(instance, readerConfig, row.getSheet());
        List<EntityCellMappingInfo<?>> indexMappingInfos = readerConfig.getIndexMappingInfos();
        for (EntityCellMappingInfo<?> indexMappingInfo : indexMappingInfos) {
            this.workBookContext.setCurrentReadRowIndex(row.getRowNum());
            this.workBookContext.setCurrentReadColumnIndex(indexMappingInfo.getColumnPosition());
            CellGetInfo cellValue = this.getCellOriginalValue(row, indexMappingInfo.getColumnPosition(), indexMappingInfo);
            Object adaptiveValue = this.adaptiveCellValue2EntityClass(cellValue, indexMappingInfo, readerConfig);
            this.assignValueToField(instance, adaptiveValue, indexMappingInfo, readerConfig);
        }
        this.validateConvertEntity(instance, readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.VALIDATE_READ_ROW_DATA));
    }

    private void convertPositionCellToInstance(Object instance, ReaderConfig<?> readerConfig, Sheet sheet) {
        List<EntityCellMappingInfo<?>> positionMappingInfos = readerConfig.getPositionMappingInfos();
        for (EntityCellMappingInfo<?> positionMappingInfo : positionMappingInfos) {
            this.workBookContext.setCurrentReadRowIndex(positionMappingInfo.getRowPosition());
            this.workBookContext.setCurrentReadColumnIndex(positionMappingInfo.getColumnPosition());
            CellGetInfo cellValue = this.getPositionCellOriginalValue(sheet, positionMappingInfo);
            Object adaptiveValue = this.adaptiveCellValue2EntityClass(cellValue, positionMappingInfo, readerConfig);
            this.assignValueToField(instance, adaptiveValue, positionMappingInfo, readerConfig);
        }
    }

    private void assignValueToField(Object instance, Object adaptiveValue, EntityCellMappingInfo<?> mappingInfo, ReaderConfig<?> readerConfig) {
        Field field = instance.getClass().getDeclaredField(mappingInfo.getFieldName());
        field.setAccessible(true);
        Object o = field.get(instance);
        if (o != null) {
            if (readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.FIELD_EXIST_OVERRIDE)) {
                field.set(instance, adaptiveValue);
            }
        } else {
            field.set(instance, adaptiveValue);
        }
    }

    private Object adaptiveCellValue2EntityClass(CellGetInfo info, EntityCellMappingInfo<?> mappingInfo, ReaderConfig<?> readerConfig) {
        if (mappingInfo.getDataCastAdapter() == AutoAdapter.class) {
            AutoAdapter autoAdapter = AutoAdapter.instance();
            return this.adaptiveValue(autoAdapter, info, mappingInfo, readerConfig);
        }
        Class<DataCastAdapter<?>> dataCastAdapterClass = mappingInfo.getDataCastAdapter();
        if (dataCastAdapterClass != null && !dataCastAdapterClass.isInterface()) {
            try {
                DataCastAdapter<Object> adapter = dataCastAdapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return this.adaptiveValue(adapter, info, mappingInfo, readerConfig);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.CONVERT_FIELD_ERROR, (Throwable)e);
            }
        }
        throw new AxolotlExcelReadException(mappingInfo, String.format("[%s]\u5b57\u6bb5\u8bf7\u914d\u7f6e\u9002\u914d\u5668,\u5b57\u6bb5\u7c7b\u578b:[%s]", mappingInfo.getFieldName(), mappingInfo.getFieldType()));
    }

    private Object adaptiveValue(DataCastAdapter<Object> adapter, CellGetInfo info, EntityCellMappingInfo<Object> mappingInfo, ReaderConfig<Object> readerConfig) {
        if (adapter == null) {
            throw new AxolotlExcelReadException(mappingInfo, String.format("\u672a\u627e\u5230\u8f6c\u6362\u7684\u7c7b\u578b:[%s->%s],\u5b57\u6bb5:[%s]", info.getCellType(), mappingInfo.getFieldType(), mappingInfo.getFieldName()));
        }
        if (adapter instanceof AbstractDataCastAdapter) {
            AbstractDataCastAdapter abstractDataCastAdapter = (AbstractDataCastAdapter)adapter;
            abstractDataCastAdapter.setReaderConfig(readerConfig);
            abstractDataCastAdapter.setEntityCellMappingInfo(mappingInfo);
            return this.castValue(abstractDataCastAdapter, info, mappingInfo);
        }
        return this.castValue(adapter, info, mappingInfo);
    }

    private Object castValue(DataCastAdapter<Object> adapter, CellGetInfo info, EntityCellMappingInfo<Object> mappingInfo) {
        if (!adapter.support(info.getCellType(), mappingInfo.getFieldType())) {
            throw new AxolotlExcelReadException(mappingInfo, String.format("\u4e0d\u652f\u6301\u8f6c\u6362\u7684\u7c7b\u578b:[%s->%s],\u5b57\u6bb5:[%s]", info.getCellType(), mappingInfo.getFieldType(), mappingInfo.getFieldName()));
        }
        CastContext<Object> castContext = new CastContext<Object>(mappingInfo.getFieldType(), mappingInfo.getFormat(), this.workBookContext.getCurrentReadColumnIndex(), this.workBookContext.getCurrentReadRowIndex());
        return adapter.cast(info, castContext);
    }

    private CellGetInfo getPositionCellOriginalValue(Sheet sheet, EntityCellMappingInfo<?> mappingInfo) {
        Row row = sheet.getRow(mappingInfo.getRowPosition());
        if (row == null) {
            return this.getBlankCellValue(mappingInfo);
        }
        Cell cell = row.getCell(mappingInfo.getColumnPosition());
        if (cell == null) {
            return this.getBlankCellValue(mappingInfo);
        }
        return this.getCellOriginalValue(row, mappingInfo.getColumnPosition(), mappingInfo);
    }

    private CellGetInfo getCellOriginalValue(Row row, int index, EntityCellMappingInfo<?> mappingInfo) {
        if (mappingInfo == null) {
            mappingInfo = new EntityCellMappingInfo<String>(String.class);
            mappingInfo.setColumnPosition(index);
        }
        return this.getIndexCellValue(row, index, mappingInfo);
    }

    private CellGetInfo getIndexCellValue(Row row, int index, EntityCellMappingInfo<?> mappingInfo) {
        if (index < 0) {
            return this.getBlankCellValue(mappingInfo);
        }
        Cell cell = row.getCell(index);
        if (mappingInfo.getColumnPosition() == -1 || cell == null) {
            return this.getBlankCellValue(mappingInfo);
        }
        Object value = null;
        CellGetInfo cellGetInfo = new CellGetInfo();
        CellType cellType = cell.getCellType();
        cellGetInfo.setCellType(cellType);
        switch (cellType) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                cellGetInfo.set_cell(cell);
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                cellGetInfo = this.getFormulaCellValue(cell);
                return cellGetInfo;
            }
            case BLANK: {
                LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)String.format("\u7a7a\u767d\u5355\u5143\u683c\u4f4d\u7f6e:[%s]", this.workBookContext.getHumanReadablePosition()));
                return this.getBlankCellValue(mappingInfo);
            }
            default: {
                this.LOGGER.error("\u672a\u77e5\u7684\u5355\u5143\u683c\u7c7b\u578b:{},\u5355\u5143\u683c\u4f4d\u7f6e:[{}]", (Object)cell.getCellType(), (Object)this.workBookContext.getHumanReadablePosition());
            }
        }
        cellGetInfo.setAlreadyFillValue(true);
        cellGetInfo.setCellValue(value);
        return cellGetInfo;
    }

    private CellGetInfo getBlankCellValue(EntityCellMappingInfo<?> mappingInfo) {
        CellGetInfo cellGetInfo = new CellGetInfo();
        if (mappingInfo.fieldIsPrimitive()) {
            cellGetInfo.setCellValue(mappingInfo.fillDefaultPrimitiveValue(null));
        }
        return cellGetInfo;
    }

    private <RT> void row2MapInstance(Map<String, Object> instance, Row row, ReaderConfig<RT> readerConfig) {
        this.workBookContext.setCurrentReadRowIndex(row.getRowNum());
        row.cellIterator().forEachRemaining(cell -> {
            this.workBookContext.setCurrentReadColumnIndex(cell.getColumnIndex());
            int idx = cell.getColumnIndex() + 1;
            String key = "CELL_" + idx;
            instance.put(key, this.getCellOriginalValue(row, cell.getColumnIndex(), null).getCellValue());
            if (readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.USE_MAP_DEBUG)) {
                instance.put("CELL_TYPE_" + idx, cell.getCellType());
                if (cell.getCellType() == CellType.NUMERIC) {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        instance.put("CELL_TYPE_" + idx, cell.getCellType());
                        instance.put("CELL_DATE_" + idx, Time.regexTime((Date)cell.getDateCellValue()));
                    } else {
                        instance.put("CELL_TYPE_" + idx, cell.getCellType());
                    }
                } else {
                    instance.put("CELL_TYPE_" + idx, cell.getCellType());
                }
            }
        });
    }

    private <RT> void validateConvertEntity(RT instance, boolean isValidate) {
        Iterator iterator;
        Set validate;
        if (isValidate && !(validate = this.validator.validate(instance, new Class[0])).isEmpty() && (iterator = validate.iterator()).hasNext()) {
            ConstraintViolation constraintViolation = (ConstraintViolation)iterator.next();
            throw new AxolotlExcelReadException(this.workBookContext, constraintViolation.getMessage());
        }
    }

    private void preCheckAndFixReadConfig(ReaderConfig<?> readerConfig) {
        if (readerConfig == null) {
            String msg = "\u8bfb\u53d6\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a";
            this.LOGGER.error(msg);
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, msg);
        }
        int sheetIndex = readerConfig.getSheetIndex();
        if (sheetIndex < 0) {
            String msg = String.format("\u8bfb\u53d6\u7684sheet\u4e0d\u5b58\u5728[%s]", readerConfig.getSheetName() != null ? readerConfig.getSheetName() : Integer.valueOf(readerConfig.getSheetIndex()));
            if (readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.IGNORE_EMPTY_SHEET_ERROR)) {
                LoggerToolkitKt.warnWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)(msg + "\u5c06\u8fd4\u56de\u7a7a\u6570\u636e"));
                return;
            }
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, msg);
        }
        Class<?> castClass = readerConfig.getCastClass();
        if (castClass == null) {
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u8bfb\u53d6\u7684\u7c7b\u578b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (readerConfig.getStartIndex() < 0) {
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u8bfb\u53d6\u8d77\u59cb\u884c\u4e0d\u5f97\u5c0f\u4e8e0");
        }
        if (readerConfig.isReadAsObject() && !readerConfig.getIndexMappingInfos().isEmpty()) {
            String simpleName = ColumnBind.class.getSimpleName();
            LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)("\u8bfb\u53d6\u5bf9\u8c61\u65f6\u4e0d\u7528\u6307\u5b9a@" + simpleName + "\u6ce8\u89e3"));
        }
        if (readerConfig.getInitialRowPositionOffset() < 0) {
            this.LOGGER.warn("\u8bfb\u53d6\u7684\u521d\u59cb\u884c\u504f\u79fb\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u5c06\u88ab\u4fee\u6b63\u4e3a0");
            readerConfig.setInitialRowPositionOffset(0);
        }
        if (readerConfig.getEndIndex() < 0) {
            if (readerConfig.getEndIndex() != -1) {
                throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u8bfb\u53d6\u7ed3\u675f\u884c\u4e0d\u5f97\u5c0f\u4e8e0");
            }
            if (!readerConfig.isReadAsObject()) {
                this.LOGGER.info("\u672a\u8bbe\u7f6e\u8bfb\u53d6\u7684\u7ed3\u675f\u884c,\u5c06\u88ab\u9ed8\u8ba4\u4fee\u6b63\u4e3a\u8bfb\u53d6\u8be5\u8868\u6700\u5927\u884c\u6570");
            }
            readerConfig.setEndIndex(this.workBookContext.getWorkbook().getSheetAt(sheetIndex).getLastRowNum() + 1);
        }
    }

    private CellGetInfo getFormulaCellValue(Cell cell) {
        Object value;
        CellValue evaluated = this.workBookContext.getFormulaEvaluator().evaluate(cell);
        switch (evaluated.getCellType()) {
            case STRING: {
                value = evaluated.getStringValue();
                break;
            }
            case NUMERIC: {
                value = evaluated.getNumberValue();
                break;
            }
            case BOOLEAN: {
                value = evaluated.getBooleanValue();
                break;
            }
            default: {
                String msg = String.format("\u672a\u77e5\u7684\u516c\u5f0f\u5355\u5143\u683c\u7c7b\u578b\u4f4d\u7f6e:[%d,%d],\u5355\u5143\u683c\u7c7b\u578b:[%s],\u5355\u5143\u683c\u503c:[%s]", cell.getRowIndex(), cell.getColumnIndex(), evaluated.getCellType(), evaluated);
                this.LOGGER.error(msg);
                throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, msg);
            }
        }
        CellGetInfo cellGetInfo = new CellGetInfo(true, value);
        cellGetInfo.setCellType(evaluated.getCellType());
        return cellGetInfo;
    }

    public int getPhysicalRowNumber() {
        return this.getRowNumber(true);
    }

    public int getRecordRowNumber() {
        return this.getRowNumber(false);
    }

    public int getRowNumber(boolean isPhysical) {
        return this.getRowNumber(this._sheetLevelReaderConfig, isPhysical);
    }

    public int getRowNumber(ReaderConfig<?> readerConfig, boolean isPhysical) {
        return this.getRowNumber(readerConfig.getSheetIndex(), isPhysical);
    }

    public int getPhysicalRowNumber(ReaderConfig<?> readerConfig) {
        return this.getRowNumber(readerConfig.getSheetIndex(), true);
    }

    public int getRecordRowNumber(ReaderConfig<?> readerConfig) {
        return this.getRowNumber(readerConfig.getSheetIndex(), false);
    }

    public int getRowNumber(int sheetIndex, boolean isPhysical) {
        Sheet sheet = this.workBookContext.getWorkbook().getSheetAt(sheetIndex);
        if (isPhysical) {
            return sheet.getPhysicalNumberOfRows();
        }
        return sheet.getLastRowNum() + 1;
    }

    public String getHumanReadablePosition() {
        return this.workBookContext.getHumanReadablePosition();
    }

    public WorkBookContext getWorkBookContext() {
        return this.workBookContext;
    }
}

