/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader.support.adapters;

import cn.toutatis.xvoid.axolotl.excel.reader.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CellGetInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.support.DataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.adapters.AbstractDataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;

public class DefaultBooleanAdapter
extends AbstractDataCastAdapter<Boolean>
implements DataCastAdapter<Boolean> {
    private static final Map<Object, Boolean> trueFalseMap = new HashMap<Object, Boolean>();

    @Override
    public Boolean cast(CellGetInfo cellGetInfo, CastContext<Boolean> context) {
        if (!cellGetInfo.isAlreadyFillValue()) {
            return (Boolean)cellGetInfo.getCellValue();
        }
        switch (cellGetInfo.getCellType()) {
            case BOOLEAN: {
                return (Boolean)cellGetInfo.getCellValue();
            }
            case STRING: {
                String cellValue = (String)cellGetInfo.getCellValue();
                String upperCase = cellValue.toUpperCase();
                return trueFalseMap.getOrDefault(upperCase, false);
            }
            case NUMERIC: {
                if (!(cellGetInfo.getCellValue() instanceof Number)) break;
                Object cellGetInfoCellValue = cellGetInfo.getCellValue();
                return ((Number)cellGetInfoCellValue).intValue() == 1;
            }
        }
        throw new AxolotlExcelReadException(context, String.format("\u65e0\u6cd5\u5c06\u503c[%s]\u8f6c\u6362\u4e3a\u5e03\u5c14\u503c", cellGetInfo.getCellValue()));
    }

    @Override
    public boolean support(CellType cellType, Class<Boolean> clazz) {
        return true;
    }

    static {
        trueFalseMap.put("TRUE", true);
        trueFalseMap.put("FALSE", false);
        trueFalseMap.put("1", true);
        trueFalseMap.put("0", false);
        trueFalseMap.put("\u662f", true);
        trueFalseMap.put("\u5426", false);
        trueFalseMap.put("ON", true);
        trueFalseMap.put("OFF", false);
    }
}

