/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader.support.adapters;

import cn.toutatis.xvoid.axolotl.excel.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.RowLevelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CellGetInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.support.DataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.adapters.AbstractDataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.toolkit.constant.Regex;
import cn.toutatis.xvoid.toolkit.constant.Time;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

public class DefaultDateTimeAdapter<NT>
extends AbstractDataCastAdapter<NT>
implements DataCastAdapter<NT> {
    private final Class<NT> dateClass;

    public DefaultDateTimeAdapter(Class<NT> dateClass) {
        this.dateClass = dateClass;
    }

    @Override
    public NT cast(CellGetInfo cellGetInfo, CastContext<NT> context) {
        Object cellValue = cellGetInfo.getCellValue();
        if (!cellGetInfo.isAlreadyFillValue()) {
            return null;
        }
        ReaderConfig<?> readerConfig = this.getReaderConfig();
        EntityCellMappingInfo<?> entityCellMappingInfo = this.getEntityCellMappingInfo();
        Map<RowLevelReadPolicy, Object> excelPolicies = entityCellMappingInfo.getExcludePolicies();
        switch (cellGetInfo.getCellType()) {
            case STRING: {
                if (this.dateClass == LocalDateTime.class) {
                    LocalDateTime localDateTime;
                    if (!excelPolicies.containsKey((Object)RowLevelReadPolicy.TRIM_CELL_VALUE) && readerConfig.getReadPolicyAsBoolean(RowLevelReadPolicy.TRIM_CELL_VALUE)) {
                        cellValue = Regex.convertSingleLine((String)cellValue.toString());
                    }
                    if (cellValue.toString().length() != context.getDataFormat().length()) {
                        throw new AxolotlExcelReadException(context, String.format("\u8bf7\u6307\u5b9a\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f,\u83b7\u53d6\u4e3a:[%s],\u5c1d\u8bd5\u8f6c\u6362\u4e3a:[%s]", cellValue, context.getDataFormat()));
                    }
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(context.getDataFormat());
                    try {
                        localDateTime = LocalDateTime.parse((CharSequence)cellValue, formatter);
                    }
                    catch (DateTimeParseException timeParseException) {
                        if (timeParseException.getMessage().contains("Unable to obtain LocalDateTime from")) {
                            localDateTime = LocalDate.parse(cellValue.toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd")).atStartOfDay();
                        }
                        throw timeParseException;
                    }
                    return this.dateClass.cast(localDateTime);
                }
                if (this.dateClass == Date.class) {
                    SimpleDateFormat format = new SimpleDateFormat(context.getDataFormat());
                    try {
                        Date date = Time.parseData((SimpleDateFormat)format, (String)cellValue.toString());
                        return this.dateClass.cast(date);
                    }
                    catch (Exception parseException) {
                        throw new AxolotlExcelReadException(context, String.format("\u8bf7\u6307\u5b9a\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f,\u83b7\u53d6\u4e3a:[%s],\u5c1d\u8bd5\u8f6c\u6362\u4e3a:[%s]", cellValue, context.getDataFormat()));
                    }
                }
            }
            case NUMERIC: {
                if (DateUtil.isValidExcelDate((double)((Double)cellValue))) {
                    Date javaDate = DateUtil.getJavaDate((double)((Double)cellValue));
                    if (this.dateClass == Date.class) {
                        return this.dateClass.cast(javaDate);
                    }
                    if (this.dateClass == LocalDateTime.class) {
                        Instant instant = javaDate.toInstant();
                        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                        return this.dateClass.cast(zonedDateTime.toLocalDateTime());
                    }
                } else {
                    throw new AxolotlExcelReadException(context, String.format("\u8bfb\u53d6\u503c[%s]\u65e0\u6cd5\u8f6c\u6362\u65e5\u671f\u683c\u5f0f,\u8bf7\u81ea\u884c\u8f6c\u6362\u683c\u5f0f", cellValue));
                }
            }
            case BLANK: {
                return null;
            }
        }
        throw new AxolotlExcelReadException(context, String.format("\u5355\u5143\u683c\u4f4d\u7f6e:[%s]\u8bfb\u53d6\u7c7b\u578b[%s]\u65e0\u6cd5\u8f6c\u6362\u65e5\u671f\u683c\u5f0f", context.getHumanReadablePosition(), cellGetInfo.getCellType()));
    }

    @Override
    public boolean support(CellType cellType, Class<NT> clazz) {
        return clazz == Date.class || clazz == LocalDateTime.class;
    }
}

