/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel;

import cn.toutatis.xvoid.axolotl.excel.reader.support.AbstractContext;
import cn.toutatis.xvoid.axolotl.excel.reader.support.ExcelToolkit;
import cn.toutatis.xvoid.axolotl.toolkit.tika.DetectResult;
import com.google.common.collect.HashBasedTable;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;

public class WorkBookContext
extends AbstractContext {
    private Workbook workbook;
    private FormulaEvaluator formulaEvaluator;
    private int currentReadRowIndex = -1;
    private int currentReadColumnIndex = -1;
    private byte[] dataCache;
    private boolean _eventDriven = false;

    public WorkBookContext(File file, DetectResult detectResult) {
        this.setFile(file);
        this.setDataCache(Files.toByteArray((File)file));
        this.setMimeType(detectResult.getCatchMimeType());
    }

    public WorkBookContext(InputStream ins, DetectResult detectResult) {
        this.setDataCache(ByteStreams.toByteArray((InputStream)ins));
        this.setMimeType(detectResult.getCatchMimeType());
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public static void main(String[] args) {
        HashMap<Integer, HashBasedTable> workbookHeaders = new HashMap<Integer, HashBasedTable>();
        HashBasedTable sheetHeader = HashBasedTable.create();
        sheetHeader.put((Object)"\u59d3\u540d", (Object)0, (Object)1);
        sheetHeader.put((Object)"\u59d3\u540d", (Object)1, (Object)1);
        workbookHeaders.put(2, sheetHeader);
        System.err.println(workbookHeaders);
    }

    public FormulaEvaluator getFormulaEvaluator() {
        if (this.formulaEvaluator == null) {
            this.formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        }
        return this.formulaEvaluator;
    }

    public boolean getEventDriven() {
        return this._eventDriven;
    }

    public void setEventDriven() {
        this._eventDriven = true;
    }

    public void setCurrentReadRowIndex(int currentReadRowIndex) {
        this.currentReadRowIndex = currentReadRowIndex;
    }

    public void setCurrentReadColumnIndex(int currentReadColumnIndex) {
        this.currentReadColumnIndex = currentReadColumnIndex;
    }

    public String getHumanReadablePosition() {
        return ExcelToolkit.getHumanReadablePosition(this.currentReadRowIndex, this.currentReadColumnIndex);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public int getCurrentReadRowIndex() {
        return this.currentReadRowIndex;
    }

    public int getCurrentReadColumnIndex() {
        return this.currentReadColumnIndex;
    }

    public void setDataCache(byte[] dataCache) {
        this.dataCache = dataCache;
    }

    public byte[] getDataCache() {
        return this.dataCache;
    }
}

