/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.toolkit.tika;

import cn.toutatis.xvoid.axolotl.common.CommonMimeType;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.axolotl.toolkit.tika.DetectResult;
import cn.toutatis.xvoid.toolkit.file.FileToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;

public class TikaShell {
    private static final Logger LOGGER = LoggerToolkit.getLogger(TikaShell.class);
    private static final Tika tika = new Tika();
    public static final MimeType MS_EXCEL = CommonMimeType.MS_EXCEL;
    public static final MimeType OOXML_EXCEL = CommonMimeType.OOXML_EXCEL;

    public static DetectResult detect(File file, MimeType mimeType) {
        return TikaShell.detect(file, mimeType, false);
    }

    public static DetectResult detect(File file, MimeType mimeType, boolean alreadyPreCheck) {
        return TikaShell.detect(file, mimeType, false, alreadyPreCheck);
    }

    public static DetectResult detectThrowException(File file, MimeType mimeType) {
        return TikaShell.detect(file, mimeType, true, false);
    }

    public static DetectResult detect(File file, MimeType wantedMimeType, boolean throwException, boolean alreadyPreCheck) {
        DetectResult preCheck = alreadyPreCheck ? new DetectResult(true) : TikaShell.preCheckFileNormal(file);
        if (preCheck.isDetect()) {
            DetectResult detectResult = new DetectResult(false);
            detectResult.setWantedMimeType(wantedMimeType);
            String fileSuffix = '.' + FileToolkit.getFileSuffix((File)file).toLowerCase();
            List extensions = wantedMimeType.getExtensions();
            int idx = -1;
            for (int i = 0; i < extensions.size(); ++i) {
                String extension = (String)extensions.get(i);
                if (!extension.equalsIgnoreCase(fileSuffix)) continue;
                idx = i;
                break;
            }
            LOGGER.debug("\u6587\u4ef6\u540e\u7f00\uff1a[" + fileSuffix + "], \u53ef\u5339\u914d\u7684\u540e\u7f00\uff1a" + wantedMimeType.getExtensions() + ", \u5339\u914d\u7684\u540e\u7f00\u7d22\u5f15\uff1a[" + idx + "]");
            if (idx == -1) {
                String msg = "[" + file.getName() + "]\u6587\u4ef6\u540e\u7f00\u4e0d\u5339\u914d";
                detectResult.setCurrentFileStatus(DetectResult.FileStatus.FILE_SUFFIX_PROBLEM);
                if (throwException) {
                    throw new IOException(msg);
                }
                return detectResult.returnInfo(msg);
            }
            String detect = tika.detect(file);
            return TikaShell.matchMimeType(detect, wantedMimeType, throwException);
        }
        if (throwException) {
            throw new IOException(preCheck.getMessage());
        }
        return preCheck;
    }

    public static DetectResult detect(InputStream ins, MimeType wantedMimeType, boolean throwException) {
        if (wantedMimeType == null) {
            throw new IllegalArgumentException("\u671f\u671b\u5a92\u4f53\u7c7b\u578b\u4e3a\u7a7a");
        }
        ByteArrayOutputStream dataCacheOutputStream = new ByteArrayOutputStream();
        ByteStreams.copy((InputStream)ins, (OutputStream)dataCacheOutputStream);
        String detectMimeTypeString = tika.detect((InputStream)new ByteArrayInputStream(dataCacheOutputStream.toByteArray()));
        if (wantedMimeType == CommonMimeType.MS_EXCEL || wantedMimeType == CommonMimeType.OOXML_EXCEL) {
            if (CommonMimeType.ZIP.toString().equals(detectMimeTypeString)) {
                try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(dataCacheOutputStream.toByteArray()));){
                    ZipEntry entry;
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        if (entry.isDirectory() || !entry.getName().equals("[Content_Types].xml")) continue;
                        ByteArrayOutputStream tmpOutputStream = new ByteArrayOutputStream();
                        ByteStreams.copy((InputStream)zipInputStream, (OutputStream)tmpOutputStream);
                        String fileContent = new String(tmpOutputStream.toByteArray(), StandardCharsets.UTF_8);
                        if (!fileContent.contains(wantedMimeType.toString())) continue;
                        detectMimeTypeString = wantedMimeType.toString();
                    }
                }
            } else if (CommonMimeType.TIKA_OOXML_EXCEL.toString().equals(detectMimeTypeString)) {
                detectMimeTypeString = CommonMimeType.OOXML_EXCEL.toString();
            } else if (CommonMimeType.TIKA_MS_EXCEL.toString().equals(detectMimeTypeString)) {
                detectMimeTypeString = CommonMimeType.MS_EXCEL.toString();
            } else {
                String msg = "\u6d41\u4e0d\u662fExcel\u6587\u4ef6";
                if (throwException) {
                    throw new IOException(msg);
                }
                DetectResult detectResult = new DetectResult(false);
                detectResult.setWantedMimeType(wantedMimeType);
                detectResult.returnInfo(msg);
            }
        }
        try {
            return TikaShell.matchMimeType(detectMimeTypeString, wantedMimeType, throwException);
        }
        catch (IOException e) {
            String msg = "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25";
            if (throwException) {
                throw new IOException(msg);
            }
            LOGGER.error(msg, (Throwable)e);
            DetectResult detectResult = new DetectResult(false, DetectResult.FileStatus.FILE_SELF_PROBLEM, msg);
            detectResult.setWantedMimeType(wantedMimeType);
            return detectResult;
        }
    }

    private static DetectResult matchMimeType(String detectMimeTypeString, MimeType wantedMimeType, boolean throwException) throws MimeTypeException, IOException {
        MimeType detectMimeType = MimeTypes.getDefaultMimeTypes().forName(detectMimeTypeString);
        LoggerHelper.debug(LOGGER, LoggerHelper.format("\u6587\u4ef6\u5a92\u4f53\u7c7b\u578b\uff1a%s \u671f\u671b\u5a92\u4f53\u7c7b\u578b\uff1a%s", detectMimeTypeString, wantedMimeType));
        DetectResult detectResult = new DetectResult(false);
        if (!detectMimeType.equals((Object)wantedMimeType)) {
            detectResult.setCatchMimeType(detectMimeType);
            detectResult.setCurrentFileStatus(DetectResult.FileStatus.FILE_MIME_TYPE_PROBLEM);
            String msg = "\u6587\u4ef6\u5a92\u4f53\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5a92\u4f53\u7c7b\u578b\uff1a" + detectMimeTypeString + ", \u671f\u671b\u5a92\u4f53\u7c7b\u578b\uff1a" + wantedMimeType;
            if (throwException) {
                throw new IOException(msg);
            }
            return detectResult.returnInfo(msg);
        }
        detectResult = new DetectResult(true, detectMimeType);
        return detectResult;
    }

    public static MimeType getMimeType(File file) {
        DetectResult preCheck = TikaShell.preCheckFileNormal(file);
        if (preCheck.isDetect()) {
            try {
                return MimeTypes.getDefaultMimeTypes().forName(tika.detect(file));
            }
            catch (IOException | MimeTypeException e) {
                String msg = "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25";
                LOGGER.error(file.getName() + msg, e);
                throw new IOException(msg);
            }
        }
        LOGGER.error(file.getName() + preCheck.getMessage());
        throw new IOException(preCheck.getMessage());
    }

    public static DetectResult preCheckFileNormalThrowException(File file) {
        return TikaShell.preCheckFileNormal(file, true);
    }

    public static DetectResult preCheckFileNormal(File file) {
        return TikaShell.preCheckFileNormal(file, false);
    }

    public static DetectResult preCheckFileNormal(File file, boolean throwException) {
        if (file == null || !file.exists()) {
            String msg = "\u6587\u4ef6\u4e0d\u5b58\u5728";
            if (throwException) {
                throw new FileNotFoundException(msg);
            }
            return new DetectResult(false, DetectResult.FileStatus.FILE_SELF_PROBLEM, msg);
        }
        if (file.isDirectory()) {
            String msg = "\u9009\u62e9\u6587\u4ef6\u4e0d\u80fd\u662f\u76ee\u5f55";
            if (throwException) {
                throw new IOException(msg);
            }
            return new DetectResult(false, DetectResult.FileStatus.FILE_SELF_PROBLEM, msg);
        }
        return new DetectResult(true);
    }
}

