/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader;

import cn.toutatis.xvoid.axolotl.excel.reader.ReadConfigBuilder;
import cn.toutatis.xvoid.axolotl.excel.reader.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.reader.support.AxolotlAbstractExcelReader;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;

public class AxolotlExcelReader<T>
extends AxolotlAbstractExcelReader<T>
implements Iterator<List<T>> {
    private final Logger LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);
    private int currentReadBatch = -1;

    public AxolotlExcelReader(File excelFile) {
        super(excelFile);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER;
    }

    public AxolotlExcelReader(File excelFile, boolean withDefaultConfig) {
        super(excelFile, withDefaultConfig);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER;
    }

    public AxolotlExcelReader(File excelFile, Class<T> clazz) {
        super(excelFile, clazz);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER;
    }

    public AxolotlExcelReader(InputStream ins) {
        super(ins);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER;
    }

    public AxolotlExcelReader(InputStream ins, Class<T> clazz) {
        super(ins, clazz);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER;
    }

    public AxolotlExcelReader(File excelFile, Class<T> clazz, boolean withDefaultConfig) {
        super(excelFile, clazz, withDefaultConfig);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER;
    }

    @Override
    public boolean hasNext() {
        return this.currentReadBatch * 200 < this.getRecordRowNumber();
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
        }
        ++this.currentReadBatch;
        LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)("\u8bfb\u53d6\u6570\u636e\u884c\u6570:" + this.currentReadBatch * 200));
        return this.readSheetData(this.currentReadBatch * 200, (this.currentReadBatch + 1) * 200);
    }

    public List<T> readSheetData() {
        return this.readSheetData(0);
    }

    public List<T> readSheetData(int start) {
        return this.readSheetData(this._sheetLevelReaderConfig.getSheetName(), this._sheetLevelReaderConfig.getSheetIndex(), 0, this.getRecordRowNumber(), start);
    }

    public List<T> readSheetData(int start, int end) {
        return this.readSheetData(this._sheetLevelReaderConfig.getSheetName(), this._sheetLevelReaderConfig.getSheetIndex(), start, end, 0);
    }

    public List<T> readSheetData(int start, int end, int initialRowPositionOffset) {
        return this.readSheetData(this._sheetLevelReaderConfig.getSheetName(), this._sheetLevelReaderConfig.getSheetIndex(), start, end, initialRowPositionOffset);
    }

    protected List<T> readSheetData(String sheetName, int sheetIndex, int start, int end, int initialRowPositionOffset) {
        this._sheetLevelReaderConfig.setSheetName(sheetName);
        this._sheetLevelReaderConfig.setSheetIndex(sheetIndex);
        this._sheetLevelReaderConfig.setStartIndex(start);
        this._sheetLevelReaderConfig.setEndIndex(end);
        this._sheetLevelReaderConfig.setInitialRowPositionOffset(initialRowPositionOffset);
        return this.readSheetData(this._sheetLevelReaderConfig);
    }

    public <RT> List<RT> readSheetData(Class<RT> castClass, String sheetName) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, true);
        configBuilder.setSheetName(sheetName);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetData(Class<RT> castClass, int sheetIndex) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, true);
        configBuilder.setSheetIndex(sheetIndex);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetDataOffset(Class<RT> castClass, int initialRowPositionOffset) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, true);
        configBuilder.setInitialRowPositionOffset(initialRowPositionOffset);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetData(Class<RT> castClass) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, true);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetData(Class<RT> castClass, int sheetIndex, boolean withDefaultConfig, int startIndex, int endIndex, int initialRowPositionOffset) {
        ReadConfigBuilder<RT> configBuilder = new ReadConfigBuilder<RT>(castClass, withDefaultConfig);
        configBuilder.setSheetIndex(sheetIndex).setStartIndex(startIndex).setEndIndex(endIndex).setInitialRowPositionOffset(initialRowPositionOffset);
        return this.readSheetData(configBuilder);
    }

    public <RT> List<RT> readSheetData(ReadConfigBuilder<RT> configBuilder) {
        return this.readSheetData(configBuilder.build());
    }

    public <RT> List<RT> readSheetData(ReaderConfig<RT> readerConfig) {
        ArrayList readResult = new ArrayList();
        Sheet sheet = this.searchSheet(readerConfig);
        this.preCheckAndFixReadConfig(readerConfig);
        if (sheet == null) {
            return readResult;
        }
        this.spreadMergedCells(sheet);
        this.readSheetData(sheet, readerConfig, readResult);
        return readResult;
    }

    private <RT> void readSheetData(Sheet sheet, ReaderConfig<RT> readerConfig, List<RT> list) {
        int initialRowPositionOffset;
        int startIndex = readerConfig.getStartIndex();
        int endIndex = readerConfig.getEndIndex();
        if (startIndex == 0 && (initialRowPositionOffset = readerConfig.getInitialRowPositionOffset()) > 0) {
            this.LOGGER.debug("\u8df3\u8fc7\u524d{}\u884c", (Object)initialRowPositionOffset);
            startIndex += initialRowPositionOffset;
        }
        this.searchHeaderCellPosition(readerConfig);
        for (int i = startIndex; i < endIndex; ++i) {
            RT instance = this.readRow(sheet, i, readerConfig);
            if (instance == null) continue;
            list.add(instance);
        }
    }
}

