/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader.support;

import cn.toutatis.xvoid.axolotl.excel.reader.ReadConfigBuilder;
import cn.toutatis.xvoid.axolotl.excel.reader.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.reader.WorkBookContext;
import cn.toutatis.xvoid.axolotl.excel.reader.annotations.ColumnBind;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.EntityCellMappingInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.ExcelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CastContext;
import cn.toutatis.xvoid.axolotl.excel.reader.support.CellGetInfo;
import cn.toutatis.xvoid.axolotl.excel.reader.support.DataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.adapters.AbstractDataCastAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.adapters.AutoAdapter;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.axolotl.toolkit.ExcelToolkit;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.axolotl.toolkit.tika.DetectResult;
import cn.toutatis.xvoid.axolotl.toolkit.tika.TikaShell;
import cn.toutatis.xvoid.toolkit.constant.Time;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import com.google.common.collect.HashBasedTable;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;
import org.apache.tika.mime.MimeType;
import org.slf4j.Logger;

public abstract class AxolotlAbstractExcelReader<T> {
    protected Logger LOGGER = LoggerToolkit.getLogger((String)"Axolotl");
    protected WorkBookContext workBookContext;
    protected Validator validator;
    protected ReaderConfig<T> _sheetLevelReaderConfig;

    public AxolotlAbstractExcelReader(File excelFile) {
        this(excelFile, true);
    }

    public AxolotlAbstractExcelReader(File excelFile, boolean withDefaultConfig) {
        this(excelFile, Object.class, withDefaultConfig);
    }

    public AxolotlAbstractExcelReader(File excelFile, Class<T> clazz) {
        this(excelFile, clazz, true);
    }

    public AxolotlAbstractExcelReader(InputStream ins) {
        this(ins, Object.class);
    }

    public AxolotlAbstractExcelReader(InputStream ins, Class<T> clazz) {
        if (ins == null) {
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u6587\u4ef6\u6d41\u4e3a\u7a7a");
        }
        ByteArrayOutputStream dataCacheOutputStream = new ByteArrayOutputStream();
        try {
            ByteStreams.copy((InputStream)ins, (OutputStream)dataCacheOutputStream);
            ins.close();
        }
        catch (IOException e) {
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, e.getMessage());
        }
        DetectResult detectResult = this.checkFileFormat(null, new ByteArrayInputStream(dataCacheOutputStream.toByteArray()));
        this.workBookContext = new WorkBookContext(new ByteArrayInputStream(dataCacheOutputStream.toByteArray()), detectResult);
        this.loadFileDataToWorkBook();
        this._sheetLevelReaderConfig = new ReaderConfig<T>(clazz, true);
        this.createAdditionalExtensions();
    }

    public AxolotlAbstractExcelReader(File excelFile, Class<T> clazz, boolean withDefaultConfig) {
        if (clazz == null) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u7684\u7c7b\u578b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DetectResult predCheckFileNormal = TikaShell.preCheckFileNormal(excelFile);
        if (!predCheckFileNormal.isDetect()) {
            predCheckFileNormal.throwException();
        }
        DetectResult detectResult = this.checkFileFormat(excelFile, null);
        this.workBookContext = new WorkBookContext(excelFile, detectResult);
        this.loadFileDataToWorkBook();
        this._sheetLevelReaderConfig = new ReaderConfig<T>(clazz, withDefaultConfig);
        this.createAdditionalExtensions();
    }

    protected void createAdditionalExtensions() {
        try (ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();){
            this.validator = validatorFactory.getValidator();
        }
    }

    protected DetectResult checkFileFormat(File file, InputStream ins) {
        DetectResult detectResult = this.getFileOrStreamDetectResult(file, ins, TikaShell.OOXML_EXCEL);
        if (!detectResult.isDetect()) {
            DetectResult.FileStatus currentFileStatus = detectResult.getCurrentFileStatus();
            if (currentFileStatus == DetectResult.FileStatus.FILE_MIME_TYPE_PROBLEM || currentFileStatus == DetectResult.FileStatus.FILE_SUFFIX_PROBLEM) {
                detectResult = this.getFileOrStreamDetectResult(file, ins, TikaShell.MS_EXCEL);
            } else {
                detectResult.throwException();
            }
        }
        if (!detectResult.isDetect()) {
            detectResult.throwException();
        }
        return detectResult;
    }

    protected DetectResult getFileOrStreamDetectResult(File file, InputStream ins, MimeType mimeType) {
        DetectResult detectResult = file == null ? TikaShell.detect(ins, mimeType, false) : TikaShell.detect(file, mimeType, true);
        return detectResult;
    }

    protected void loadFileDataToWorkBook() {
        try (ByteArrayInputStream fis = new ByteArrayInputStream(this.workBookContext.getDataCache());){
            Workbook workbook;
            if (this.workBookContext.getMimeType() == TikaShell.OOXML_EXCEL) {
                IOUtils.setByteArrayMaxOverride((int)200000000);
                this.workBookContext.setEventDriven();
                OPCPackage opcPackage = OPCPackage.open((InputStream)fis);
                workbook = XSSFWorkbookFactory.createWorkbook((OPCPackage)opcPackage);
                opcPackage.close();
                IOUtils.setByteArrayMaxOverride((int)-1);
            } else {
                workbook = WorkbookFactory.create((InputStream)fis);
            }
            this.workBookContext.setWorkbook(workbook);
        }
        catch (IOException | InvalidFormatException | RecordFormatException e) {
            this.LOGGER.error("\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25", e);
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, e.getMessage());
        }
    }

    public <RT> RT readSheetDataAsObject(ReadConfigBuilder<RT> readerConfigBuilder) {
        return this.readSheetDataAsObject(readerConfigBuilder.build());
    }

    public <RT> RT readSheetDataAsObject(ReaderConfig<RT> readerConfig) {
        if (readerConfig != null) {
            readerConfig.setReadAsObject(true);
        }
        assert (readerConfig != null);
        Sheet sheet = this.searchSheet(readerConfig);
        this.preCheckAndFixReadConfig(readerConfig);
        this.spreadMergedCells(sheet);
        RT instance = readerConfig.getCastClassInstance();
        this.convertPositionCellToInstance(instance, readerConfig, sheet);
        this.validateConvertEntity(instance, readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.VALIDATE_READ_ROW_DATA));
        return instance;
    }

    protected Sheet searchSheet(ReaderConfig<?> readerConfig) {
        Sheet sheet;
        if (readerConfig == null) {
            return null;
        }
        if (readerConfig.getSheetName() != null) {
            sheet = this.workBookContext.getWorkbook().getSheet(readerConfig.getSheetName());
            if (sheet != null) {
                readerConfig.setSheetIndex(sheet.getWorkbook().getSheetIndex(sheet));
            } else {
                readerConfig.setSheetIndex(-1);
            }
        } else {
            try {
                sheet = this.workBookContext.getIndexSheet(readerConfig.getSheetIndex());
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().contains("out of range")) {
                    throw e;
                }
                int numberOfSheets = this.workBookContext.getWorkbook().getNumberOfSheets() - 1;
                LoggerToolkitKt.warnWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)String.format("\u8868\u7d22\u5f15[%s]\u8d85\u51fa\u8303\u56f4[0-%s],\u5c06\u8fd4\u56de\u7a7a\u6570\u636e\u6216\u629b\u51fa\u5f02\u5e38", readerConfig.getSheetIndex(), numberOfSheets));
                sheet = null;
                readerConfig.setSheetIndex(-1);
            }
        }
        return sheet;
    }

    protected void spreadMergedCells(Sheet sheet) {
        List mergedRegions = sheet.getMergedRegions();
        LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)"\u5f00\u59cb\u5904\u7406\u5de5\u4f5c\u8868\u5408\u5e76\u5355\u5143\u683c");
        for (CellRangeAddress mergedRegion : mergedRegions) {
            int firstRow = mergedRegion.getFirstRow();
            int lastRow = mergedRegion.getLastRow();
            int firstColumn = mergedRegion.getFirstColumn();
            int lastColumn = mergedRegion.getLastColumn();
            Cell leftTopCell = sheet.getRow(firstRow).getCell(firstColumn);
            LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)String.format("\u5904\u7406\u5408\u5e76\u5355\u5143\u683c[%s]", mergedRegion.formatAsString()));
            for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
                block8: for (int columnIndex = firstColumn; columnIndex <= lastColumn; ++columnIndex) {
                    Row row = sheet.getRow(rowIndex);
                    Cell cell = row.getCell(columnIndex);
                    if (cell == null) {
                        cell = row.createCell(columnIndex, leftTopCell.getCellType());
                    }
                    switch (leftTopCell.getCellType()) {
                        case STRING: {
                            cell.setCellValue(leftTopCell.getStringCellValue());
                            continue block8;
                        }
                        case NUMERIC: {
                            cell.setCellValue(leftTopCell.getNumericCellValue());
                            continue block8;
                        }
                        case BOOLEAN: {
                            cell.setCellValue(leftTopCell.getBooleanCellValue());
                            continue block8;
                        }
                        case FORMULA: {
                            cell.setCellValue(leftTopCell.getCellFormula());
                        }
                    }
                }
            }
        }
    }

    protected void searchHeaderCellPosition(ReaderConfig<?> readerConfig) {
        if (readerConfig.getSheetIndex() == -1) {
            return;
        }
        Sheet sheet = this.workBookContext.getIndexSheet(readerConfig.getSheetIndex());
        if (sheet == null) {
            return;
        }
        List<EntityCellMappingInfo<?>> indexMappingInfos = readerConfig.getIndexMappingInfos();
        Map<String, Integer> headerKeys = indexMappingInfos.stream().map(EntityCellMappingInfo::getHeaderName).filter(Objects::nonNull).distinct().collect(Collectors.toMap(element -> element, i -> -1));
        if (!headerKeys.isEmpty()) {
            HashBasedTable<String, Integer, Integer> headerCache;
            Map<Integer, HashBasedTable<String, Integer, Integer>> headerCaches = this.workBookContext.getHeaderCaches();
            boolean hintCache = false;
            if (headerCaches.containsKey(readerConfig.getSheetIndex())) {
                LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u8868\u5934,\u6570\u91cf[%s]", headerKeys.size()));
                headerCache = headerCaches.get(readerConfig.getSheetIndex());
                hintCache = true;
            } else {
                LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u5f00\u59cb\u67e5\u627e\u8868\u5934,\u6570\u91cf[%s],\u67e5\u627e\u8868\u5934:%s", headerKeys.size(), headerKeys));
                headerCache = HashBasedTable.create();
            }
            int readHeadRows = readerConfig.getSearchHeaderMaxRows() > 0 ? readerConfig.getSearchHeaderMaxRows() : Math.min(this.getRecordRowNumber(readerConfig), 10);
            HashMap<String, Integer> notAlreadyRecordKeys = new HashMap<String, Integer>();
            if (hintCache) {
                Set alreadyRecordKeySet = headerCache.rowKeySet();
                headerKeys.keySet().stream().filter(headerKey -> !alreadyRecordKeySet.contains(headerKey)).forEach(headerKey -> notAlreadyRecordKeys.put((String)headerKey, 0));
            } else {
                notAlreadyRecordKeys.putAll(headerKeys);
            }
            if (!notAlreadyRecordKeys.isEmpty()) {
                for (int i2 = 0; i2 < readHeadRows; ++i2) {
                    Row row = sheet.getRow(i2);
                    if (!ExcelToolkit.notBlankRowCheck(row)) continue;
                    Iterator cellIterator = row.cellIterator();
                    while (cellIterator.hasNext()) {
                        String cellValue;
                        Cell cell = (Cell)cellIterator.next();
                        if (cell == null || cell.getCellType() != CellType.STRING || !headerKeys.containsKey(cellValue = cell.getStringCellValue()) || !notAlreadyRecordKeys.containsKey(cellValue)) continue;
                        LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u67e5\u627e\u5230\u8868\u5934[%s]", cellValue));
                        headerCache.put((Object)cellValue, (Object)(headerCache.row((Object)cellValue).size() + 1), (Object)cell.getColumnIndex());
                    }
                }
            }
            LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u67e5\u627e\u8868\u5934\u7ed3\u675f,\u6620\u5c04\u4fe1\u606f:%s", headerCache));
            if (!hintCache) {
                headerCaches.put(readerConfig.getSheetIndex(), headerCache);
            }
            for (EntityCellMappingInfo<?> indexMappingInfo : indexMappingInfos) {
                Integer columnIndex;
                String headerName = indexMappingInfo.getHeaderName();
                if (!StringUtils.isNotBlank((CharSequence)headerName)) continue;
                Map recordInfo = headerCache.row((Object)headerName);
                if (recordInfo.isEmpty()) {
                    if (readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.IGNORE_EMPTY_SHEET_HEADER_ERROR)) {
                        LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u8868\u5934[%s]\u4e0d\u5b58\u5728", headerName));
                        continue;
                    }
                    throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, LoggerHelper.format("\u8868\u5934[%s]\u4e0d\u5b58\u5728", headerName));
                }
                Integer assignedIndex = headerKeys.get(headerName);
                int headerNameIndex = indexMappingInfo.getHeaderNameIndex();
                if (headerNameIndex == -1) {
                    assignedIndex = assignedIndex == -1 ? Integer.valueOf(1) : Integer.valueOf(assignedIndex + 1);
                    columnIndex = recordInfo.getOrDefault(assignedIndex, -1);
                    LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u6620\u5c04\u540c\u540d\u8868\u5934[%s]\u5230\u5217[%s]", headerName, columnIndex));
                    headerKeys.put(headerName, assignedIndex);
                } else {
                    int idx = headerNameIndex + 1;
                    LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u6307\u5b9a\u540c\u540d\u8868\u5934[%s]\u5217\u4e3a[%s]", headerName, idx));
                    columnIndex = recordInfo.get(idx) != null ? (Integer)recordInfo.get(idx) : -1;
                }
                indexMappingInfo.setColumnPosition(columnIndex);
            }
        }
    }

    protected <RT> RT readRow(Sheet sheet, int rowNumber, ReaderConfig<RT> readerConfig) {
        RT instance = readerConfig.getCastClassInstance();
        Row row = sheet.getRow(rowNumber);
        if (ExcelToolkit.blankRowCheck(row)) {
            if (readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.INCLUDE_EMPTY_ROW)) {
                return instance;
            }
            return null;
        }
        this.convertCellToInstance(row, instance, readerConfig);
        return instance;
    }

    protected <RT> void convertCellToInstance(Row row, RT instance, ReaderConfig<RT> readerConfig) {
        if (instance instanceof Map) {
            this.row2MapInstance((Map)instance, row, readerConfig);
        } else {
            this.row2SimplePOJO(instance, row, readerConfig);
        }
    }

    protected <RT> void row2SimplePOJO(RT instance, Row row, ReaderConfig<RT> readerConfig) {
        this.convertPositionCellToInstance(instance, readerConfig, row.getSheet());
        List<EntityCellMappingInfo<?>> indexMappingInfos = readerConfig.getIndexMappingInfos();
        for (EntityCellMappingInfo<?> indexMappingInfo : indexMappingInfos) {
            this.workBookContext.setCurrentReadRowIndex(row.getRowNum());
            this.workBookContext.setCurrentReadColumnIndex(indexMappingInfo.getColumnPosition());
            CellGetInfo cellValue = this.getCellOriginalValue(row, indexMappingInfo.getColumnPosition(), indexMappingInfo);
            Object adaptiveValue = this.adaptiveCellValue2EntityClass(cellValue, indexMappingInfo, readerConfig);
            this.assignValueToField(instance, adaptiveValue, indexMappingInfo, readerConfig);
        }
        this.validateConvertEntity(instance, readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.VALIDATE_READ_ROW_DATA));
    }

    protected void convertPositionCellToInstance(Object instance, ReaderConfig<?> readerConfig, Sheet sheet) {
        List<EntityCellMappingInfo<?>> positionMappingInfos = readerConfig.getPositionMappingInfos();
        for (EntityCellMappingInfo<?> positionMappingInfo : positionMappingInfos) {
            this.workBookContext.setCurrentReadRowIndex(positionMappingInfo.getRowPosition());
            this.workBookContext.setCurrentReadColumnIndex(positionMappingInfo.getColumnPosition());
            CellGetInfo cellValue = this.getPositionCellOriginalValue(sheet, positionMappingInfo);
            Object adaptiveValue = this.adaptiveCellValue2EntityClass(cellValue, positionMappingInfo, readerConfig);
            this.assignValueToField(instance, adaptiveValue, positionMappingInfo, readerConfig);
        }
    }

    protected void assignValueToField(Object instance, Object adaptiveValue, EntityCellMappingInfo<?> mappingInfo, ReaderConfig<?> readerConfig) {
        Field field = instance.getClass().getDeclaredField(mappingInfo.getFieldName());
        field.setAccessible(true);
        Object o = field.get(instance);
        if (o != null) {
            if (readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.FIELD_EXIST_OVERRIDE)) {
                field.set(instance, adaptiveValue);
            }
        } else {
            field.set(instance, adaptiveValue);
        }
    }

    protected Object adaptiveCellValue2EntityClass(CellGetInfo info, EntityCellMappingInfo<?> mappingInfo, ReaderConfig<?> readerConfig) {
        if (mappingInfo.getDataCastAdapter() == AutoAdapter.class) {
            AutoAdapter autoAdapter = AutoAdapter.instance();
            return this.adaptiveValue(autoAdapter, info, mappingInfo, readerConfig);
        }
        Class<DataCastAdapter<?>> dataCastAdapterClass = mappingInfo.getDataCastAdapter();
        if (dataCastAdapterClass != null && !dataCastAdapterClass.isInterface()) {
            try {
                DataCastAdapter<Object> adapter = dataCastAdapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return this.adaptiveValue(adapter, info, mappingInfo, readerConfig);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.CONVERT_FIELD_ERROR, (Throwable)e);
            }
        }
        throw new AxolotlExcelReadException(mappingInfo, String.format("[%s]\u5b57\u6bb5\u8bf7\u914d\u7f6e\u9002\u914d\u5668,\u5b57\u6bb5\u7c7b\u578b:[%s]", mappingInfo.getFieldName(), mappingInfo.getFieldType()));
    }

    protected Object adaptiveValue(DataCastAdapter<Object> adapter, CellGetInfo info, EntityCellMappingInfo<Object> mappingInfo, ReaderConfig<Object> readerConfig) {
        if (adapter == null) {
            throw new AxolotlExcelReadException(mappingInfo, String.format("\u672a\u627e\u5230\u8f6c\u6362\u7684\u7c7b\u578b:[%s->%s],\u5b57\u6bb5:[%s]", info.getCellType(), mappingInfo.getFieldType(), mappingInfo.getFieldName()));
        }
        if (adapter instanceof AbstractDataCastAdapter) {
            AbstractDataCastAdapter abstractDataCastAdapter = (AbstractDataCastAdapter)adapter;
            abstractDataCastAdapter.setReaderConfig(readerConfig);
            abstractDataCastAdapter.setEntityCellMappingInfo(mappingInfo);
            return this.castValue(abstractDataCastAdapter, info, mappingInfo);
        }
        return this.castValue(adapter, info, mappingInfo);
    }

    protected Object castValue(DataCastAdapter<Object> adapter, CellGetInfo info, EntityCellMappingInfo<Object> mappingInfo) {
        if (!adapter.support(info.getCellType(), mappingInfo.getFieldType())) {
            throw new AxolotlExcelReadException(mappingInfo, String.format("\u4e0d\u652f\u6301\u8f6c\u6362\u7684\u7c7b\u578b:[%s->%s],\u5b57\u6bb5:[%s]", info.getCellType(), mappingInfo.getFieldType(), mappingInfo.getFieldName()));
        }
        CastContext<Object> castContext = new CastContext<Object>(mappingInfo.getFieldType(), mappingInfo.getFormat(), this.workBookContext.getCurrentReadColumnIndex(), this.workBookContext.getCurrentReadRowIndex());
        return adapter.cast(info, castContext);
    }

    protected CellGetInfo getPositionCellOriginalValue(Sheet sheet, EntityCellMappingInfo<?> mappingInfo) {
        Row row = sheet.getRow(mappingInfo.getRowPosition());
        if (row == null) {
            return this.getBlankCellValue(mappingInfo);
        }
        Cell cell = row.getCell(mappingInfo.getColumnPosition());
        if (cell == null) {
            return this.getBlankCellValue(mappingInfo);
        }
        return this.getCellOriginalValue(row, mappingInfo.getColumnPosition(), mappingInfo);
    }

    protected CellGetInfo getCellOriginalValue(Row row, int index, EntityCellMappingInfo<?> mappingInfo) {
        if (mappingInfo == null) {
            mappingInfo = new EntityCellMappingInfo<String>(String.class);
            mappingInfo.setColumnPosition(index);
        }
        return this.getIndexCellValue(row, index, mappingInfo);
    }

    protected CellGetInfo getIndexCellValue(Row row, int index, EntityCellMappingInfo<?> mappingInfo) {
        if (index < 0) {
            return this.getBlankCellValue(mappingInfo);
        }
        Cell cell = row.getCell(index);
        if (mappingInfo.getColumnPosition() == -1 || cell == null) {
            return this.getBlankCellValue(mappingInfo);
        }
        Object value = null;
        CellGetInfo cellGetInfo = new CellGetInfo();
        CellType cellType = cell.getCellType();
        cellGetInfo.setCellType(cellType);
        switch (cellType) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                cellGetInfo.set_cell(cell);
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                cellGetInfo = this.getFormulaCellValue(cell);
                return cellGetInfo;
            }
            case BLANK: {
                LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)String.format("\u7a7a\u767d\u5355\u5143\u683c\u4f4d\u7f6e:[%s]", this.workBookContext.getHumanReadablePosition()));
                return this.getBlankCellValue(mappingInfo);
            }
            default: {
                this.LOGGER.error("\u672a\u77e5\u7684\u5355\u5143\u683c\u7c7b\u578b:{},\u5355\u5143\u683c\u4f4d\u7f6e:[{}]", (Object)cell.getCellType(), (Object)this.workBookContext.getHumanReadablePosition());
            }
        }
        cellGetInfo.setAlreadyFillValue(true);
        cellGetInfo.setCellValue(value);
        return cellGetInfo;
    }

    protected CellGetInfo getBlankCellValue(EntityCellMappingInfo<?> mappingInfo) {
        CellGetInfo cellGetInfo = new CellGetInfo();
        if (mappingInfo.fieldIsPrimitive()) {
            cellGetInfo.setCellValue(mappingInfo.fillDefaultPrimitiveValue(null));
        }
        return cellGetInfo;
    }

    protected <RT> void row2MapInstance(Map<String, Object> instance, Row row, ReaderConfig<RT> readerConfig) {
        this.workBookContext.setCurrentReadRowIndex(row.getRowNum());
        row.cellIterator().forEachRemaining(cell -> {
            this.workBookContext.setCurrentReadColumnIndex(cell.getColumnIndex());
            int idx = cell.getColumnIndex() + 1;
            String key = "CELL_" + idx;
            instance.put(key, this.getCellOriginalValue(row, cell.getColumnIndex(), null).getCellValue());
            if (readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.USE_MAP_DEBUG)) {
                instance.put("CELL_TYPE_" + idx, cell.getCellType());
                if (cell.getCellType() == CellType.NUMERIC) {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        instance.put("CELL_TYPE_" + idx, cell.getCellType());
                        instance.put("CELL_DATE_" + idx, Time.regexTime((Date)cell.getDateCellValue()));
                    } else {
                        instance.put("CELL_TYPE_" + idx, cell.getCellType());
                    }
                } else {
                    instance.put("CELL_TYPE_" + idx, cell.getCellType());
                }
            }
        });
    }

    protected <RT> void validateConvertEntity(RT instance, boolean isValidate) {
        Iterator iterator;
        Set validate;
        if (isValidate && !(validate = this.validator.validate(instance, new Class[0])).isEmpty() && (iterator = validate.iterator()).hasNext()) {
            ConstraintViolation constraintViolation = (ConstraintViolation)iterator.next();
            throw new AxolotlExcelReadException(this.workBookContext, constraintViolation.getMessage());
        }
    }

    protected void preCheckAndFixReadConfig(ReaderConfig<?> readerConfig) {
        if (readerConfig == null) {
            String msg = "\u8bfb\u53d6\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a";
            this.LOGGER.error(msg);
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, msg);
        }
        int sheetIndex = readerConfig.getSheetIndex();
        if (sheetIndex < 0) {
            String msg = String.format("\u8bfb\u53d6\u7684sheet\u4e0d\u5b58\u5728[%s]", readerConfig.getSheetName() != null ? readerConfig.getSheetName() : Integer.valueOf(readerConfig.getSheetIndex()));
            if (readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.IGNORE_EMPTY_SHEET_ERROR)) {
                LoggerToolkitKt.warnWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)(msg + "\u5c06\u8fd4\u56de\u7a7a\u6570\u636e"));
                return;
            }
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, msg);
        }
        Class<?> castClass = readerConfig.getCastClass();
        if (castClass == null) {
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u8bfb\u53d6\u7684\u7c7b\u578b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (readerConfig.getStartIndex() < 0) {
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u8bfb\u53d6\u8d77\u59cb\u884c\u4e0d\u5f97\u5c0f\u4e8e0");
        }
        if (readerConfig.isReadAsObject() && !readerConfig.getIndexMappingInfos().isEmpty()) {
            String simpleName = ColumnBind.class.getSimpleName();
            LoggerToolkitKt.debugWithModule((Logger)this.LOGGER, (String)"Axolotl", (String)("\u8bfb\u53d6\u5bf9\u8c61\u65f6\u4e0d\u7528\u6307\u5b9a@" + simpleName + "\u6ce8\u89e3"));
        }
        if (readerConfig.getInitialRowPositionOffset() < 0) {
            this.LOGGER.warn("\u8bfb\u53d6\u7684\u521d\u59cb\u884c\u504f\u79fb\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u5c06\u88ab\u4fee\u6b63\u4e3a0");
            readerConfig.setInitialRowPositionOffset(0);
        }
        if (readerConfig.getEndIndex() < 0) {
            if (readerConfig.getEndIndex() != -1) {
                throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, "\u8bfb\u53d6\u7ed3\u675f\u884c\u4e0d\u5f97\u5c0f\u4e8e0");
            }
            if (!readerConfig.isReadAsObject()) {
                this.LOGGER.info("\u672a\u8bbe\u7f6e\u8bfb\u53d6\u7684\u7ed3\u675f\u884c,\u5c06\u88ab\u9ed8\u8ba4\u4fee\u6b63\u4e3a\u8bfb\u53d6\u8be5\u8868\u6700\u5927\u884c\u6570");
            }
            readerConfig.setEndIndex(this.workBookContext.getIndexSheet(sheetIndex).getLastRowNum() + 1);
        }
    }

    protected CellGetInfo getFormulaCellValue(Cell cell) {
        Object value;
        CellValue evaluated = this.workBookContext.getFormulaEvaluator().evaluate(cell);
        switch (evaluated.getCellType()) {
            case STRING: {
                value = evaluated.getStringValue();
                break;
            }
            case NUMERIC: {
                value = evaluated.getNumberValue();
                break;
            }
            case BOOLEAN: {
                value = evaluated.getBooleanValue();
                break;
            }
            default: {
                String msg = String.format("\u672a\u77e5\u7684\u516c\u5f0f\u5355\u5143\u683c\u7c7b\u578b\u4f4d\u7f6e:[%d,%d],\u5355\u5143\u683c\u7c7b\u578b:[%s],\u5355\u5143\u683c\u503c:[%s]", cell.getRowIndex(), cell.getColumnIndex(), evaluated.getCellType(), evaluated);
                this.LOGGER.error(msg);
                throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, msg);
            }
        }
        CellGetInfo cellGetInfo = new CellGetInfo(true, value);
        cellGetInfo.setCellType(evaluated.getCellType());
        return cellGetInfo;
    }

    public int getPhysicalRowNumber() {
        return this.getRowNumber(true);
    }

    public int getRecordRowNumber() {
        return this.getRowNumber(false);
    }

    public int getRowNumber(boolean isPhysical) {
        return this.getRowNumber(this._sheetLevelReaderConfig, isPhysical);
    }

    public int getRowNumber(ReaderConfig<?> readerConfig, boolean isPhysical) {
        return this.getRowNumber(readerConfig.getSheetIndex(), isPhysical);
    }

    public int getPhysicalRowNumber(ReaderConfig<?> readerConfig) {
        return this.getRowNumber(readerConfig.getSheetIndex(), true);
    }

    public int getRecordRowNumber(ReaderConfig<?> readerConfig) {
        return this.getRowNumber(readerConfig.getSheetIndex(), false);
    }

    public int getRowNumber(int sheetIndex, boolean isPhysical) {
        Sheet sheet = this.workBookContext.getIndexSheet(sheetIndex);
        if (isPhysical) {
            return sheet.getPhysicalNumberOfRows();
        }
        return sheet.getLastRowNum() + 1;
    }

    public String getHumanReadablePosition() {
        return this.workBookContext.getHumanReadablePosition();
    }

    public WorkBookContext getWorkBookContext() {
        return this.workBookContext;
    }

    public void set_sheetLevelReaderConfig(ReaderConfig<T> _sheetLevelReaderConfig) {
        this._sheetLevelReaderConfig = _sheetLevelReaderConfig;
    }
}

