/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.manage.impl;

import cn.toutatis.xvoid.axolotl.exceptions.AxolotlException;
import cn.toutatis.xvoid.axolotl.manage.ProgressManager;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class MemoryProgressManager
implements ProgressManager {
    public static final int DEFAULT_CLEAN_INTERVAL = 10;
    private final Logger LOGGER = LoggerToolkit.getLogger(MemoryProgressManager.class);
    private static final Map<String, Integer> CURRENT_RECORDS_MAP = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> TOTAL_PROCESS_MAP = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Boolean> EXPIRED_PROCESS_MAP = new ConcurrentHashMap<String, Boolean>();
    private final ScheduledExecutorService cleaner = Executors.newSingleThreadScheduledExecutor();

    public void initUnknownTotal() {
    }

    @Override
    public void init(String progressId, int totalRecords) {
        if (Validator.strIsBlank((Object)progressId)) {
            throw new AxolotlException("\u8fdb\u5ea6ID\u4e3a\u7a7a");
        }
        if (totalRecords <= 0) {
            throw new AxolotlException("\u603b\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        boolean containsKey = CURRENT_RECORDS_MAP.containsKey(progressId);
        if (containsKey) {
            throw new AxolotlException(LoggerHelper.format("\u8fdb\u5ea6ID:%s\u5df2\u5b58\u5728", progressId));
        }
        CURRENT_RECORDS_MAP.put(progressId, 0);
        TOTAL_PROCESS_MAP.put(progressId, totalRecords);
        ScheduledFuture<Integer> schedule = this.cleaner.schedule(() -> CURRENT_RECORDS_MAP.remove(progressId), 10L, TimeUnit.MINUTES);
        this.cleaner.schedule(() -> TOTAL_PROCESS_MAP.remove(progressId), 10L, TimeUnit.MINUTES);
    }

    @Override
    public void updateProgress(String progressId, int currentRecords) {
    }

    @Override
    public Double getProgress(String progressId) {
        this.checkProgressExist(progressId);
        return (double)CURRENT_RECORDS_MAP.get(progressId).intValue() / (double)TOTAL_PROCESS_MAP.get(progressId).intValue();
    }

    @Override
    public boolean isFinished(String progressId) {
        boolean processFinished;
        this.checkProgressExist(progressId);
        boolean bl = processFinished = CURRENT_RECORDS_MAP.get(progressId) >= TOTAL_PROCESS_MAP.get(progressId);
        if (processFinished) {
            CURRENT_RECORDS_MAP.remove(progressId);
            TOTAL_PROCESS_MAP.remove(progressId);
            LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u8fdb\u5ea6ID:%s\u5df2\u5b8c\u6210,\u5c06\u88ab\u79fb\u9664", progressId));
        }
        return processFinished;
    }

    private void checkProgressExist(String progressId) {
        if (!CURRENT_RECORDS_MAP.containsKey(progressId)) {
            throw new AxolotlException(LoggerHelper.format("\u8fdb\u5ea6ID:%s\u4e0d\u5b58\u5728", progressId));
        }
    }
}

