/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.toolkit;

import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;

public class ExcelToolkit {
    private static final Logger LOGGER = LoggerToolkit.getLogger((String)"Axolotl");

    public static String getHumanReadablePosition(int rowIndex, int columnIndex) {
        char i = (char)(65 + columnIndex);
        return String.format("%s", i + String.format("%d", rowIndex + 1));
    }

    public static boolean blankRowCheck(Row row) {
        if (row == null) {
            return true;
        }
        int isAllBlank = 0;
        int lastCellNum = row.getLastCellNum();
        for (int i = 0; i < lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() == CellType.BLANK) {
                ++isAllBlank;
                continue;
            }
            return false;
        }
        boolean blankRow = isAllBlank == lastCellNum;
        LoggerToolkitKt.debugWithModule((Logger)LOGGER, (String)"Axolotl", (String)String.format("\u884c[%s]\u6570\u636e\u4e3a\u7a7a", row.getRowNum()));
        return blankRow;
    }

    public static boolean notBlankRowCheck(Row row) {
        return !ExcelToolkit.blankRowCheck(row);
    }
}

