/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.reader;

import cn.toutatis.xvoid.axolotl.excel.reader.AxolotlExcelReader;
import cn.toutatis.xvoid.axolotl.excel.reader.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.reader.constant.ExcelReadPolicy;
import cn.toutatis.xvoid.axolotl.excel.reader.support.AxolotlAbstractExcelReader;
import cn.toutatis.xvoid.axolotl.excel.reader.support.exceptions.AxolotlExcelReadException;
import cn.toutatis.xvoid.axolotl.excel.reader.support.stream.AxolotlExcelStream;
import cn.toutatis.xvoid.axolotl.toolkit.ExcelToolkit;
import cn.toutatis.xvoid.axolotl.toolkit.tika.DetectResult;
import cn.toutatis.xvoid.axolotl.toolkit.tika.TikaShell;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import com.github.pjfanning.xlsx.StreamingReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.RecordFormatException;
import org.slf4j.Logger;

public class AxolotlStreamExcelReader<T>
extends AxolotlAbstractExcelReader<T> {
    private final Logger LOGGER;

    public AxolotlStreamExcelReader(File excelFile) {
        super(excelFile);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);
    }

    public AxolotlStreamExcelReader(File excelFile, boolean withDefaultConfig) {
        super(excelFile, withDefaultConfig);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);
    }

    public AxolotlStreamExcelReader(File excelFile, Class<T> clazz) {
        super(excelFile, clazz);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);
    }

    public AxolotlStreamExcelReader(InputStream ins) {
        super(ins);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);
    }

    public AxolotlStreamExcelReader(InputStream ins, Class<T> clazz) {
        super(ins, clazz);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);
    }

    public AxolotlStreamExcelReader(File excelFile, Class<T> clazz, boolean withDefaultConfig) {
        super(excelFile, clazz, withDefaultConfig);
        ((AxolotlAbstractExcelReader)this).LOGGER = this.LOGGER = LoggerToolkit.getLogger(AxolotlExcelReader.class);
    }

    @Override
    protected DetectResult checkFileFormat(File file, InputStream ins) {
        return this.getFileOrStreamDetectResult(file, ins, TikaShell.OOXML_EXCEL);
    }

    @Override
    protected void loadFileDataToWorkBook() {
        try (ByteArrayInputStream fis = new ByteArrayInputStream(this.workBookContext.getDataCache());){
            Workbook workbook = StreamingReader.builder().rowCacheSize(1000).bufferSize(4096).open((InputStream)fis);
            this.workBookContext.setWorkbook(workbook);
        }
        catch (IOException | RecordFormatException e) {
            this.LOGGER.error("\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25", e);
            throw new AxolotlExcelReadException(AxolotlExcelReadException.ExceptionType.READ_EXCEL_ERROR, e.getMessage());
        }
    }

    public <RT> RT castRow2Instance(Row row, ReaderConfig<RT> readerConfig) {
        RT instance = readerConfig.getCastClassInstance();
        if (ExcelToolkit.blankRowCheck(row, readerConfig)) {
            if (readerConfig.getReadPolicyAsBoolean(ExcelReadPolicy.INCLUDE_EMPTY_ROW)) {
                return instance;
            }
            return null;
        }
        this.convertCellToInstance(row, instance, readerConfig);
        return instance;
    }

    public <RT> AxolotlExcelStream<RT> dataIterator(ReaderConfig<RT> readerConfig) {
        return new AxolotlExcelStream<RT>(this, readerConfig);
    }
}

