/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer;

import cn.toutatis.xvoid.axolotl.excel.writer.components.SheetTitle;
import cn.toutatis.xvoid.axolotl.excel.writer.exceptions.AxolotlWriteException;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.support.CommonWriteConfig;
import cn.toutatis.xvoid.axolotl.excel.writer.support.DataInverter;
import cn.toutatis.xvoid.axolotl.excel.writer.support.inverters.DefaultDataInverter;
import cn.toutatis.xvoid.axolotl.excel.writer.themes.ExcelWriteThemes;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AutoWriteConfig
extends CommonWriteConfig {
    private String title;
    private Class<?> metaClass;
    private String sheetName;
    private String fontName;
    private ExcelStyleRender styleRender = ExcelWriteThemes.$DEFAULT.getRender();
    private DataInverter<?> dataInverter = new DefaultDataInverter();
    private String blankValue = "";
    private Map<Integer, Integer> specialRowHeightMapping = new HashMap<Integer, Integer>();
    private HashSet<Integer> calculateColumnIndexes = new HashSet();

    public AutoWriteConfig() {
        super(true);
        this.calculateColumnIndexes.add(-1);
    }

    public AutoWriteConfig(Class<?> metaClass, boolean withDefaultConfig) {
        super(withDefaultConfig);
        this.metaClass = metaClass;
        this.setClassMetaData(this.metaClass);
    }

    public void setThemeStyleRender(ExcelStyleRender styleRender) {
        this.styleRender = styleRender;
    }

    public void setThemeStyleRender(ExcelWriteThemes theme) {
        this.styleRender = theme.getRender();
    }

    public void setThemeStyleRender(String themeName) {
        this.setThemeStyleRender(ExcelWriteThemes.valueOf(themeName.toUpperCase()));
    }

    public void setThemeStyleRender(Class<? extends ExcelStyleRender> styleRenderClass) {
        try {
            this.styleRender = styleRenderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSheetName() {
        if (this.sheetName == null) {
            return this.title;
        }
        return this.sheetName;
    }

    public void setClassMetaData(Class<?> metaClass) {
        if (metaClass != null) {
            SheetTitle sheetTitle = metaClass.getDeclaredAnnotation(SheetTitle.class);
            if (sheetTitle != null) {
                this.title = sheetTitle.value();
                String sheetName = sheetTitle.sheetName();
                if (Validator.strNotBlank((Object)sheetName)) {
                    this.sheetName = sheetName;
                }
            }
        } else {
            throw new AxolotlWriteException("\u5143\u4fe1\u606fClass\u4e3a\u7a7a");
        }
    }

    public void setClassMetaData(List<?> datas) {
        if (datas != null && !datas.isEmpty()) {
            this.setClassMetaData(datas.get(0).getClass());
        }
    }

    public void addCalculateColumnIndex(int ... index) {
        Arrays.stream(index).filter(i -> i >= 0).forEach(i -> this.calculateColumnIndexes.add(i));
    }

    public void addSpecialRowHeight(int row, int height) {
        this.specialRowHeightMapping.put(row, height);
    }

    public String getTitle() {
        return this.title;
    }

    public Class<?> getMetaClass() {
        return this.metaClass;
    }

    public String getFontName() {
        return this.fontName;
    }

    public ExcelStyleRender getStyleRender() {
        return this.styleRender;
    }

    public DataInverter<?> getDataInverter() {
        return this.dataInverter;
    }

    public String getBlankValue() {
        return this.blankValue;
    }

    public Map<Integer, Integer> getSpecialRowHeightMapping() {
        return this.specialRowHeightMapping;
    }

    public HashSet<Integer> getCalculateColumnIndexes() {
        return this.calculateColumnIndexes;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMetaClass(Class<?> metaClass) {
        this.metaClass = metaClass;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setStyleRender(ExcelStyleRender styleRender) {
        this.styleRender = styleRender;
    }

    public void setDataInverter(DataInverter<?> dataInverter) {
        this.dataInverter = dataInverter;
    }

    public void setBlankValue(String blankValue) {
        this.blankValue = blankValue;
    }

    public void setSpecialRowHeightMapping(Map<Integer, Integer> specialRowHeightMapping) {
        this.specialRowHeightMapping = specialRowHeightMapping;
    }

    public void setCalculateColumnIndexes(HashSet<Integer> calculateColumnIndexes) {
        this.calculateColumnIndexes = calculateColumnIndexes;
    }

    @Override
    public String toString() {
        return "AutoWriteConfig(title=" + this.getTitle() + ", metaClass=" + this.getMetaClass() + ", sheetName=" + this.getSheetName() + ", fontName=" + this.getFontName() + ", styleRender=" + this.getStyleRender() + ", dataInverter=" + this.getDataInverter() + ", blankValue=" + this.getBlankValue() + ", specialRowHeightMapping=" + this.getSpecialRowHeightMapping() + ", calculateColumnIndexes=" + this.getCalculateColumnIndexes() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoWriteConfig)) {
            return false;
        }
        AutoWriteConfig other = (AutoWriteConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Class<?> this$metaClass = this.getMetaClass();
        Class<?> other$metaClass = other.getMetaClass();
        if (this$metaClass == null ? other$metaClass != null : !this$metaClass.equals(other$metaClass)) {
            return false;
        }
        String this$sheetName = this.getSheetName();
        String other$sheetName = other.getSheetName();
        if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
            return false;
        }
        String this$fontName = this.getFontName();
        String other$fontName = other.getFontName();
        if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
            return false;
        }
        ExcelStyleRender this$styleRender = this.getStyleRender();
        ExcelStyleRender other$styleRender = other.getStyleRender();
        if (this$styleRender == null ? other$styleRender != null : !this$styleRender.equals(other$styleRender)) {
            return false;
        }
        DataInverter<?> this$dataInverter = this.getDataInverter();
        DataInverter<?> other$dataInverter = other.getDataInverter();
        if (this$dataInverter == null ? other$dataInverter != null : !this$dataInverter.equals(other$dataInverter)) {
            return false;
        }
        String this$blankValue = this.getBlankValue();
        String other$blankValue = other.getBlankValue();
        if (this$blankValue == null ? other$blankValue != null : !this$blankValue.equals(other$blankValue)) {
            return false;
        }
        Map<Integer, Integer> this$specialRowHeightMapping = this.getSpecialRowHeightMapping();
        Map<Integer, Integer> other$specialRowHeightMapping = other.getSpecialRowHeightMapping();
        if (this$specialRowHeightMapping == null ? other$specialRowHeightMapping != null : !((Object)this$specialRowHeightMapping).equals(other$specialRowHeightMapping)) {
            return false;
        }
        HashSet<Integer> this$calculateColumnIndexes = this.getCalculateColumnIndexes();
        HashSet<Integer> other$calculateColumnIndexes = other.getCalculateColumnIndexes();
        return !(this$calculateColumnIndexes == null ? other$calculateColumnIndexes != null : !((Object)this$calculateColumnIndexes).equals(other$calculateColumnIndexes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AutoWriteConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Class<?> $metaClass = this.getMetaClass();
        result = result * 59 + ($metaClass == null ? 43 : $metaClass.hashCode());
        String $sheetName = this.getSheetName();
        result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
        String $fontName = this.getFontName();
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        ExcelStyleRender $styleRender = this.getStyleRender();
        result = result * 59 + ($styleRender == null ? 43 : $styleRender.hashCode());
        DataInverter<?> $dataInverter = this.getDataInverter();
        result = result * 59 + ($dataInverter == null ? 43 : $dataInverter.hashCode());
        String $blankValue = this.getBlankValue();
        result = result * 59 + ($blankValue == null ? 43 : $blankValue.hashCode());
        Map<Integer, Integer> $specialRowHeightMapping = this.getSpecialRowHeightMapping();
        result = result * 59 + ($specialRowHeightMapping == null ? 43 : ((Object)$specialRowHeightMapping).hashCode());
        HashSet<Integer> $calculateColumnIndexes = this.getCalculateColumnIndexes();
        result = result * 59 + ($calculateColumnIndexes == null ? 43 : ((Object)$calculateColumnIndexes).hashCode());
        return result;
    }
}

