/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer;

import cn.toutatis.xvoid.axolotl.excel.writer.AutoWriteConfig;
import cn.toutatis.xvoid.axolotl.excel.writer.AxolotlAbstractExcelWriter;
import cn.toutatis.xvoid.axolotl.excel.writer.components.Header;
import cn.toutatis.xvoid.axolotl.excel.writer.exceptions.AxolotlWriteException;
import cn.toutatis.xvoid.axolotl.excel.writer.style.AbstractStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AutoWriteContext;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.slf4j.Logger;

public class AxolotlAutoExcelWriter
extends AxolotlAbstractExcelWriter {
    private final Logger LOGGER;
    private final AutoWriteConfig writeConfig;
    private final AutoWriteContext writeContext;

    public AxolotlAutoExcelWriter(AutoWriteConfig autoWriteConfig) {
        ((AxolotlAbstractExcelWriter)this).LOGGER = this.LOGGER = LoggerToolkit.getLogger(AxolotlAutoExcelWriter.class);
        this.writeConfig = autoWriteConfig;
        this.checkWriteConfig(this.writeConfig);
        AutoWriteContext autoWriteContext = new AutoWriteContext();
        this.workbook = this.initWorkbook(null);
        autoWriteContext.setWorkbook(this.workbook);
        this.writeContext = autoWriteContext;
        ((AxolotlAbstractExcelWriter)this).writeContext = autoWriteContext;
        this.writeContext.setSwitchSheetIndex(autoWriteConfig.getSheetIndex());
    }

    public AxolotlWriteResult write(List<Header> headers, List<?> datas) throws AxolotlWriteException {
        SXSSFSheet sheet;
        int switchSheetIndex = this.writeContext.getSwitchSheetIndex();
        LoggerHelper.info(this.LOGGER, this.writeContext.getCurrentWrittenBatchAndIncrement(switchSheetIndex));
        ExcelStyleRender styleRender = this.writeConfig.getStyleRender();
        if (styleRender == null) {
            throw new AxolotlWriteException("\u8bf7\u8bbe\u7f6e\u5199\u5165\u6e32\u67d3\u5668");
        }
        this.writeContext.getHeaders().put(switchSheetIndex, headers);
        this.writeContext.setDatas(datas);
        if (styleRender instanceof AbstractStyleRender) {
            AbstractStyleRender innerStyleRender = (AbstractStyleRender)styleRender;
            innerStyleRender.setWriteConfig(this.writeConfig);
            innerStyleRender.setContext(this.writeContext);
        }
        if (this.writeContext.isFirstBatch(switchSheetIndex)) {
            sheet = this.workbook.createSheet();
            this.writeContext.setWorkbook(this.workbook);
            styleRender.init(sheet);
            styleRender.renderHeader(sheet);
        } else {
            sheet = this.workbook.getSheetAt(switchSheetIndex);
        }
        styleRender.renderData(sheet, datas);
        return null;
    }

    public AxolotlWriteResult write(List<?> data) throws AxolotlWriteException {
        return this.write(null, data);
    }

    @Override
    public void flush() {
        ExcelStyleRender styleRender = this.writeConfig.getStyleRender();
        int numberOfSheets = this.workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            styleRender.finish(this.getWorkbook().getSheetAt(i));
        }
    }

    @Override
    public void close() throws IOException {
        OutputStream outputStream = this.writeConfig.getOutputStream();
        this.flush();
        this.workbook.write(outputStream);
        this.workbook.close();
    }
}

