/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer;

import cn.toutatis.xvoid.axolotl.excel.writer.AxolotlAbstractExcelWriter;
import cn.toutatis.xvoid.axolotl.excel.writer.TemplateWriteConfig;
import cn.toutatis.xvoid.axolotl.excel.writer.constant.TemplatePlaceholderPattern;
import cn.toutatis.xvoid.axolotl.excel.writer.exceptions.AxolotlWriteException;
import cn.toutatis.xvoid.axolotl.excel.writer.style.StyleHelper;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlConstant;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import cn.toutatis.xvoid.axolotl.excel.writer.support.CellAddress;
import cn.toutatis.xvoid.axolotl.excel.writer.support.DesignConditions;
import cn.toutatis.xvoid.axolotl.excel.writer.support.ExcelWritePolicy;
import cn.toutatis.xvoid.axolotl.excel.writer.support.PlaceholderType;
import cn.toutatis.xvoid.axolotl.excel.writer.support.TemplateWriteContext;
import cn.toutatis.xvoid.axolotl.toolkit.ExcelToolkit;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.axolotl.toolkit.tika.TikaShell;
import cn.toutatis.xvoid.toolkit.constant.Time;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;

public class AxolotlTemplateExcelWriter
extends AxolotlAbstractExcelWriter {
    private final Logger LOGGER;
    private final TemplateWriteConfig writeConfig;
    private final TemplateWriteContext writeContext;

    public AxolotlTemplateExcelWriter(TemplateWriteConfig templateWriteConfig) {
        ((AxolotlAbstractExcelWriter)this).LOGGER = this.LOGGER = LoggerToolkit.getLogger(AxolotlTemplateExcelWriter.class);
        this.writeConfig = templateWriteConfig;
        this.checkWriteConfig(this.writeConfig);
        TemplateWriteContext templateWriteContext = new TemplateWriteContext();
        ((AxolotlAbstractExcelWriter)this).writeContext = templateWriteContext;
        this.writeContext = templateWriteContext;
        this.writeContext.setSwitchSheetIndex(this.writeConfig.getSheetIndex());
    }

    public AxolotlTemplateExcelWriter(File templateFile, TemplateWriteConfig writeConfig) {
        this(writeConfig);
        TikaShell.preCheckFileNormalThrowException(templateFile);
        this.workbook = this.initWorkbook(templateFile);
    }

    public AxolotlWriteResult write(Map<String, ?> fixMapping, List<?> dataList) {
        XSSFSheet sheet;
        LoggerHelper.info(this.LOGGER, this.writeContext.getCurrentWrittenBatchAndIncrement(this.writeContext.getSwitchSheetIndex()));
        AxolotlWriteResult axolotlWriteResult = new AxolotlWriteResult();
        if (this.writeContext.isTemplateWrite()) {
            int switchSheetIndex = this.writeContext.getSwitchSheetIndex();
            sheet = this.getWorkbookSheet(switchSheetIndex);
            if (this.writeContext.isFirstBatch(switchSheetIndex)) {
                this.resolveTemplate((Sheet)sheet, false);
            }
        } else {
            String message = "\u975e\u6a21\u677f\u5199\u5165\u8bf7\u4f7f\u7528AxolotlAutoExcelWriter.write()\u65b9\u6cd5";
            if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.SIMPLE_EXCEPTION_RETURN_RESULT)) {
                axolotlWriteResult.setMessage(message);
                return axolotlWriteResult;
            }
            throw new AxolotlWriteException(message);
        }
        this.writeSingleData((Sheet)sheet, fixMapping, this.writeContext.getSingleReferenceData(), false);
        this.writeCircleData(sheet, dataList);
        axolotlWriteResult.setWrite(true);
        axolotlWriteResult.setMessage("\u5199\u5165\u5b8c\u6210");
        return axolotlWriteResult;
    }

    private void writeSingleData(Sheet sheet, Map<String, ?> singleMap, HashBasedTable<Integer, String, CellAddress> referenceData, boolean gatherUnusedStage) {
        HashMap dataMapping = singleMap != null ? new HashMap(singleMap) : new HashMap();
        this.injectCommonConstInfo(dataMapping, gatherUnusedStage);
        int sheetIndex = this.workbook.getXSSFWorkbook().getSheetIndex(sheet);
        Map addressMapping = referenceData.row((Object)sheetIndex);
        Map alreadyUsedReferenceData = this.writeContext.getAlreadyUsedReferenceData().row((Object)sheetIndex);
        for (String singleKey : addressMapping.keySet()) {
            CellAddress cellAddress = (CellAddress)addressMapping.get(singleKey);
            String placeholder = cellAddress.getPlaceholder();
            if (dataMapping.containsKey(singleKey)) {
                if (alreadyUsedReferenceData.containsKey(placeholder)) {
                    LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u5df2\u8df3\u8fc7\u4f7f\u7528\u7684\u5360\u4f4d\u7b26[%s]", placeholder));
                    continue;
                }
                Cell cell = sheet.getRow(cellAddress.getRowPosition()).getCell(cellAddress.getColumnPosition());
                String stringCellValue = cell.getStringCellValue();
                Object info = dataMapping.get(singleKey);
                if (info != null) {
                    LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u8bbe\u7f6e\u6a21\u677f\u5360\u4f4d\u7b26[%s]\u503c[%s]", placeholder, info));
                    String replaceString = stringCellValue.replace(placeholder, info.toString());
                    cell.setCellValue(replaceString);
                } else {
                    String defaultValue = cellAddress.getDefaultValue();
                    String newCellValue = null;
                    boolean isDefaultValue = false;
                    if (defaultValue != null) {
                        isDefaultValue = true;
                        newCellValue = stringCellValue.replace(placeholder, defaultValue);
                    } else if (!stringCellValue.equals(placeholder)) {
                        newCellValue = stringCellValue.replace(placeholder, "");
                    }
                    if (newCellValue == null) {
                        LoggerHelper.debug(this.LOGGER, LoggerHelper.format("%s\u8bbe\u7f6e\u6a21\u677f\u5360\u4f4d\u7b26[%s]\u4e3a\u7a7a\u503c", gatherUnusedStage ? "[\u6536\u5c3e\u9636\u6bb5]" : "", placeholder));
                        cell.setBlank();
                    } else {
                        LoggerHelper.debug(this.LOGGER, LoggerHelper.format("%s\u8bbe\u7f6e\u6a21\u677f\u5360\u4f4d\u7b26[%s]\u4e3a%s\u503c", gatherUnusedStage ? "[\u6536\u5c3e\u9636\u6bb5]" : "", placeholder, isDefaultValue ? "\u9ed8\u8ba4" : "\u7a7a"));
                        cell.setCellValue(newCellValue);
                    }
                }
                cellAddress.setWrittenRow(cell.getRowIndex());
                alreadyUsedReferenceData.put(placeholder, true);
                continue;
            }
            LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u672a\u4f7f\u7528\u6a21\u677f\u5360\u4f4d\u7b26[%s]", placeholder));
        }
    }

    private void gatherUnusedSingleReferenceDataAndFillDefault() {
        if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.TEMPLATE_PLACEHOLDER_FILL_DEFAULT)) {
            int sheetIndex = this.writeContext.getSwitchSheetIndex();
            XSSFSheet sheet = this.getWorkbookSheet(this.writeContext.getSwitchSheetIndex());
            Map singleReferenceMapping = this.writeContext.getSingleReferenceData().row((Object)sheetIndex);
            HashMap<String, Object> unusedMap = this.gatherUnusedField(sheetIndex, singleReferenceMapping);
            this.writeSingleData((Sheet)sheet, unusedMap, this.writeContext.getSingleReferenceData(), true);
        }
    }

    private void gatherUnusedCircleReferenceDataAndFillDefault() {
        if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.TEMPLATE_PLACEHOLDER_FILL_DEFAULT)) {
            int sheetIndex = this.writeContext.getSwitchSheetIndex();
            XSSFSheet sheet = this.getWorkbookSheet(sheetIndex);
            Map circleReferenceData = this.writeContext.getCircleReferenceData().row((Object)sheetIndex);
            HashMap<String, Object> map = this.gatherUnusedField(sheetIndex, circleReferenceData);
            this.writeSingleData((Sheet)sheet, map, this.writeContext.getCircleReferenceData(), true);
        }
    }

    private void setCalculateData(int sheetIndex) {
        HashBasedTable<Integer, String, CellAddress> calculateReferenceData = this.writeContext.getCalculateReferenceData();
        Map calculateData = calculateReferenceData.row((Object)sheetIndex);
        HashMap<String, BigDecimal> extract = new HashMap<String, BigDecimal>();
        for (String s : calculateData.keySet()) {
            BigDecimal calculatedValue = ((CellAddress)calculateData.get(s)).getCalculatedValue();
            extract.put(s, calculatedValue.setScale(2, RoundingMode.HALF_UP));
        }
        this.writeSingleData((Sheet)this.getWorkbookSheet(sheetIndex), extract, calculateReferenceData, true);
    }

    private HashMap<String, Object> gatherUnusedField(int sheetIndex, Map<String, CellAddress> referenceMapping) {
        Map alreadyUsedDataMapping = this.writeContext.getAlreadyUsedReferenceData().row((Object)sheetIndex);
        MapDifference difference = Maps.difference(referenceMapping, (Map)alreadyUsedDataMapping);
        Map onlyOnLeft = difference.entriesOnlyOnLeft();
        HashMap<String, Object> unusedMap = new HashMap<String, Object>();
        for (String singleKey : onlyOnLeft.keySet()) {
            if (referenceMapping.containsKey(singleKey)) {
                unusedMap.put(singleKey, referenceMapping.get(singleKey).getDefaultValue());
                continue;
            }
            unusedMap.put(singleKey, null);
        }
        return unusedMap;
    }

    private DesignConditions calculateConditions(List<?> circleDataList) {
        DesignConditions designConditions = new DesignConditions();
        int sheetIndex = this.writeContext.getSwitchSheetIndex();
        designConditions.setSheetIndex(sheetIndex);
        Map circleReferenceData = this.writeContext.getCircleReferenceData().row((Object)sheetIndex);
        Map<String, Integer> writeFieldNames = new HashMap<String, Integer>();
        Object rowObjInstance = circleDataList.get(0);
        if (rowObjInstance instanceof Map) {
            designConditions.setSimplePOJO(false);
            Map rowObjInstanceMap = (Map)rowObjInstance;
            if (!rowObjInstanceMap.isEmpty()) {
                writeFieldNames = rowObjInstanceMap.keySet().stream().collect(Collectors.toMap(key -> key, key -> 1));
            }
        } else {
            designConditions.setSimplePOJO(true);
            Class<?> instanceClass = rowObjInstance.getClass();
            for (String key2 : circleReferenceData.keySet()) {
                Field field;
                try {
                    field = instanceClass.getDeclaredField(key2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    field = null;
                }
                if (field == null) continue;
                writeFieldNames.put(key2, 1);
            }
        }
        designConditions.setWriteFieldNames(writeFieldNames);
        ArrayList<String> writeFieldNamesList = new ArrayList<String>(writeFieldNames.keySet());
        designConditions.setWriteFieldNamesList(writeFieldNamesList);
        boolean initialWriting = this.writeContext.fieldsIsInitialWriting(sheetIndex, writeFieldNamesList);
        this.writeContext.addFieldRecords(sheetIndex, writeFieldNamesList, this.writeContext.getCurrentWrittenBatch().get(sheetIndex));
        designConditions.setFieldsInitialWriting(initialWriting);
        int startShiftRow = this.calculateStartShiftRow(circleReferenceData, designConditions, initialWriting);
        designConditions.setStartShiftRow(startShiftRow);
        Map<String, CellAddress> nonWrittenAddress = this.findTemplateCell(initialWriting, startShiftRow, writeFieldNamesList, sheetIndex, circleReferenceData);
        designConditions.setNonWrittenAddress(nonWrittenAddress);
        designConditions.setNotTemplateCells((List)this.writeContext.getSheetNonTemplateCells().get((Object)sheetIndex, writeFieldNamesList));
        designConditions.setTemplateLineHeight((Short)this.writeContext.getLineHeightRecords().get((Object)sheetIndex, writeFieldNamesList));
        return designConditions;
    }

    private Map<String, CellAddress> findTemplateCell(boolean initialWriting, int startShiftRow, List<String> writeFieldNamesList, int sheetIndex, Map<String, CellAddress> circleReferenceData) {
        int templateLineIdx = initialWriting ? startShiftRow - 1 : startShiftRow;
        HashMap<String, CellAddress> nonWrittenAddress = new HashMap<String, CellAddress>();
        if (templateLineIdx < 0) {
            return nonWrittenAddress;
        }
        XSSFSheet sheet = this.getWorkbookSheet(sheetIndex);
        XSSFRow templateRow = sheet.getRow(templateLineIdx);
        Map<Integer, CellAddress> templateColumnMap = circleReferenceData.values().stream().filter(cellAddress -> cellAddress.getRowPosition() == templateLineIdx).collect(Collectors.toMap(CellAddress::getColumnPosition, cellAddress -> cellAddress));
        boolean alreadyFill = this.writeContext.getSheetNonTemplateCells().contains((Object)sheetIndex, writeFieldNamesList);
        boolean nonTemplateCellFill = this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.TEMPLATE_NON_TEMPLATE_CELL_FILL);
        ArrayList<CellAddress> nonTemplateCellAddressList = new ArrayList<CellAddress>();
        for (int i = 0; i < templateRow.getLastCellNum(); ++i) {
            if (!templateColumnMap.containsKey(i)) {
                XSSFCell cell;
                if (alreadyFill || !initialWriting || !nonTemplateCellFill || (cell = templateRow.getCell(i)) == null) continue;
                CellAddress nonTempalteCellAddress = new CellAddress(null, templateLineIdx, i, (CellStyle)cell.getCellStyle());
                nonTempalteCellAddress.set_nonTemplateCell((Cell)cell);
                nonTempalteCellAddress.setMergeRegion(ExcelToolkit.isCellMerged((Sheet)sheet, templateLineIdx, i));
                nonTemplateCellAddressList.add(nonTempalteCellAddress);
                continue;
            }
            CellAddress cellAddress2 = templateColumnMap.get(i);
            String name = cellAddress2.getName();
            if (writeFieldNamesList.contains(name)) continue;
            nonWrittenAddress.put(name, cellAddress2);
        }
        if (!alreadyFill) {
            LoggerHelper.debug(this.LOGGER, "\u83b7\u53d6\u6a21\u677f\u884c[%s]\u4e2a\u975e\u6a21\u677f\u5217", nonTemplateCellAddressList.size());
            this.writeContext.getSheetNonTemplateCells().put((Object)sheetIndex, writeFieldNamesList, nonTemplateCellAddressList);
        }
        return nonWrittenAddress;
    }

    private void writeCircleData(XSSFSheet sheet, List<?> circleDataList) {
        if (Validator.objNotNull(circleDataList)) {
            DesignConditions designConditions = this.calculateConditions(circleDataList);
            LoggerHelper.debug(this.LOGGER, "\u672c\u6b21\u5199\u5165\u5b57\u6bb5\u4e3a:%s", designConditions.getWriteFieldNamesList());
            boolean initialWriting = designConditions.isFieldsInitialWriting();
            int startShiftRow = designConditions.getStartShiftRow();
            if ((circleDataList.size() > 1 || circleDataList.size() == 1 && initialWriting) && this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.TEMPLATE_SHIFT_WRITE_ROW)) {
                int lastRowNum = sheet.getLastRowNum();
                if (startShiftRow >= 0 && lastRowNum >= startShiftRow) {
                    int shiftRowNumber = initialWriting ? circleDataList.size() - 1 : circleDataList.size();
                    LoggerHelper.debug(this.LOGGER, "\u5f53\u524d\u5199\u5165\u8d77\u59cb\u884c\u6b21[%s],\u4e0b\u79fb\u884c\u6b21:[%s],", startShiftRow, shiftRowNumber);
                    if (shiftRowNumber > 0) {
                        sheet.shiftRows(startShiftRow, sheet.getLastRowNum(), shiftRowNumber, true, true);
                    }
                }
            }
            int sheetIndex = designConditions.getSheetIndex();
            Map circleReferenceData = this.writeContext.getCircleReferenceData().row((Object)sheetIndex);
            HashBasedTable<Integer, String, Boolean> alreadyUsedReferenceData = this.writeContext.getAlreadyUsedReferenceData();
            Map alreadyUsedDataMapping = alreadyUsedReferenceData.row((Object)this.writeContext.getSwitchSheetIndex());
            Map calculateReferenceData = this.writeContext.getCalculateReferenceData().row((Object)this.writeContext.getSwitchSheetIndex());
            for (Object data : circleDataList) {
                List nonTemplateCells;
                int rowPosition;
                HashSet<Integer> alreadyWrittenMergeRegionColumns = new HashSet<Integer>();
                boolean isCurrentBatchData = false;
                boolean alreadySetLineHeight = false;
                for (Map.Entry fieldMapping : circleReferenceData.entrySet()) {
                    String fieldMappingKey = (String)fieldMapping.getKey();
                    CellAddress cellAddress = (CellAddress)circleReferenceData.get(fieldMappingKey);
                    rowPosition = cellAddress.getRowPosition();
                    if (!alreadySetLineHeight) {
                        Row templateRow = ExcelToolkit.createOrCatchRow((Sheet)sheet, rowPosition);
                        Short templateLineHeight = designConditions.getTemplateLineHeight();
                        if (templateLineHeight != null && templateLineHeight != -1) {
                            templateRow.setHeight(templateLineHeight.shortValue());
                        }
                        alreadySetLineHeight = true;
                    }
                    boolean isWritten = false;
                    if (designConditions.getWriteFieldNames().containsKey(fieldMappingKey)) {
                        Object value;
                        if (designConditions.isSimplePOJO()) {
                            Field field = data.getClass().getDeclaredField(fieldMappingKey);
                            field.setAccessible(true);
                            value = field.get(data);
                        } else {
                            Map map = (Map)data;
                            value = map.get(fieldMappingKey);
                        }
                        Cell writableCell = ExcelToolkit.createOrCatchCell((Sheet)sheet, rowPosition, cellAddress.getColumnPosition(), cellAddress.getCellStyle());
                        if (Validator.strIsBlank(value)) {
                            String defaultValue = cellAddress.getDefaultValue();
                            if (defaultValue != null) {
                                writableCell.setCellValue(cellAddress.replacePlaceholder(defaultValue));
                            } else if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.TEMPLATE_NULL_VALUE_WITH_TEMPLATE_FILL)) {
                                writableCell.setCellValue(cellAddress.replacePlaceholder(""));
                            } else {
                                writableCell.setBlank();
                            }
                        } else {
                            if (calculateReferenceData.containsKey(fieldMappingKey) && Validator.strIsNumber((String)value.toString())) {
                                CellAddress calculateAddress = (CellAddress)calculateReferenceData.get(fieldMappingKey);
                                BigDecimal calculatedValue = calculateAddress.getCalculatedValue();
                                calculatedValue = calculatedValue.add(new BigDecimal(value.toString()));
                                calculateAddress.setCalculatedValue(calculatedValue);
                            }
                            writableCell.setCellValue(cellAddress.replacePlaceholder(value.toString()));
                        }
                        isWritten = true;
                    } else if (designConditions.getNonWrittenAddress().containsKey(fieldMappingKey)) {
                        ExcelToolkit.cellAssignment((Sheet)sheet, rowPosition, cellAddress.getColumnPosition(), cellAddress.getCellStyle(), cellAddress.getDefaultValue());
                        isWritten = true;
                    }
                    if (!isWritten) continue;
                    this.setMergeRegion((Sheet)sheet, cellAddress, rowPosition, alreadyWrittenMergeRegionColumns);
                    cellAddress.setRowPosition(++rowPosition);
                    if (!alreadyUsedDataMapping.containsKey(cellAddress.getPlaceholder())) {
                        alreadyUsedDataMapping.put(cellAddress.getPlaceholder(), true);
                    }
                    isCurrentBatchData = true;
                }
                if (!isCurrentBatchData || !this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.TEMPLATE_NON_TEMPLATE_CELL_FILL) || (nonTemplateCells = (List)this.writeContext.getSheetNonTemplateCells().get((Object)sheetIndex, designConditions.getWriteFieldNamesList())) == null || nonTemplateCells.isEmpty()) continue;
                for (CellAddress nonTemplateCellAddress : nonTemplateCells) {
                    Cell nonTemplateCell = nonTemplateCellAddress.get_nonTemplateCell();
                    rowPosition = nonTemplateCellAddress.getRowPosition();
                    if (!nonTemplateCellAddress.isInitializedWrite()) {
                        if (nonTemplateCellAddress.isMergeCell()) {
                            int columnIndex = nonTemplateCell.getColumnIndex();
                            if (alreadyWrittenMergeRegionColumns.contains(columnIndex)) continue;
                            this.setMergeRegion((Sheet)sheet, nonTemplateCellAddress, rowPosition, alreadyWrittenMergeRegionColumns);
                        }
                        Cell writableCell = ExcelToolkit.createOrCatchCell((Sheet)sheet, rowPosition, nonTemplateCellAddress.getColumnPosition(), null);
                        ExcelToolkit.cloneOldCell2NewCell(writableCell, nonTemplateCell);
                    }
                    nonTemplateCellAddress.setRowPosition(++rowPosition);
                }
            }
        }
    }

    private void setMergeRegion(Sheet sheet, CellAddress cellAddress, int rowPosition, HashSet<Integer> alreadyWrittenMergeRegionColumns) {
        if (cellAddress.isMergeCell()) {
            CellRangeAddress mergeRegion = cellAddress.getMergeRegion();
            for (int i = mergeRegion.getFirstColumn(); i <= mergeRegion.getLastColumn(); ++i) {
                alreadyWrittenMergeRegionColumns.add(i);
            }
            if (!cellAddress.isInitializedWrite()) {
                mergeRegion.setFirstRow(rowPosition);
                mergeRegion.setLastRow(rowPosition);
                StyleHelper.renderMergeRegionStyle(sheet, mergeRegion, cellAddress.getCellStyle());
                sheet.addMergedRegion(mergeRegion);
            }
        }
    }

    private int calculateStartShiftRow(Map<String, CellAddress> circleReferenceData, DesignConditions designConditions, boolean initialWriting) {
        int maxRowPosition = Integer.MIN_VALUE;
        Map<String, Integer> writeFieldNames = designConditions.getWriteFieldNames();
        for (Map.Entry<String, CellAddress> addressEntry : circleReferenceData.entrySet()) {
            if (!writeFieldNames.containsKey(addressEntry.getKey())) continue;
            maxRowPosition = Math.max(maxRowPosition, addressEntry.getValue().getRowPosition());
        }
        if (initialWriting) {
            int sheetIndex = designConditions.getSheetIndex();
            if (maxRowPosition >= 0) {
                XSSFSheet sheet = this.getWorkbookSheet(sheetIndex);
                short templateRowHeight = sheet.getRow(maxRowPosition).getHeight();
                LoggerHelper.debug(this.LOGGER, "\u8bbe\u7f6e\u6a21\u677f\u884c[%s]\u884c\u9ad8\u4e3a[%s]", maxRowPosition, templateRowHeight);
                this.writeContext.getLineHeightRecords().put((Object)sheetIndex, designConditions.getWriteFieldNamesList(), (Object)templateRowHeight);
            } else {
                this.writeContext.getLineHeightRecords().put((Object)sheetIndex, designConditions.getWriteFieldNamesList(), (Object)-1);
                LoggerHelper.debug(this.LOGGER, "\u672a\u627e\u5230\u4efb\u610f\u5360\u4f4d\u7b26,\u53d6\u6d88\u8bbe\u7f6e\u884c\u9ad8.");
            }
        }
        return initialWriting ? maxRowPosition + 1 : maxRowPosition;
    }

    private void injectCommonConstInfo(Map singleMap, boolean gatherUnusedStage) {
        if (!gatherUnusedStage && this.writeContext.isFirstBatch(this.writeContext.getSwitchSheetIndex())) {
            if (singleMap == null) {
                singleMap = new HashMap<String, String>();
            }
            singleMap.put(AxolotlConstant.CREATE_TIME, Time.getCurrentTime());
            singleMap.put(AxolotlConstant.CREATE_DATE, Time.regexTime((String)"yyyy-MM-dd", (Date)new Date()));
            LoggerHelper.debug(this.LOGGER, "\u6ce8\u5165\u5185\u7f6e\u5e38\u91cf");
        }
    }

    private void resolveTemplate(Sheet sheet, boolean isFinal) {
        int sheetIndex = this.workbook.getXSSFWorkbook().getSheetIndex(sheet);
        if (!this.writeContext.getResolvedSheetRecord().containsKey(sheetIndex) || isFinal) {
            HashBasedTable<Integer, String, CellAddress> singleReferenceData = this.writeContext.getSingleReferenceData();
            HashBasedTable<Integer, String, CellAddress> circleReferenceData = this.writeContext.getCircleReferenceData();
            HashBasedTable<Integer, String, CellAddress> calculateReferenceData = this.writeContext.getCalculateReferenceData();
            for (int rowIdx = 0; rowIdx <= sheet.getLastRowNum(); ++rowIdx) {
                Row row = sheet.getRow(rowIdx);
                if (row == null) continue;
                int lastCellNum = row.getLastCellNum();
                for (int colIdx = 0; colIdx < lastCellNum; ++colIdx) {
                    Cell cell = row.getCell(colIdx);
                    if (cell == null || !CellType.STRING.equals((Object)cell.getCellType())) continue;
                    Boolean foundPlaceholder = this.findPlaceholderData(isFinal, singleReferenceData, TemplatePlaceholderPattern.SINGLE_REFERENCE_TEMPLATE_PATTERN, sheetIndex, cell);
                    if (!foundPlaceholder.booleanValue()) {
                        foundPlaceholder = this.findPlaceholderData(isFinal, circleReferenceData, TemplatePlaceholderPattern.CIRCLE_REFERENCE_TEMPLATE_PATTERN, sheetIndex, cell);
                    }
                    if (foundPlaceholder.booleanValue()) continue;
                    this.findPlaceholderData(isFinal, calculateReferenceData, TemplatePlaceholderPattern.AGGREGATE_REFERENCE_TEMPLATE_PATTERN, sheetIndex, cell);
                }
            }
            int singleReferenceDataSize = this.writeContext.getSingleReferenceData().size();
            int circleReferenceDataSize = this.writeContext.getCircleReferenceData().size();
            int calculateReferenceDataSize = this.writeContext.getCalculateReferenceData().size();
            this.writeContext.getResolvedSheetRecord().put(sheetIndex, true);
            LoggerHelper.debug(this.LOGGER, LoggerHelper.format("%s\u5de5\u4f5c\u8868\u7d22\u5f15[%s]\u89e3\u6790\u6a21\u677f\u5b8c\u6210\uff0c\u5171\u89e3\u6790\u5230[%s]\u4e2a\u5360\u4f4d\u7b26,\u5f15\u7528\u5360\u4f4d\u7b26[%s]\u4e2a,\u5217\u8868\u5360\u4f4d\u7b26[%s]\u4e2a,\u8ba1\u7b97\u5360\u4f4d\u7b26[%s]\u4e2a", isFinal ? "[\u6536\u5c3e\u9636\u6bb5]" : "", sheetIndex, singleReferenceDataSize + circleReferenceDataSize + calculateReferenceDataSize, singleReferenceDataSize, circleReferenceDataSize, calculateReferenceDataSize));
        } else {
            LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u5de5\u4f5c\u8868[%s]\u5df2\u88ab\u89e3\u6790\u8fc7\uff0c\u8df3\u8fc7\u672c\u6b21\u89e3\u6790", sheetIndex));
        }
    }

    private Boolean findPlaceholderData(boolean isFinal, HashBasedTable<Integer, String, CellAddress> referenceData, Pattern pattern, int sheetIndex, Cell cell) {
        ArrayList<CellAddress> cellAddressList = new ArrayList<CellAddress>();
        Map cellAddressMap = referenceData.row((Object)sheetIndex);
        int cellMultipleMatchTemplate = -1;
        String stringCellValue = cell.getStringCellValue();
        Matcher matcher = pattern.matcher(stringCellValue);
        DataFormat dataFormat = this.workbook.createDataFormat();
        short textFormatIndex = dataFormat.getFormat("@");
        while (matcher.find()) {
            boolean isCirclePattern;
            CellRangeAddress cellMerged;
            ++cellMultipleMatchTemplate;
            int rowIndex = cell.getRowIndex();
            int columnIndex = cell.getColumnIndex();
            CellStyle cellStyle = cell.getCellStyle();
            cellStyle.setDataFormat(textFormatIndex);
            CellAddress cellAddress = new CellAddress(stringCellValue, rowIndex, columnIndex, cellStyle);
            cellAddress.setPlaceholder(matcher.group());
            String matchTemplate = matcher.group(1);
            String[] defaultSplitContent = matchTemplate.split(":");
            String name = defaultSplitContent[0];
            cellAddress.setName(name);
            if (defaultSplitContent.length > 1) {
                cellAddress.setDefaultValue(defaultSplitContent[1]);
            }
            if ((cellMerged = ExcelToolkit.isCellMerged((Sheet)this.getWorkbookSheet(sheetIndex), rowIndex, columnIndex)) != null) {
                LoggerHelper.debug(this.LOGGER, LoggerHelper.format("\u89e3\u6790\u5230\u5360\u4f4d\u7b26[%s]\u4e3a\u5408\u5e76\u5355\u5143\u683c[%s]", cellAddress.getPlaceholder(), cellMerged.formatAsString()));
                cellAddress.setMergeRegion(cellMerged);
            }
            if ((isCirclePattern = pattern.equals(TemplatePlaceholderPattern.CIRCLE_REFERENCE_TEMPLATE_PATTERN)) || pattern.equals(TemplatePlaceholderPattern.SINGLE_REFERENCE_TEMPLATE_PATTERN)) {
                cellAddress.setPlaceholderType(isCirclePattern ? PlaceholderType.CIRCLE : PlaceholderType.MAPPING);
                cellAddressMap.put(name, cellAddress);
            } else if (pattern.equals(TemplatePlaceholderPattern.AGGREGATE_REFERENCE_TEMPLATE_PATTERN)) {
                if (!isFinal) {
                    cellAddress.setPlaceholderType(PlaceholderType.CALCULATE);
                    cellAddress.setCalculatedValue(BigDecimal.ZERO);
                    cellAddressMap.put(name, cellAddress);
                } else if (cellAddressMap.containsKey(name)) {
                    CellAddress originalAddress = (CellAddress)cellAddressMap.get(name);
                    originalAddress.setRowPosition(cellAddress.getRowPosition());
                    cellAddressMap.put(name, originalAddress);
                } else {
                    cellAddressMap.put(name, cellAddress);
                }
            }
            cellAddressList.add(cellAddress);
        }
        if (cellMultipleMatchTemplate > 0) {
            for (CellAddress cellAddress : cellAddressList) {
                cellAddress.setCellMultipleMatchTemplate(true);
            }
        }
        return !cellAddressList.isEmpty();
    }

    public void flush(boolean isFinal) {
        if (isFinal) {
            for (Integer i : this.writeContext.getResolvedSheetRecord().keySet()) {
                this.resolveTemplate((Sheet)this.getWorkbookSheet(i), true);
                this.gatherUnusedSingleReferenceDataAndFillDefault();
                this.gatherUnusedCircleReferenceDataAndFillDefault();
                this.setCalculateData(i);
            }
        } else {
            this.resolveTemplate((Sheet)this.getWorkbookSheet(this.writeContext.getSwitchSheetIndex()), false);
        }
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    @Override
    public void close() {
        LoggerHelper.debug(this.LOGGER, "\u5de5\u4f5c\u8584\u5199\u5165\u8fdb\u5165\u5173\u95ed\u9636\u6bb5");
        OutputStream outputStream = this.writeConfig.getOutputStream();
        if (outputStream == null) {
            String message = "\u8f93\u51fa\u6d41\u4e3a\u7a7a,\u8bf7\u6307\u5b9a\u8f93\u51fa\u6d41";
            LoggerHelper.debug(this.LOGGER, message);
            throw new AxolotlWriteException(message);
        }
        this.flush(true);
        this.workbook.write(this.writeConfig.getOutputStream());
        this.workbook.close();
        this.writeConfig.getOutputStream().close();
    }

    @Override
    public void switchSheet(int sheetIndex) {
        super.switchSheet(sheetIndex);
        this.resolveTemplate((Sheet)this.getWorkbookSheet(sheetIndex), false);
    }
}

