/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.components;

import cn.toutatis.xvoid.axolotl.excel.writer.components.AxolotlCellStyle;
import cn.toutatis.xvoid.toolkit.clazz.LambdaToolkit;
import cn.toutatis.xvoid.toolkit.clazz.XFunc;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;

public class Header {
    private String name;
    private String fieldName;
    private int columnPosition = -1;
    private List<Header> childs = new ArrayList<Header>();
    private CellStyle customCellStyle;
    private AxolotlCellStyle axolotlCellStyle;
    private int columnWidth = -1;
    private boolean participateInCalculate = false;

    public Header(String name) {
        this.name = name;
    }

    public Header(String name, boolean participateInCalculate) {
        this.name = name;
        this.participateInCalculate = participateInCalculate;
    }

    public Header(String name, String fieldName) {
        this(name);
        this.fieldName = fieldName;
    }

    public Header(String name, String fieldName, boolean participateInCalculate) {
        this.name = name;
        this.fieldName = fieldName;
        this.participateInCalculate = participateInCalculate;
    }

    public <T, D> Header(String name, XFunc<T, D> fieldName) {
        this(name);
        this.fieldName = LambdaToolkit.getFieldName(fieldName);
    }

    public <T, D> Header(String name, boolean participateInCalculate, XFunc<T, D> fieldName) {
        this(name);
        this.fieldName = LambdaToolkit.getFieldName(fieldName);
        this.participateInCalculate = participateInCalculate;
    }

    public Header(String name, List<Header> childs) {
        this.name = name;
        this.childs = childs;
    }

    public Header(String name, boolean participateInCalculate, List<Header> childs) {
        this.name = name;
        this.childs = childs;
        this.participateInCalculate = participateInCalculate;
    }

    public Header(String name, String fieldName, List<Header> childs) {
        this.name = name;
        this.fieldName = fieldName;
        this.childs = childs;
    }

    public Header(String name, String fieldName, boolean participateInCalculate, List<Header> childs) {
        this.name = name;
        this.fieldName = fieldName;
        this.childs = childs;
        this.participateInCalculate = participateInCalculate;
    }

    public Header(String name, Header ... childs) {
        this.name = name;
        this.childs = List.of(childs);
    }

    public Header(String name, boolean participateInCalculate, Header ... childs) {
        this.name = name;
        this.childs = List.of(childs);
        this.participateInCalculate = participateInCalculate;
    }

    public Header(String name, String fieldName, Header ... childs) {
        this.name = name;
        this.fieldName = fieldName;
        this.childs = List.of(childs);
    }

    public Header(String name, String fieldName, boolean participateInCalculate, Header ... childs) {
        this.name = name;
        this.fieldName = fieldName;
        this.childs = List.of(childs);
        this.participateInCalculate = participateInCalculate;
    }

    public int countOrlopCellNumber() {
        if (this.childs == null || this.childs.isEmpty()) {
            return 1;
        }
        int totalCount = 0;
        for (Header subHeader : this.childs) {
            totalCount += subHeader.countOrlopCellNumber();
        }
        return totalCount;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public List<Header> getChilds() {
        return this.childs;
    }

    public CellStyle getCustomCellStyle() {
        return this.customCellStyle;
    }

    public AxolotlCellStyle getAxolotlCellStyle() {
        return this.axolotlCellStyle;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public boolean isParticipateInCalculate() {
        return this.participateInCalculate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setColumnPosition(int columnPosition) {
        this.columnPosition = columnPosition;
    }

    public void setChilds(List<Header> childs) {
        this.childs = childs;
    }

    public void setCustomCellStyle(CellStyle customCellStyle) {
        this.customCellStyle = customCellStyle;
    }

    public void setAxolotlCellStyle(AxolotlCellStyle axolotlCellStyle) {
        this.axolotlCellStyle = axolotlCellStyle;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public void setParticipateInCalculate(boolean participateInCalculate) {
        this.participateInCalculate = participateInCalculate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header other = (Header)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getColumnPosition() != other.getColumnPosition()) {
            return false;
        }
        if (this.getColumnWidth() != other.getColumnWidth()) {
            return false;
        }
        if (this.isParticipateInCalculate() != other.isParticipateInCalculate()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        List<Header> this$childs = this.getChilds();
        List<Header> other$childs = other.getChilds();
        if (this$childs == null ? other$childs != null : !((Object)this$childs).equals(other$childs)) {
            return false;
        }
        CellStyle this$customCellStyle = this.getCustomCellStyle();
        CellStyle other$customCellStyle = other.getCustomCellStyle();
        if (this$customCellStyle == null ? other$customCellStyle != null : !this$customCellStyle.equals(other$customCellStyle)) {
            return false;
        }
        AxolotlCellStyle this$axolotlCellStyle = this.getAxolotlCellStyle();
        AxolotlCellStyle other$axolotlCellStyle = other.getAxolotlCellStyle();
        return !(this$axolotlCellStyle == null ? other$axolotlCellStyle != null : !((Object)this$axolotlCellStyle).equals(other$axolotlCellStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Header;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getColumnPosition();
        result = result * 59 + this.getColumnWidth();
        result = result * 59 + (this.isParticipateInCalculate() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        List<Header> $childs = this.getChilds();
        result = result * 59 + ($childs == null ? 43 : ((Object)$childs).hashCode());
        CellStyle $customCellStyle = this.getCustomCellStyle();
        result = result * 59 + ($customCellStyle == null ? 43 : $customCellStyle.hashCode());
        AxolotlCellStyle $axolotlCellStyle = this.getAxolotlCellStyle();
        result = result * 59 + ($axolotlCellStyle == null ? 43 : ((Object)$axolotlCellStyle).hashCode());
        return result;
    }

    public String toString() {
        return "Header(name=" + this.getName() + ", fieldName=" + this.getFieldName() + ", columnPosition=" + this.getColumnPosition() + ", childs=" + this.getChilds() + ", customCellStyle=" + this.getCustomCellStyle() + ", axolotlCellStyle=" + this.getAxolotlCellStyle() + ", columnWidth=" + this.getColumnWidth() + ", participateInCalculate=" + this.isParticipateInCalculate() + ")";
    }
}

