/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.style;

import cn.toutatis.xvoid.axolotl.excel.writer.AutoWriteConfig;
import cn.toutatis.xvoid.axolotl.excel.writer.components.AxolotlCellStyle;
import cn.toutatis.xvoid.axolotl.excel.writer.components.AxolotlColor;
import cn.toutatis.xvoid.axolotl.excel.writer.components.Header;
import cn.toutatis.xvoid.axolotl.excel.writer.exceptions.AxolotlWriteException;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.StyleHelper;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AutoWriteContext;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import cn.toutatis.xvoid.axolotl.excel.writer.support.DataInverter;
import cn.toutatis.xvoid.axolotl.excel.writer.support.ExcelWritePolicy;
import cn.toutatis.xvoid.axolotl.toolkit.ExcelToolkit;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.clazz.ReflectToolkit;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.slf4j.Logger;

public abstract class AbstractStyleRender
implements ExcelStyleRender {
    protected AutoWriteConfig writeConfig;
    protected AutoWriteContext context;
    private final Logger LOGGER;
    private String globalFontName;
    private AxolotlColor themeColor;
    private boolean alreadyNotice = false;
    public static final String TOTAL_HEADER_COUNT_KEY = "";
    private Map<Integer, Integer> unmappedColumnCount;

    public AbstractStyleRender(Logger LOGGER) {
        this.LOGGER = LOGGER;
    }

    public String globalFontName() {
        return this.globalFontName;
    }

    public void setGlobalFontName(String globalFontName) {
        this.globalFontName = globalFontName;
    }

    public boolean isFirstBatch() {
        return this.context.isFirstBatch(this.context.getSwitchSheetIndex());
    }

    public void checkedAndUseCustomTheme(String themeFont, AxolotlColor themeColor) {
        String fontName = this.writeConfig.getFontName();
        if (fontName != null) {
            LoggerHelper.debug(this.LOGGER, "\u4f7f\u7528\u81ea\u5b9a\u4e49\u5b57\u4f53\uff1a%s", fontName);
            this.setGlobalFontName(fontName);
        } else {
            this.setGlobalFontName(Objects.requireNonNullElse(themeFont, "Arial"));
        }
        this.setThemeColor(Objects.requireNonNullElse(themeColor, StyleHelper.STANDARD_THEME_COLOR));
    }

    @Override
    public AxolotlWriteResult init(SXSSFSheet sheet) {
        AxolotlWriteResult axolotlWriteResult;
        if (this.isFirstBatch()) {
            axolotlWriteResult = new AxolotlWriteResult(true, "\u521d\u59cb\u5316\u6210\u529f");
            String sheetName = this.writeConfig.getSheetName();
            if (Validator.strNotBlank((Object)sheetName)) {
                int sheetIndex = this.writeConfig.getSheetIndex();
                LoggerHelper.info(this.LOGGER, "\u8bbe\u7f6e\u5de5\u4f5c\u8868\u7d22\u5f15[%s]\u8868\u540d\u4e3a:[%s]", sheetIndex, sheetName);
                this.context.getWorkbook().setSheetName(sheetIndex, sheetName);
            } else {
                LoggerHelper.debug(this.LOGGER, "\u672a\u8bbe\u7f6e\u5de5\u4f5c\u8868\u540d\u79f0");
            }
            boolean fillWhite = this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_FILL_DEFAULT_CELL_WHITE);
            if (fillWhite) {
                this.fillWhiteCell((Sheet)sheet, this.globalFontName);
            }
            if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_CATCH_COLUMN_LENGTH)) {
                LoggerHelper.debug(this.LOGGER, "\u5f00\u542f\u81ea\u52a8\u83b7\u53d6\u5217\u5bbd");
                sheet.trackAllColumnsForAutoSizing();
            }
        } else {
            axolotlWriteResult = new AxolotlWriteResult(true, "\u5df2\u521d\u59cb\u5316");
        }
        return axolotlWriteResult;
    }

    public void fillWhiteCell(Sheet sheet, String fontName) {
        Font font = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), fontName, false, StyleHelper.STANDARD_TEXT_FONT_SIZE, IndexedColors.BLACK);
        CellStyle defaultStyle = StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), BorderStyle.NONE, IndexedColors.WHITE, new AxolotlColor(255, 255, 255), font);
        for (int i = 0; i < 26; ++i) {
            sheet.setDefaultColumnStyle(i, defaultStyle);
            sheet.setDefaultColumnWidth(12);
        }
        sheet.setDefaultRowHeight((short)400);
    }

    public AxolotlWriteResult createTitleRow(SXSSFSheet sheet) {
        String title = this.writeConfig.getTitle();
        if (Validator.strNotBlank((Object)title)) {
            LoggerHelper.debug(this.LOGGER, "\u8bbe\u7f6e\u5de5\u4f5c\u8868\u6807\u9898:[%s]", title);
            int switchSheetIndex = this.context.getSwitchSheetIndex();
            Map<Integer, Integer> alreadyWriteRowMap = this.context.getAlreadyWriteRow();
            int alreadyWriteRow = alreadyWriteRowMap.getOrDefault(switchSheetIndex, -1);
            alreadyWriteRowMap.put(switchSheetIndex, ++alreadyWriteRow);
            SXSSFRow titleRow = sheet.createRow(alreadyWriteRow);
            titleRow.setHeight(StyleHelper.STANDARD_TITLE_ROW_HEIGHT.shortValue());
            SXSSFCell startPositionCell = titleRow.createCell(0);
            startPositionCell.setCellValue(this.writeConfig.getTitle());
            return new AxolotlWriteResult(true, LoggerHelper.format("\u8bbe\u7f6e\u5de5\u4f5c\u8868\u6807\u9898:[%s]", title));
        }
        String message = "\u672a\u8bbe\u7f6e\u5de5\u4f5c\u8868\u6807\u9898";
        LoggerHelper.debug(this.LOGGER, message);
        return new AxolotlWriteResult(false, message);
    }

    public void mergeTitleRegion(SXSSFSheet sheet, int titleColumnCount, CellStyle titleStyle) {
        if (titleColumnCount > 1) {
            LoggerHelper.debug(this.LOGGER, "\u5408\u5e76\u6807\u9898\u680f\u5355\u5143\u683c,\u5171[%s]\u5217", titleColumnCount);
            CellRangeAddress cellAddresses = new CellRangeAddress(0, 0, 0, titleColumnCount - 1);
            StyleHelper.renderMergeRegionStyle((Sheet)sheet, cellAddresses, titleStyle);
            sheet.addMergedRegion(cellAddresses);
        } else {
            sheet.getRow(0).getCell(0).setCellStyle(titleStyle);
        }
    }

    public AxolotlWriteResult defaultRenderHeaders(SXSSFSheet sheet, CellStyle headerDefaultCellStyle) {
        int headerMaxDepth;
        int switchSheetIndex = this.context.getSwitchSheetIndex();
        List<Header> headers = this.context.getHeaders().get(switchSheetIndex);
        int headerColumnCount = 0;
        int alreadyWriteRow = this.context.getAlreadyWriteRow().getOrDefault(this.context.getSwitchSheetIndex(), -1);
        if (headers != null && !headers.isEmpty()) {
            List<Header> cacheHeaders;
            if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_INSERT_SERIAL_NUMBER)) {
                cacheHeaders = new ArrayList<Header>();
                cacheHeaders.add(new Header("\u5e8f\u53f7"));
                cacheHeaders.addAll(headers);
            } else {
                cacheHeaders = headers;
            }
            this.context.getAlreadyWriteRow().put(switchSheetIndex, ++alreadyWriteRow);
            headerMaxDepth = ExcelToolkit.getMaxDepth(headers, 0);
            LoggerHelper.debug(this.LOGGER, "\u8d77\u59cb\u884c\u6b21\u4e3a[%s]\uff0c\u8868\u5934\u6700\u5927\u6df1\u5ea6\u4e3a[%s]", alreadyWriteRow, headerMaxDepth);
            int sheetIndex = this.writeConfig.getSheetIndex();
            Map headerCache = this.context.getHeaderColumnIndexMapping().row((Object)sheetIndex);
            for (Header header : cacheHeaders) {
                CellRangeAddress cellAddresses;
                CellStyle usedCellStyle = headerDefaultCellStyle;
                usedCellStyle = this.getCellStyle(header, usedCellStyle);
                Row row = ExcelToolkit.createOrCatchRow((Sheet)sheet, alreadyWriteRow);
                row.setHeight(StyleHelper.STANDARD_HEADER_ROW_HEIGHT.shortValue());
                Cell cell = row.createCell(headerColumnCount, CellType.STRING);
                String title = header.getName();
                cell.setCellValue(title);
                int orlopCellNumber = header.countOrlopCellNumber();
                this.context.getAlreadyWrittenColumns().put(switchSheetIndex, this.context.getAlreadyWrittenColumns().getOrDefault(switchSheetIndex, 0) + orlopCellNumber);
                LoggerHelper.debug(this.LOGGER, "\u6e32\u67d3\u8868\u5934[%s],\u884c[%s],\u5217[%s],\u5b50\u8868\u5934\u5217\u6570\u91cf[%s]", title, alreadyWriteRow, headerColumnCount, orlopCellNumber);
                if (header.getChilds() != null && !header.getChilds().isEmpty()) {
                    List<Header> childs = header.getChilds();
                    int childMaxDepth = ExcelToolkit.getMaxDepth(childs, 0);
                    cellAddresses = new CellRangeAddress(alreadyWriteRow, alreadyWriteRow + (headerMaxDepth - childMaxDepth) - 1, headerColumnCount, headerColumnCount + orlopCellNumber - 1);
                    HeaderRecursiveInfo headerRecursiveInfo = new HeaderRecursiveInfo();
                    headerRecursiveInfo.setAllRow(alreadyWriteRow + headerMaxDepth + 1);
                    headerRecursiveInfo.setStartColumn(headerColumnCount);
                    headerRecursiveInfo.setAlreadyWriteColumn(headerColumnCount);
                    headerRecursiveInfo.setCellStyle(headerDefaultCellStyle);
                    headerRecursiveInfo.setRowHeight(StyleHelper.STANDARD_HEADER_ROW_HEIGHT);
                    this.recursionRenderHeaders(sheet, childs, headerRecursiveInfo);
                } else {
                    cellAddresses = new CellRangeAddress(alreadyWriteRow, alreadyWriteRow + headerMaxDepth - 1, headerColumnCount, headerColumnCount);
                    String fieldName = header.getFieldName();
                    if (fieldName != null) {
                        LoggerHelper.debug(this.LOGGER, "\u6620\u5c04\u5b57\u6bb5[%s]\u5230\u5217\u7d22\u5f15[%s]", fieldName, headerColumnCount);
                        headerCache.put(fieldName, headerColumnCount);
                    }
                    if (!this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_CATCH_COLUMN_LENGTH)) {
                        int columnWidth = header.getColumnWidth();
                        if (columnWidth < 0) {
                            columnWidth = StyleHelper.getPresetCellLength(title);
                        }
                        LoggerHelper.debug(this.LOGGER, "\u5217[%s]\u8868\u5934[%s]\u8bbe\u7f6e\u5217\u5bbd[%s]", headerColumnCount, header.getName(), columnWidth);
                        sheet.setColumnWidth(headerColumnCount, columnWidth);
                    } else {
                        LoggerHelper.debug(this.LOGGER, "\u5217[%s]\u8868\u5934[%s]\u8bbe\u7f6e\u5217\u5bbd[%s]", headerColumnCount, header.getName(), "AUTO");
                    }
                    if (header.isParticipateInCalculate()) {
                        LoggerHelper.debug(this.LOGGER, "\u5217[%s]\u8868\u5934[%s]\u53c2\u4e0e\u8ba1\u7b97", headerColumnCount, header.getName());
                        this.writeConfig.addCalculateColumnIndex(headerColumnCount);
                    }
                }
                StyleHelper.renderMergeRegionStyle((Sheet)sheet, cellAddresses, usedCellStyle);
                if (headerMaxDepth > 1) {
                    sheet.addMergedRegion(cellAddresses);
                }
                headerColumnCount += orlopCellNumber;
            }
        } else {
            headerMaxDepth = 0;
            LoggerHelper.debug(this.LOGGER, "\u672a\u8bbe\u7f6e\u8868\u5934");
        }
        this.context.getHeaderRowCount().put(switchSheetIndex, headerMaxDepth);
        this.context.getAlreadyWriteRow().put(switchSheetIndex, alreadyWriteRow += headerMaxDepth - 1);
        this.context.getAlreadyWrittenColumns().put(switchSheetIndex, headerColumnCount);
        return new AxolotlWriteResult(true, "\u6e32\u67d3\u8868\u5934\u6210\u529f");
    }

    public CellStyle getCellStyle(Header header, CellStyle usedCellStyle) {
        if (header.getCustomCellStyle() != null) {
            usedCellStyle = header.getCustomCellStyle();
        } else {
            AxolotlCellStyle axolotlCellStyle = header.getAxolotlCellStyle();
            if (axolotlCellStyle != null) {
                Font axolotlCustomFont = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), axolotlCellStyle.getFontName(), axolotlCellStyle.isFontBold(), axolotlCellStyle.getFontSize(), axolotlCellStyle.getFontColor());
                usedCellStyle = StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), axolotlCellStyle.getBorderStyle(), axolotlCellStyle.getBorderColor(), axolotlCellStyle.getForegroundColor(), axolotlCustomFont);
            }
        }
        return usedCellStyle;
    }

    private void recursionRenderHeaders(SXSSFSheet sheet, List<Header> headers, HeaderRecursiveInfo headerRecursiveInfo) {
        if (headers != null && !headers.isEmpty()) {
            int maxDepth = ExcelToolkit.getMaxDepth(headers, 0);
            int startRow = headerRecursiveInfo.getAllRow() - maxDepth - 1;
            Row row = ExcelToolkit.createOrCatchRow((Sheet)sheet, startRow);
            row.setHeight(headerRecursiveInfo.getRowHeight());
            int sheetIndex = this.writeConfig.getSheetIndex();
            Map headerCache = this.context.getHeaderColumnIndexMapping().row((Object)sheetIndex);
            for (Header header : headers) {
                CellRangeAddress cellAddresses;
                CellStyle usedCellStyle = headerRecursiveInfo.getCellStyle();
                usedCellStyle = this.getCellStyle(header, usedCellStyle);
                int alreadyWriteColumn = headerRecursiveInfo.getAlreadyWriteColumn();
                Cell cell = ExcelToolkit.createOrCatchCell((Sheet)sheet, row.getRowNum(), alreadyWriteColumn, null);
                cell.setCellValue(header.getName());
                int childCount = header.countOrlopCellNumber();
                int endColumnPosition = alreadyWriteColumn + childCount;
                int mergeRowNumber = startRow + maxDepth - 1;
                if (header.getChilds() != null && !header.getChilds().isEmpty()) {
                    cellAddresses = new CellRangeAddress(startRow, startRow, alreadyWriteColumn, endColumnPosition - 1);
                } else {
                    cellAddresses = new CellRangeAddress(startRow, startRow + maxDepth - 1, alreadyWriteColumn, endColumnPosition - 1);
                    if (!this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_CATCH_COLUMN_LENGTH)) {
                        int columnWidth = header.getColumnWidth();
                        if (columnWidth == -1) {
                            columnWidth = StyleHelper.getPresetCellLength(header.getName());
                        }
                        LoggerHelper.debug(this.LOGGER, "\u5217[%s]\u8868\u5934[%s]\u8bbe\u7f6e\u5217\u5bbd[%s]", alreadyWriteColumn, header.getName(), columnWidth);
                        sheet.setColumnWidth(alreadyWriteColumn, columnWidth);
                    } else {
                        LoggerHelper.debug(this.LOGGER, "\u5217[%s]\u8868\u5934[%s]\u8bbe\u7f6e\u5217\u5bbd[%s]", alreadyWriteColumn, header.getName(), "AUTO");
                    }
                }
                StyleHelper.renderMergeRegionStyle((Sheet)sheet, cellAddresses, usedCellStyle);
                if (mergeRowNumber != startRow) {
                    sheet.addMergedRegion(cellAddresses);
                }
                headerRecursiveInfo.setAlreadyWriteColumn(endColumnPosition);
                headerRecursiveInfo.setStartColumn(alreadyWriteColumn);
                if (header.getChilds() != null && !header.getChilds().isEmpty()) {
                    HeaderRecursiveInfo child = new HeaderRecursiveInfo();
                    BeanUtils.copyProperties((Object)child, (Object)headerRecursiveInfo);
                    child.setAlreadyWriteColumn(headerRecursiveInfo.getStartColumn());
                    this.recursionRenderHeaders(sheet, header.getChilds(), child);
                    continue;
                }
                String fieldName = header.getFieldName();
                if (fieldName != null) {
                    LoggerHelper.debug(this.LOGGER, "\u6620\u5c04\u5b57\u6bb5[%s]\u5230\u5217\u7d22\u5f15[%s]", fieldName, alreadyWriteColumn);
                    headerCache.put(fieldName, alreadyWriteColumn);
                }
                if (!header.isParticipateInCalculate()) continue;
                LoggerHelper.debug(this.LOGGER, "\u5217[%s]\u8868\u5934[%s]\u53c2\u4e0e\u8ba1\u7b97", alreadyWriteColumn, header.getName());
                this.writeConfig.addCalculateColumnIndex(alreadyWriteColumn);
            }
        }
    }

    public void defaultRenderNextData(SXSSFSheet sheet, Object data, CellStyle rowStyle) {
        LinkedHashMap dataMap = new LinkedHashMap();
        if (data instanceof Map) {
            Map map = (Map)data;
            dataMap.putAll(map);
        } else {
            List fields = ReflectToolkit.getAllFields(data.getClass(), (boolean)true);
            fields.forEach(field -> {
                field.setAccessible(true);
                String fieldName = field.getName();
                try {
                    dataMap.put(fieldName, field.get(data));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new AxolotlWriteException("\u83b7\u53d6\u5bf9\u8c61\u5b57\u6bb5\u9519\u8bef");
                }
            });
        }
        HashMap<Integer, Integer> writtenColumnMap = new HashMap<Integer, Integer>();
        int switchSheetIndex = this.getContext().getSwitchSheetIndex();
        Map<Integer, Integer> alreadyWriteRowMap = this.context.getAlreadyWriteRow();
        int alreadyWriteRow = alreadyWriteRowMap.getOrDefault(switchSheetIndex, -1);
        alreadyWriteRowMap.put(switchSheetIndex, ++alreadyWriteRow);
        SXSSFRow dataRow = sheet.createRow(alreadyWriteRow);
        int writtenColumn = 0;
        int serialNumber = this.context.getAndIncrementSerialNumber() - this.context.getHeaderRowCount().get(switchSheetIndex) + 1;
        if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_INSERT_SERIAL_NUMBER)) {
            SXSSFCell cell = dataRow.createCell(writtenColumn);
            cell.setCellValue((double)serialNumber);
            cell.setCellStyle(rowStyle);
            writtenColumnMap.put(writtenColumn++, 1);
        }
        Map columnMapping = this.context.getHeaderColumnIndexMapping().row((Object)this.context.getSwitchSheetIndex());
        this.unmappedColumnCount = new HashMap<Integer, Integer>();
        columnMapping.forEach((key, value) -> this.unmappedColumnCount.put((Integer)value, 1));
        boolean columnMappingEmpty = columnMapping.isEmpty();
        boolean useOrderField = true;
        for (Map.Entry dataEntry : ((HashMap)dataMap).entrySet()) {
            SXSSFCell cell;
            String fieldName = (String)dataEntry.getKey();
            if (columnMappingEmpty) {
                cell = dataRow.createCell(writtenColumn);
            } else {
                useOrderField = false;
                if (columnMapping.containsKey(fieldName)) {
                    cell = (SXSSFCell)ExcelToolkit.createOrCatchCell((Sheet)sheet, alreadyWriteRow, (Integer)columnMapping.get(fieldName), null);
                } else {
                    if (this.alreadyNotice) continue;
                    LoggerHelper.warn(this.LOGGER, "\u672a\u6620\u5c04\u5b57\u6bb5[%s]\u8bf7\u5728\u8868\u5934Header\u4e2d\u6620\u5c04\u5b57\u6bb5!", fieldName);
                    this.alreadyNotice = true;
                    continue;
                }
            }
            Object value2 = dataEntry.getValue();
            FieldInfo fieldInfo = new FieldInfo(fieldName, value2, writtenColumn, alreadyWriteRow);
            cell.setCellStyle(rowStyle);
            this.renderColumn(fieldInfo, (Cell)cell);
            writtenColumnMap.put(writtenColumn++, 1);
        }
        for (int alreadyColumnIdx = 0; alreadyColumnIdx < this.context.getAlreadyWrittenColumns().get(switchSheetIndex); ++alreadyColumnIdx) {
            SXSSFCell cell = null;
            if (useOrderField) {
                if (!writtenColumnMap.containsKey(alreadyColumnIdx)) {
                    cell = dataRow.createCell(alreadyColumnIdx);
                }
            } else {
                if (!columnMapping.containsValue(alreadyColumnIdx)) {
                    cell = dataRow.createCell(alreadyColumnIdx);
                }
                if (this.unmappedColumnCount.containsKey(alreadyColumnIdx)) {
                    cell = dataRow.createCell(alreadyColumnIdx);
                }
            }
            if (cell == null) continue;
            cell.setCellValue(this.writeConfig.getBlankValue());
            cell.setCellStyle(rowStyle);
        }
    }

    public void renderColumn(FieldInfo fieldInfo, Cell cell) {
        Object value = fieldInfo.getValue();
        if (value == null) {
            cell.setCellValue(this.writeConfig.getBlankValue());
        } else {
            this.calculateColumns(fieldInfo);
            value = this.writeConfig.getDataInverter().convert(value);
            int columnIndex = fieldInfo.getColumnIndex();
            cell.setCellValue(value.toString());
            this.unmappedColumnCount.remove(columnIndex);
        }
    }

    public void calculateColumns(FieldInfo fieldInfo) {
        int columnIndex = fieldInfo.getColumnIndex();
        String value = fieldInfo.getValue().toString();
        if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_INSERT_TOTAL_IN_ENDING) && Validator.strIsNumber((String)value)) {
            Map endingTotalMapping = this.context.getEndingTotalMapping().row((Object)this.context.getSwitchSheetIndex());
            if (endingTotalMapping.containsKey(columnIndex)) {
                BigDecimal newValue = ((BigDecimal)endingTotalMapping.get(columnIndex)).add(BigDecimal.valueOf(Double.parseDouble(value)));
                endingTotalMapping.put(columnIndex, newValue);
            } else {
                endingTotalMapping.put(columnIndex, BigDecimal.valueOf(Double.parseDouble(value)));
            }
        }
    }

    @Override
    public AxolotlWriteResult finish(SXSSFSheet sheet) {
        LoggerHelper.debug(this.LOGGER, "\u7ed3\u675f\u6e32\u67d3\u5de5\u4f5c\u8868[%s]", sheet.getSheetName());
        int alreadyWrittenColumns = this.context.getAlreadyWrittenColumns().get(this.context.getSwitchSheetIndex());
        if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_INSERT_TOTAL_IN_ENDING)) {
            Map endingTotalMapping = this.context.getEndingTotalMapping().row((Object)this.context.getSwitchSheetIndex());
            LoggerHelper.debug(this.LOGGER, "\u5f00\u59cb\u521b\u5efa\u7ed3\u5c3e\u5408\u8ba1\u884c,\u5408\u8ba1\u6570\u636e\u4e3a:%s", endingTotalMapping);
            SXSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
            row.setHeight((short)600);
            DataInverter<?> dataInverter = this.writeConfig.getDataInverter();
            HashSet<Integer> calculateColumnIndexes = this.writeConfig.getCalculateColumnIndexes();
            for (int i = 0; i < alreadyWrittenColumns; ++i) {
                SXSSFCell cell = row.createCell(i);
                String cellValue = "-";
                if (i == 0 && this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_INSERT_SERIAL_NUMBER)) {
                    cellValue = "\u5408\u8ba1";
                    sheet.setColumnWidth(i, StyleHelper.SERIAL_NUMBER_LENGTH.intValue());
                }
                if (endingTotalMapping.containsKey(i) && (calculateColumnIndexes.contains(i) || calculateColumnIndexes.size() == 1 && calculateColumnIndexes.contains(-1))) {
                    BigDecimal bigDecimal = (BigDecimal)endingTotalMapping.get(i);
                    Object convert = dataInverter.convert(bigDecimal);
                    cellValue = convert.toString();
                }
                cell.setCellValue(cellValue);
                CellStyle cellStyle = sheet.getRow(sheet.getLastRowNum() - 1).getCell(i).getCellStyle();
                SXSSFWorkbook workbook = sheet.getWorkbook();
                CellStyle totalCellStyle = workbook.createCellStyle();
                Font font = StyleHelper.createWorkBookFont((Workbook)workbook, this.globalFontName, true, StyleHelper.STANDARD_TEXT_FONT_SIZE, IndexedColors.BLACK);
                StyleHelper.setCellStyleAlignmentCenter(totalCellStyle);
                totalCellStyle.setFillForegroundColor(cellStyle.getFillForegroundColorColor());
                totalCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                totalCellStyle.setFont(font);
                BorderStyle borderStyle = BorderStyle.THIN;
                totalCellStyle.setBorderBottom(borderStyle);
                totalCellStyle.setBorderLeft(borderStyle);
                totalCellStyle.setBorderRight(borderStyle);
                totalCellStyle.setBorderTop(borderStyle);
                totalCellStyle.setLeftBorderColor(cellStyle.getLeftBorderColor());
                totalCellStyle.setRightBorderColor(cellStyle.getRightBorderColor());
                totalCellStyle.setTopBorderColor(cellStyle.getTopBorderColor());
                totalCellStyle.setBottomBorderColor(cellStyle.getBottomBorderColor());
                totalCellStyle.setDataFormat((short)49);
                cell.setCellStyle(totalCellStyle);
            }
        }
        if (this.writeConfig.getWritePolicyAsBoolean(ExcelWritePolicy.AUTO_CATCH_COLUMN_LENGTH)) {
            LoggerHelper.debug(this.LOGGER, "\u5f00\u59cb\u81ea\u52a8\u8ba1\u7b97\u5217\u5bbd");
            for (int columnIdx = 0; columnIdx < alreadyWrittenColumns; ++columnIdx) {
                sheet.autoSizeColumn(columnIdx, true);
                sheet.setColumnWidth(columnIdx, (int)((double)sheet.getColumnWidth(columnIdx) * 1.35));
            }
        }
        Map<Integer, Integer> specialRowHeightMapping = this.writeConfig.getSpecialRowHeightMapping();
        for (Map.Entry<Integer, Integer> heightEntry : specialRowHeightMapping.entrySet()) {
            LoggerHelper.debug(this.LOGGER, "\u8bbe\u7f6e\u5de5\u4f5c\u8868[%s]\u7b2c%s\u884c\u9ad8\u5ea6\u4e3a%s", sheet.getSheetName(), heightEntry.getKey(), heightEntry.getValue());
            sheet.getRow(heightEntry.getKey().intValue()).setHeightInPoints((float)heightEntry.getValue().intValue());
        }
        return new AxolotlWriteResult(true, "\u5b8c\u6210\u7ed3\u675f\u9636\u6bb5");
    }

    public Font createFont(String fontName, short fontSize, boolean isBold, IndexedColors color) {
        return StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), fontName, isBold, fontSize, color);
    }

    public Font createFont(String fontName, short fontSize, boolean isBold, AxolotlColor color) {
        XSSFFont font = new XSSFFont();
        font.setColor(color.toXSSFColor());
        font.setBold(isBold);
        font.setFontName(fontName);
        font.setFontHeightInPoints(fontSize);
        StylesTable stylesSource = this.context.getWorkbook().getXSSFWorkbook().getStylesSource();
        font.registerTo(stylesSource);
        return font;
    }

    public Font createMainTextFont(short fontSize, AxolotlColor color) {
        return this.createFont(this.globalFontName, fontSize, false, color);
    }

    public Font createMainTextFont(AxolotlColor color) {
        return this.createMainTextFont((short)StyleHelper.STANDARD_TEXT_FONT_SIZE, color);
    }

    public Font createMainTextFont(short fontSize, IndexedColors color) {
        return this.createFont(this.globalFontName, fontSize, false, color);
    }

    public Font createMainTextFont(IndexedColors color) {
        return this.createMainTextFont((short)StyleHelper.STANDARD_TEXT_FONT_SIZE, color);
    }

    public Font createBlackMainTextFont() {
        return this.createMainTextFont(IndexedColors.BLACK);
    }

    public Font createWhiteMainTextFont() {
        return this.createMainTextFont(IndexedColors.WHITE);
    }

    public Font createRedMainTextFont() {
        return this.createMainTextFont(IndexedColors.RED);
    }

    public CellStyle createBlackMainTextCellStyle(IndexedColors borderColor, AxolotlColor cellColor) {
        return this.createStyle(BorderStyle.THIN, borderColor, cellColor, this.globalFontName, StyleHelper.STANDARD_TEXT_FONT_SIZE, false, IndexedColors.BLACK);
    }

    public CellStyle createBlackMainTextCellStyle(BorderStyle borderStyle, IndexedColors borderColor, AxolotlColor cellColor) {
        return this.createStyle(borderStyle, borderColor, cellColor, this.globalFontName, StyleHelper.STANDARD_TEXT_FONT_SIZE, false, IndexedColors.BLACK);
    }

    public CellStyle createStyle(BorderStyle borderStyle, IndexedColors borderColor, AxolotlColor cellColor, Font font) {
        return StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), borderStyle, borderColor, cellColor, font);
    }

    public CellStyle createStyle(BorderStyle borderStyle, IndexedColors borderColor, AxolotlColor cellColor, String fontName, short fontSize, boolean isBold, Object fontColor) {
        Font font;
        if (fontColor instanceof AxolotlColor) {
            font = this.createFont(fontName, fontSize, isBold, (AxolotlColor)fontColor);
        } else if (fontColor instanceof IndexedColors) {
            font = this.createFont(fontName, fontSize, isBold, (IndexedColors)fontColor);
        } else {
            throw new IllegalArgumentException("\u5b57\u4f53\u989c\u8272\u7c7b\u578b\u9519\u8bef");
        }
        return StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), borderStyle, borderColor, cellColor, font);
    }

    public AutoWriteConfig getWriteConfig() {
        return this.writeConfig;
    }

    public AutoWriteContext getContext() {
        return this.context;
    }

    public Logger getLOGGER() {
        return this.LOGGER;
    }

    public String getGlobalFontName() {
        return this.globalFontName;
    }

    public boolean isAlreadyNotice() {
        return this.alreadyNotice;
    }

    public Map<Integer, Integer> getUnmappedColumnCount() {
        return this.unmappedColumnCount;
    }

    public void setWriteConfig(AutoWriteConfig writeConfig) {
        this.writeConfig = writeConfig;
    }

    public void setContext(AutoWriteContext context) {
        this.context = context;
    }

    public AxolotlColor getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(AxolotlColor themeColor) {
        this.themeColor = themeColor;
    }

    public class HeaderRecursiveInfo
    implements Serializable,
    Cloneable {
        private int allRow;
        private int startColumn;
        private int alreadyWriteColumn;
        private CellStyle cellStyle;
        private short rowHeight;

        public int getAllRow() {
            return this.allRow;
        }

        public int getStartColumn() {
            return this.startColumn;
        }

        public int getAlreadyWriteColumn() {
            return this.alreadyWriteColumn;
        }

        public CellStyle getCellStyle() {
            return this.cellStyle;
        }

        public short getRowHeight() {
            return this.rowHeight;
        }

        public void setAllRow(int allRow) {
            this.allRow = allRow;
        }

        public void setStartColumn(int startColumn) {
            this.startColumn = startColumn;
        }

        public void setAlreadyWriteColumn(int alreadyWriteColumn) {
            this.alreadyWriteColumn = alreadyWriteColumn;
        }

        public void setCellStyle(CellStyle cellStyle) {
            this.cellStyle = cellStyle;
        }

        public void setRowHeight(short rowHeight) {
            this.rowHeight = rowHeight;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HeaderRecursiveInfo)) {
                return false;
            }
            HeaderRecursiveInfo other = (HeaderRecursiveInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAllRow() != other.getAllRow()) {
                return false;
            }
            if (this.getStartColumn() != other.getStartColumn()) {
                return false;
            }
            if (this.getAlreadyWriteColumn() != other.getAlreadyWriteColumn()) {
                return false;
            }
            if (this.getRowHeight() != other.getRowHeight()) {
                return false;
            }
            CellStyle this$cellStyle = this.getCellStyle();
            CellStyle other$cellStyle = other.getCellStyle();
            return !(this$cellStyle == null ? other$cellStyle != null : !this$cellStyle.equals(other$cellStyle));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HeaderRecursiveInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAllRow();
            result = result * 59 + this.getStartColumn();
            result = result * 59 + this.getAlreadyWriteColumn();
            result = result * 59 + this.getRowHeight();
            CellStyle $cellStyle = this.getCellStyle();
            result = result * 59 + ($cellStyle == null ? 43 : $cellStyle.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractStyleRender.HeaderRecursiveInfo(allRow=" + this.getAllRow() + ", startColumn=" + this.getStartColumn() + ", alreadyWriteColumn=" + this.getAlreadyWriteColumn() + ", cellStyle=" + this.getCellStyle() + ", rowHeight=" + this.getRowHeight() + ")";
        }
    }

    protected static class FieldInfo {
        private Class<?> clazz;
        private final String fieldName;
        private final Object value;
        private final int columnIndex;
        private final int rowIndex;

        public FieldInfo(String fieldName, Object value, int columnIndex, int rowIndex) {
            if (value != null) {
                this.clazz = value.getClass();
            }
            this.fieldName = fieldName;
            this.value = value;
            this.columnIndex = columnIndex;
            this.rowIndex = rowIndex;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getValue() {
            return this.value;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldInfo)) {
                return false;
            }
            FieldInfo other = (FieldInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getColumnIndex() != other.getColumnIndex()) {
                return false;
            }
            if (this.getRowIndex() != other.getRowIndex()) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getColumnIndex();
            result = result * 59 + this.getRowIndex();
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractStyleRender.FieldInfo(clazz=" + this.getClazz() + ", fieldName=" + this.getFieldName() + ", value=" + this.getValue() + ", columnIndex=" + this.getColumnIndex() + ", rowIndex=" + this.getRowIndex() + ")";
        }
    }
}

