/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.style;

import cn.toutatis.xvoid.axolotl.excel.writer.components.AxolotlColor;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class StyleHelper {
    public static final Map<String, Integer> PRESET_CELL_LENGTH_MAP = new HashMap<String, Integer>();
    public static final String STANDARD_FONT_NAME = "Arial";
    public static final AxolotlColor WHITE_COLOR = AxolotlColor.create(255, 255, 255);
    public static final AxolotlColor BLACK_COLOR = AxolotlColor.create(0, 0, 0);
    public static final AxolotlColor STANDARD_THEME_COLOR = WHITE_COLOR;
    public static final int START_POSITION = 0;
    public static final Short STANDARD_TITLE_FONT_SIZE = 18;
    public static final Short STANDARD_TITLE_ROW_HEIGHT = 600;
    public static final Short STANDARD_HEADER_ROW_HEIGHT = 350;
    public static final Short STANDARD_TEXT_FONT_SIZE = 12;
    public static final Integer SERIAL_NUMBER_LENGTH = 5120;
    public static final short DATA_FORMAT_PLAIN_TEXT_INDEX = 49;

    public static Integer getPresetCellLength(String cellName) {
        return PRESET_CELL_LENGTH_MAP.getOrDefault(cellName, (int)((double)(cellName.length() * 512) * 1.5));
    }

    public static void renderMergeRegionStyle(Sheet sheet, CellRangeAddress cellRangeAddress, CellStyle style) {
        for (int rowNum = cellRangeAddress.getFirstRow(); rowNum <= cellRangeAddress.getLastRow(); ++rowNum) {
            Row currentRow = sheet.getRow(rowNum);
            if (currentRow == null) {
                currentRow = sheet.createRow(rowNum);
            }
            for (int colNum = cellRangeAddress.getFirstColumn(); colNum <= cellRangeAddress.getLastColumn(); ++colNum) {
                Cell currentCell = currentRow.getCell(colNum);
                if (currentCell == null) {
                    currentCell = currentRow.createCell(colNum);
                }
                currentCell.setCellStyle(style);
            }
        }
    }

    public static void setCellStyleAlignmentCenter(CellStyle cellStyle) {
        StyleHelper.setCellStyleAlignment(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
    }

    public static void setCellStyleAlignment(CellStyle cellStyle, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        cellStyle.setAlignment(horizontalAlignment);
        cellStyle.setVerticalAlignment(verticalAlignment);
    }

    public static Font createWorkBookFont(Workbook workbook, String fontName, boolean bold, short fontSize, IndexedColors fontColor) {
        Font font = workbook.createFont();
        font.setFontName(fontName);
        font.setBold(bold);
        font.setFontHeightInPoints(fontSize);
        font.setColor(fontColor.getIndex());
        return font;
    }

    public static CellStyle createCellStyle(Workbook workbook, BorderStyle borderStyle, IndexedColors borderColor, AxolotlColor foregroundColor, Font font) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setBorderTop(borderStyle);
        cellStyle.setBorderRight(borderStyle);
        cellStyle.setBorderBottom(borderStyle);
        cellStyle.setBorderLeft(borderStyle);
        cellStyle.setTopBorderColor(borderColor.getIndex());
        cellStyle.setRightBorderColor(borderColor.getIndex());
        cellStyle.setBottomBorderColor(borderColor.getIndex());
        cellStyle.setLeftBorderColor(borderColor.getIndex());
        if (font != null) {
            cellStyle.setFont(font);
        }
        cellStyle.setFillForegroundColor((Color)foregroundColor.toXSSFColor());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    public static CellStyle createCellStyle(Workbook workbook, BorderStyle borderStyle, IndexedColors borderColor, AxolotlColor foregroundColor) {
        return StyleHelper.createCellStyle(workbook, borderStyle, borderColor, foregroundColor, null);
    }

    public static CellStyle createStandardCellStyle(Workbook workbook, BorderStyle borderStyle, IndexedColors borderColor, AxolotlColor foregroundColor, Font font) {
        CellStyle cellStyle = StyleHelper.createCellStyle(workbook, borderStyle, borderColor, foregroundColor, font);
        cellStyle.setWrapText(true);
        StyleHelper.setCellStyleAlignmentCenter(cellStyle);
        return cellStyle;
    }

    public static void setCellAsPlainText(CellStyle cellStyle) {
        cellStyle.setDataFormat((short)49);
    }

    static {
        PRESET_CELL_LENGTH_MAP.put("\u59d3\u540d", 3500);
        PRESET_CELL_LENGTH_MAP.put("\u540d\u79f0", 5000);
        PRESET_CELL_LENGTH_MAP.put("\u8eab\u4efd\u8bc1", SERIAL_NUMBER_LENGTH);
        PRESET_CELL_LENGTH_MAP.put("\u8eab\u4efd\u8bc1\u53f7", SERIAL_NUMBER_LENGTH);
        PRESET_CELL_LENGTH_MAP.put("\u8eab\u4efd\u8bc1\u53f7\u7801", SERIAL_NUMBER_LENGTH);
        PRESET_CELL_LENGTH_MAP.put("\u6027\u522b", 2000);
        PRESET_CELL_LENGTH_MAP.put("\u5730\u5740", 12800);
        PRESET_CELL_LENGTH_MAP.put("\u7b80\u79f0", 8000);
        PRESET_CELL_LENGTH_MAP.put("\u4ee3\u7801", 4000);
    }
}

