/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.support;

import cn.toutatis.xvoid.axolotl.excel.writer.support.ExcelWritePolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class CommonWriteConfig {
    private int sheetIndex = 0;
    private Map<ExcelWritePolicy, Object> writePolicies = new HashMap<ExcelWritePolicy, Object>();
    private OutputStream outputStream;

    public CommonWriteConfig() {
        this(true);
    }

    public CommonWriteConfig(boolean withDefaultConfig) {
        if (withDefaultConfig) {
            HashMap<ExcelWritePolicy, Object> defaultReadPolicies = new HashMap<ExcelWritePolicy, Object>();
            for (ExcelWritePolicy policy : ExcelWritePolicy.values()) {
                if (!policy.isDefaultPolicy()) continue;
                defaultReadPolicies.put(policy, policy.getValue());
            }
            this.writePolicies.putAll(defaultReadPolicies);
        }
    }

    public void setWritePolicy(ExcelWritePolicy policy, boolean value) {
        if (policy.getType() != ExcelWritePolicy.Type.BOOLEAN) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u7279\u6027\u4e0d\u662f\u4e00\u4e2a\u5e03\u5c14\u7c7b\u578b");
        }
        this.writePolicies.put(policy, value);
    }

    public boolean getWritePolicyAsBoolean(ExcelWritePolicy policy) {
        if (policy.getType() != ExcelWritePolicy.Type.BOOLEAN) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u7279\u6027\u4e0d\u662f\u4e00\u4e2a\u5e03\u5c14\u7c7b\u578b");
        }
        return this.writePolicies.containsKey((Object)policy) && (Boolean)this.writePolicies.get((Object)policy) != false;
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public Map<ExcelWritePolicy, Object> getWritePolicies() {
        return this.writePolicies;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public void setWritePolicies(Map<ExcelWritePolicy, Object> writePolicies) {
        this.writePolicies = writePolicies;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonWriteConfig)) {
            return false;
        }
        CommonWriteConfig other = (CommonWriteConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSheetIndex() != other.getSheetIndex()) {
            return false;
        }
        Map<ExcelWritePolicy, Object> this$writePolicies = this.getWritePolicies();
        Map<ExcelWritePolicy, Object> other$writePolicies = other.getWritePolicies();
        if (this$writePolicies == null ? other$writePolicies != null : !((Object)this$writePolicies).equals(other$writePolicies)) {
            return false;
        }
        OutputStream this$outputStream = this.getOutputStream();
        OutputStream other$outputStream = other.getOutputStream();
        return !(this$outputStream == null ? other$outputStream != null : !this$outputStream.equals(other$outputStream));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonWriteConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSheetIndex();
        Map<ExcelWritePolicy, Object> $writePolicies = this.getWritePolicies();
        result = result * 59 + ($writePolicies == null ? 43 : ((Object)$writePolicies).hashCode());
        OutputStream $outputStream = this.getOutputStream();
        result = result * 59 + ($outputStream == null ? 43 : $outputStream.hashCode());
        return result;
    }

    public String toString() {
        return "CommonWriteConfig(sheetIndex=" + this.getSheetIndex() + ", writePolicies=" + this.getWritePolicies() + ", outputStream=" + this.getOutputStream() + ")";
    }
}

