/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.support.inverters;

import cn.toutatis.xvoid.axolotl.excel.writer.support.DataInverter;
import cn.toutatis.xvoid.toolkit.constant.Time;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Date;

public class DefaultDataInverter
implements DataInverter<Object> {
    @Override
    public Object convert(Object value) {
        if (value != null) {
            Class<?> valueClass = value.getClass();
            if (valueClass == Double.class || valueClass == Float.class) {
                return String.format("%.2f", value);
            }
            if (valueClass == BigDecimal.class) {
                boolean isInteger;
                BigDecimal decimal = (BigDecimal)value;
                boolean bl = isInteger = decimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
                if (isInteger) {
                    return decimal.toBigInteger().toString();
                }
                decimal = decimal.setScale(2, RoundingMode.HALF_UP);
                return decimal.toString();
            }
            if (valueClass == LocalDateTime.class) {
                return Time.regexTime((String)"yyyy-MM-dd", (LocalDateTime)((LocalDateTime)value));
            }
            if (valueClass == Date.class) {
                return Time.regexTime((String)"yyyy-MM-dd", (Date)((Date)value));
            }
            return value;
        }
        return null;
    }
}

