/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.themes;

import cn.toutatis.xvoid.axolotl.excel.writer.components.AxolotlColor;
import cn.toutatis.xvoid.axolotl.excel.writer.style.AbstractStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.StyleHelper;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;

public class AxolotlClassicalTheme
extends AbstractStyleRender
implements ExcelStyleRender {
    private static final Logger LOGGER = LoggerToolkit.getLogger(AxolotlClassicalTheme.class);
    private static final AxolotlColor THEME_COLOR_XSSF = new AxolotlColor(68, 114, 199);
    private static final String FONT_NAME = "Arial";
    private Font MAIN_TEXT_FONT;

    public AxolotlClassicalTheme() {
        super(LOGGER);
    }

    @Override
    public AxolotlWriteResult init(SXSSFSheet sheet) {
        if (this.isFirstBatch()) {
            this.checkedAndUseCustomTheme(FONT_NAME, THEME_COLOR_XSSF);
            this.MAIN_TEXT_FONT = this.createFont(FONT_NAME, (short)StyleHelper.STANDARD_TEXT_FONT_SIZE, false, IndexedColors.BLACK);
        }
        return super.init(sheet);
    }

    @Override
    public AxolotlWriteResult renderHeader(SXSSFSheet sheet) {
        int switchSheetIndex = this.context.getSwitchSheetIndex();
        AxolotlWriteResult isCreateTitleRow = this.createTitleRow(sheet);
        Font headerFont = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), FONT_NAME, true, StyleHelper.STANDARD_TEXT_FONT_SIZE, IndexedColors.WHITE);
        CellStyle headerDefaultCellStyle = StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), BorderStyle.MEDIUM, IndexedColors.WHITE, THEME_COLOR_XSSF, headerFont);
        AxolotlWriteResult headerWriteResult = this.defaultRenderHeaders(sheet, headerDefaultCellStyle);
        if (isCreateTitleRow.isWrite()) {
            Font titleFont = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), FONT_NAME, true, StyleHelper.STANDARD_TITLE_FONT_SIZE, IndexedColors.WHITE);
            CellStyle titleRowStyle = StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), BorderStyle.THICK, IndexedColors.WHITE, THEME_COLOR_XSSF, titleFont);
            this.mergeTitleRegion(sheet, this.context.getAlreadyWrittenColumns().get(switchSheetIndex), titleRowStyle);
        }
        sheet.createFreezePane(0, this.context.getAlreadyWriteRow().get(switchSheetIndex) + 1);
        return headerWriteResult;
    }

    @Override
    public AxolotlWriteResult renderData(SXSSFSheet sheet, List<?> data) {
        SXSSFWorkbook workbook = this.context.getWorkbook();
        BorderStyle borderStyle = BorderStyle.THIN;
        IndexedColors borderColor = IndexedColors.WHITE;
        CellStyle dataStyle = StyleHelper.createStandardCellStyle((Workbook)workbook, borderStyle, borderColor, new AxolotlColor(217, 226, 243), this.MAIN_TEXT_FONT);
        CellStyle dataStyleOdd = StyleHelper.createStandardCellStyle((Workbook)workbook, borderStyle, borderColor, new AxolotlColor(181, 197, 230), this.MAIN_TEXT_FONT);
        StyleHelper.setCellAsPlainText(dataStyle);
        StyleHelper.setCellAsPlainText(dataStyleOdd);
        Map columnMapping = this.context.getHeaderColumnIndexMapping().row((Object)this.context.getSwitchSheetIndex());
        if (!columnMapping.isEmpty()) {
            LoggerHelper.debug(LOGGER, "\u5df2\u6709\u5b57\u6bb5\u6620\u5c04\u8868,\u5c06\u6309\u7167\u5b57\u6bb5\u6620\u5c04\u6e32\u67d3\u6570\u636e[%s]", columnMapping);
        }
        int dataSize = data.size();
        for (int i = 0; i < dataSize; ++i) {
            CellStyle innerStyle = i % 2 == 0 ? dataStyle : dataStyleOdd;
            this.defaultRenderNextData(sheet, data.get(i), innerStyle);
        }
        AxolotlWriteResult axolotlWriteResult = new AxolotlWriteResult(true, "\u6e32\u67d3\u6570\u636e\u5b8c\u6210");
        return axolotlWriteResult;
    }

    @Override
    public AxolotlWriteResult finish(SXSSFSheet sheet) {
        return super.finish(sheet);
    }
}

