/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.themes;

import cn.toutatis.xvoid.axolotl.excel.writer.components.AxolotlColor;
import cn.toutatis.xvoid.axolotl.excel.writer.style.AbstractStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.StyleHelper;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.slf4j.Logger;

public class AxolotlHazeBlueTheme
extends AbstractStyleRender
implements ExcelStyleRender {
    private static final Logger LOGGER = LoggerToolkit.getLogger(AxolotlHazeBlueTheme.class);
    private static final AxolotlColor THEME_COLOR_XSSF = new AxolotlColor(130, 151, 176);
    private static final String FONT_NAME = "Arial";
    private Font MAIN_TEXT_FONT;

    public AxolotlHazeBlueTheme() {
        super(LOGGER);
    }

    @Override
    public AxolotlWriteResult init(SXSSFSheet sheet) {
        if (this.isFirstBatch()) {
            this.checkedAndUseCustomTheme(FONT_NAME, THEME_COLOR_XSSF);
            this.MAIN_TEXT_FONT = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), FONT_NAME, false, StyleHelper.STANDARD_TEXT_FONT_SIZE, IndexedColors.BLACK);
        }
        return super.init(sheet);
    }

    @Override
    public AxolotlWriteResult renderHeader(SXSSFSheet sheet) {
        int switchSheetIndex = this.context.getSwitchSheetIndex();
        AxolotlWriteResult isCreateTitleRow = this.createTitleRow(sheet);
        Font headerFont = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), FONT_NAME, true, StyleHelper.STANDARD_TEXT_FONT_SIZE, IndexedColors.WHITE);
        CellStyle headerDefaultCellStyle = StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), BorderStyle.THIN, IndexedColors.WHITE, THEME_COLOR_XSSF, headerFont);
        AxolotlWriteResult headerWriteResult = this.defaultRenderHeaders(sheet, headerDefaultCellStyle);
        if (isCreateTitleRow.isWrite()) {
            Font titleFont = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), FONT_NAME, true, StyleHelper.STANDARD_TITLE_FONT_SIZE, IndexedColors.WHITE);
            CellStyle titleRowStyle = StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), BorderStyle.THIN, IndexedColors.WHITE, THEME_COLOR_XSSF, titleFont);
            this.mergeTitleRegion(sheet, this.context.getAlreadyWrittenColumns().get(switchSheetIndex), titleRowStyle);
        }
        sheet.createFreezePane(0, this.context.getAlreadyWriteRow().get(switchSheetIndex) + 1);
        return headerWriteResult;
    }

    @Override
    public AxolotlWriteResult renderData(SXSSFSheet sheet, List<?> data) {
        BorderStyle borderStyle = BorderStyle.THIN;
        IndexedColors borderColor = IndexedColors.WHITE;
        CellStyle dataStyle = this.createStyle(borderStyle, borderColor, new AxolotlColor(255, 255, 253), this.MAIN_TEXT_FONT);
        StyleHelper.setCellAsPlainText(dataStyle);
        CellStyle dataStyleOdd = this.createStyle(borderStyle, borderColor, new AxolotlColor(213, 220, 229), this.MAIN_TEXT_FONT);
        StyleHelper.setCellAsPlainText(dataStyleOdd);
        Map columnMapping = this.context.getHeaderColumnIndexMapping().row((Object)this.context.getSwitchSheetIndex());
        if (!columnMapping.isEmpty()) {
            LoggerHelper.debug(LOGGER, "\u5df2\u6709\u5b57\u6bb5\u6620\u5c04\u8868,\u5c06\u6309\u7167\u5b57\u6bb5\u6620\u5c04\u6e32\u67d3\u6570\u636e[%s]", columnMapping);
        }
        int dataSize = data.size();
        for (int i = 0; i < dataSize; ++i) {
            CellStyle innerStyle = i % 2 == 0 ? dataStyle : dataStyleOdd;
            this.defaultRenderNextData(sheet, data.get(i), innerStyle);
        }
        return new AxolotlWriteResult(true, "\u6e32\u67d3\u6570\u636e\u5b8c\u6210");
    }

    @Override
    public AxolotlWriteResult finish(SXSSFSheet sheet) {
        return super.finish(sheet);
    }
}

