/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.themes;

import cn.toutatis.xvoid.axolotl.excel.writer.components.AxolotlColor;
import cn.toutatis.xvoid.axolotl.excel.writer.style.AbstractStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.StyleHelper;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.slf4j.Logger;

public class AxolotlIndustrialOrangeTheme
extends AbstractStyleRender
implements ExcelStyleRender {
    private static final Logger LOGGER = LoggerToolkit.getLogger(AxolotlIndustrialOrangeTheme.class);
    private static final AxolotlColor THEME_COLOR = AxolotlColor.create(247, 202, 142);
    private static final String FONT_NAME = "Calibri";

    public AxolotlIndustrialOrangeTheme() {
        super(LOGGER);
    }

    @Override
    public AxolotlWriteResult init(SXSSFSheet sheet) {
        if (this.isFirstBatch()) {
            this.checkedAndUseCustomTheme(FONT_NAME, THEME_COLOR);
        }
        return super.init(sheet);
    }

    @Override
    public AxolotlWriteResult renderHeader(SXSSFSheet sheet) {
        AxolotlWriteResult writeTitle = this.createTitleRow(sheet);
        Font font = this.createFont(this.getGlobalFontName(), (short)StyleHelper.STANDARD_TEXT_FONT_SIZE, true, IndexedColors.BLACK);
        CellStyle headerDefaultCellStyle = this.createStyle(BorderStyle.MEDIUM, IndexedColors.BLACK, THEME_COLOR, font);
        headerDefaultCellStyle.setWrapText(true);
        AxolotlWriteResult headerWriteResult = this.defaultRenderHeaders(sheet, headerDefaultCellStyle);
        if (writeTitle.isWrite()) {
            this.mergeTitleRegion(sheet, this.context.getAlreadyWrittenColumns().get(this.context.getSwitchSheetIndex()), headerDefaultCellStyle);
        }
        return headerWriteResult;
    }

    @Override
    public AxolotlWriteResult renderData(SXSSFSheet sheet, List<?> data) {
        CellStyle dataStyle = this.createBlackMainTextCellStyle(BorderStyle.THIN, IndexedColors.BLACK, StyleHelper.WHITE_COLOR);
        StyleHelper.setCellAsPlainText(dataStyle);
        Map columnMapping = this.context.getHeaderColumnIndexMapping().row((Object)this.context.getSwitchSheetIndex());
        if (!columnMapping.isEmpty()) {
            LoggerHelper.debug(LOGGER, "\u5df2\u6709\u5b57\u6bb5\u6620\u5c04\u8868,\u5c06\u6309\u7167\u5b57\u6bb5\u6620\u5c04\u6e32\u67d3\u6570\u636e[%s]", columnMapping);
        }
        for (Object datum : data) {
            this.defaultRenderNextData(sheet, datum, dataStyle);
        }
        return new AxolotlWriteResult(true, "\u6e32\u67d3\u6570\u636e\u5b8c\u6210");
    }

    @Override
    public AxolotlWriteResult finish(SXSSFSheet sheet) {
        return super.finish(sheet);
    }
}

