/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.excel.writer.themes;

import cn.toutatis.xvoid.axolotl.excel.writer.components.AxolotlColor;
import cn.toutatis.xvoid.axolotl.excel.writer.style.AbstractStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.ExcelStyleRender;
import cn.toutatis.xvoid.axolotl.excel.writer.style.StyleHelper;
import cn.toutatis.xvoid.axolotl.excel.writer.support.AxolotlWriteResult;
import cn.toutatis.xvoid.axolotl.toolkit.LoggerHelper;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;

public class SimpleBlackTheme
extends AbstractStyleRender
implements ExcelStyleRender {
    private static final Logger LOGGER = LoggerToolkit.getLogger(SimpleBlackTheme.class);
    private static final AxolotlColor THEME_COLOR_XSSF = new AxolotlColor(255, 255, 255);
    private static final String FONT_NAME = "\u5b8b\u4f53";
    private Font MAIN_TEXT_FONT;

    public SimpleBlackTheme() {
        super(LOGGER);
    }

    @Override
    public AxolotlWriteResult init(SXSSFSheet sheet) {
        if (this.isFirstBatch()) {
            this.checkedAndUseCustomTheme(FONT_NAME, THEME_COLOR_XSSF);
            this.MAIN_TEXT_FONT = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), FONT_NAME, false, StyleHelper.STANDARD_TEXT_FONT_SIZE, IndexedColors.BLACK);
        }
        return super.init(sheet);
    }

    @Override
    public AxolotlWriteResult renderHeader(SXSSFSheet sheet) {
        int switchSheetIndex = this.context.getSwitchSheetIndex();
        AxolotlWriteResult isCreateTitleRow = this.createTitleRow(sheet);
        Font headerFont = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), FONT_NAME, true, StyleHelper.STANDARD_TEXT_FONT_SIZE, IndexedColors.BLACK);
        CellStyle headerDefaultCellStyle = StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), BorderStyle.THIN, IndexedColors.BLACK, THEME_COLOR_XSSF, headerFont);
        AxolotlWriteResult headerWriteResult = this.defaultRenderHeaders(sheet, headerDefaultCellStyle);
        if (isCreateTitleRow.isWrite()) {
            Font titleFont = StyleHelper.createWorkBookFont((Workbook)this.context.getWorkbook(), FONT_NAME, true, StyleHelper.STANDARD_TITLE_FONT_SIZE, IndexedColors.BLACK);
            CellStyle titleRowStyle = StyleHelper.createStandardCellStyle((Workbook)this.context.getWorkbook(), BorderStyle.THIN, IndexedColors.BLACK, THEME_COLOR_XSSF, titleFont);
            this.mergeTitleRegion(sheet, this.context.getAlreadyWrittenColumns().get(switchSheetIndex), titleRowStyle);
        }
        sheet.createFreezePane(0, this.context.getAlreadyWriteRow().get(switchSheetIndex) + 1);
        return headerWriteResult;
    }

    @Override
    public AxolotlWriteResult renderData(SXSSFSheet sheet, List<?> data) {
        SXSSFWorkbook workbook = this.context.getWorkbook();
        BorderStyle borderStyle = BorderStyle.THIN;
        IndexedColors borderColor = IndexedColors.BLACK;
        CellStyle dataStyle = StyleHelper.createStandardCellStyle((Workbook)workbook, borderStyle, borderColor, THEME_COLOR_XSSF, this.MAIN_TEXT_FONT);
        StyleHelper.setCellAsPlainText(dataStyle);
        Map columnMapping = this.context.getHeaderColumnIndexMapping().row((Object)this.context.getSwitchSheetIndex());
        if (!columnMapping.isEmpty()) {
            LoggerHelper.debug(LOGGER, "\u5df2\u6709\u5b57\u6bb5\u6620\u5c04\u8868,\u5c06\u6309\u7167\u5b57\u6bb5\u6620\u5c04\u6e32\u67d3\u6570\u636e[%s]", columnMapping);
        }
        for (Object datum : data) {
            this.defaultRenderNextData(sheet, datum, dataStyle);
        }
        return new AxolotlWriteResult(true, "\u6e32\u67d3\u6570\u636e\u5b8c\u6210");
    }

    @Override
    public AxolotlWriteResult finish(SXSSFSheet sheet) {
        return super.finish(sheet);
    }
}

