/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.toolkit;

import cn.toutatis.xvoid.axolotl.excel.reader.ReaderConfig;
import cn.toutatis.xvoid.axolotl.excel.writer.components.Header;
import cn.toutatis.xvoid.axolotl.excel.writer.components.SheetHeader;
import cn.toutatis.xvoid.axolotl.exceptions.AxolotlException;
import cn.toutatis.xvoid.toolkit.clazz.ReflectToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;

public class ExcelToolkit {
    private static final Logger LOGGER = LoggerToolkit.getLogger((String)"Axolotl");

    public static String getHumanReadablePosition(int rowIndex, int columnIndex) {
        char i = (char)(65 + columnIndex);
        return String.format("%s", i + String.format("%d", rowIndex + 1));
    }

    public static boolean blankRowCheck(Row row, int rangeStart, int rangeEnd) {
        int lastCellNum;
        if (row == null) {
            return true;
        }
        int isAllBlank = 0;
        int n = lastCellNum = (int)(rangeEnd < 0 ? row.getLastCellNum() : (int)rangeEnd);
        if (rangeStart > lastCellNum) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u5217\u8d77\u59cb\u4f4d\u7f6e\u5fc5\u987b\u5927\u4e8e\u7ed3\u675f\u4f4d\u7f6e");
        }
        for (int i = rangeStart; i < lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() == CellType.BLANK) {
                ++isAllBlank;
                continue;
            }
            return false;
        }
        boolean blankRow = isAllBlank == lastCellNum;
        LoggerToolkitKt.debugWithModule((Logger)LOGGER, (String)"Axolotl", (String)String.format("\u884c[%s]\u6570\u636e\u4e3a\u7a7a", row.getRowNum()));
        return blankRow;
    }

    public static boolean blankRowCheck(Row row, ReaderConfig<?> readerConfig) {
        int[] sheetColumnEffectiveRange = readerConfig.getSheetColumnEffectiveRange();
        return ExcelToolkit.blankRowCheck(row, sheetColumnEffectiveRange[0], sheetColumnEffectiveRange[1]);
    }

    public static boolean notBlankRowCheck(Row row, int rangeStart, int rangeEnd) {
        return !ExcelToolkit.blankRowCheck(row, rangeStart, rangeEnd);
    }

    public static boolean notBlankRowCheck(Row row) {
        return !ExcelToolkit.blankRowCheck(row, 0, -1);
    }

    public static CellRangeAddress isCellMerged(Sheet sheet, int rowIndex, int colIndex) {
        int numMergedRegions = sheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress mergedRegion = sheet.getMergedRegion(i);
            if (rowIndex < mergedRegion.getFirstRow() || rowIndex > mergedRegion.getLastRow() || colIndex < mergedRegion.getFirstColumn() || colIndex > mergedRegion.getLastColumn()) continue;
            return mergedRegion;
        }
        return null;
    }

    public static void cloneOldWorkbook2NewWorkbook(Workbook newWorkbook, Workbook oldWorkBook) {
        if (oldWorkBook == null || newWorkbook == null) {
            return;
        }
        Iterator sheetIterator = oldWorkBook.sheetIterator();
        while (sheetIterator.hasNext()) {
            Sheet tmpSheet = (Sheet)sheetIterator.next();
            Sheet sxssfSheet = newWorkbook.createSheet(tmpSheet.getSheetName());
            ExcelToolkit.cloneOldSheet2NewSheet(sxssfSheet, tmpSheet);
        }
    }

    public static void cloneOldSheet2NewSheet(Sheet newSheet, Sheet oldSheet) {
        for (Row tmpRow : oldSheet) {
            if (tmpRow == null) continue;
            Row sxssfRow = newSheet.createRow(tmpRow.getRowNum());
            ExcelToolkit.cloneOldRow2NewRow(sxssfRow, tmpRow);
        }
    }

    public static void cloneOldRow2NewRow(Row newRow, Row oldRow) {
        Iterator cellIterator = oldRow.cellIterator();
        while (cellIterator.hasNext()) {
            Cell tmpCell = (Cell)cellIterator.next();
            if (tmpCell == null) continue;
            Cell newCell = newRow.createCell(tmpCell.getColumnIndex());
            ExcelToolkit.cloneOldCell2NewCell(newCell, tmpCell);
        }
    }

    public static void cloneOldCell2NewCell(Cell newCell, Cell oldCell) {
        if (oldCell == null || newCell == null) {
            return;
        }
        newCell.setCellStyle(oldCell.getCellStyle());
        switch (oldCell.getCellType()) {
            case BOOLEAN: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case STRING: {
                newCell.setCellValue(oldCell.getStringCellValue());
                break;
            }
            case FORMULA: {
                newCell.setCellValue(oldCell.getCellFormula());
                break;
            }
            case ERROR: {
                newCell.setCellValue((double)oldCell.getErrorCellValue());
                break;
            }
            case BLANK: {
                newCell.setBlank();
            }
        }
    }

    public static Row createOrCatchRow(Sheet sheet, int row) {
        Row writableRow = sheet.getRow(row);
        if (writableRow == null) {
            writableRow = sheet.createRow(row);
        }
        return writableRow;
    }

    public static Cell createOrCatchCell(Sheet sheet, int row, int column, CellStyle cellStyle) {
        Row writableRow = ExcelToolkit.createOrCatchRow(sheet, row);
        Cell writableCell = writableRow.getCell(column);
        if (writableCell == null) {
            writableCell = writableRow.createCell(column);
        }
        if (cellStyle != null) {
            writableCell.setCellStyle(cellStyle);
        }
        return writableCell;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cellAssignment(Sheet sheet, int row, int column, CellStyle cellStyle, Object value) {
        Cell writableCell = ExcelToolkit.createOrCatchCell(sheet, row, column, cellStyle);
        if (value != null) {
            Class<?> valueClass = value.getClass();
            if (ReflectToolkit.isWrapperClass(valueClass) && valueClass != String.class || valueClass.isPrimitive()) {
                writableCell.setCellValue(((Double)value).doubleValue());
            }
            if (value instanceof String) {
                writableCell.setCellValue((String)value);
                return;
            } else if (value instanceof Boolean) {
                writableCell.setCellValue(((Boolean)value).booleanValue());
                return;
            } else if (value instanceof Date) {
                writableCell.setCellValue((Date)value);
                return;
            } else if (value instanceof LocalDateTime) {
                writableCell.setCellValue((LocalDateTime)value);
                return;
            } else if (value instanceof LocalDate) {
                writableCell.setCellValue((LocalDate)value);
                return;
            } else {
                if (!(value instanceof Calendar)) throw new AxolotlException("\u4e0d\u652f\u6301\u7684\u5199\u5165\u7c7b\u578b");
                writableCell.setCellValue((Calendar)value);
            }
            return;
        } else {
            writableCell.setBlank();
        }
    }

    public static int getMaxDepth(List<Header> headers, int depth) {
        int maxDepth = depth;
        for (Header header : headers) {
            int subDepth;
            if (header.getChilds() == null || (subDepth = ExcelToolkit.getMaxDepth(header.getChilds(), depth + 1)) <= maxDepth) continue;
            maxDepth = subDepth;
        }
        return maxDepth;
    }

    public static List<Header> getHeaderList(Class<?> clazz) {
        ArrayList<Header> headerList = new ArrayList<Header>();
        List list = ReflectToolkit.getAllFields(clazz, (boolean)true);
        for (Field field : list) {
            SheetHeader sheetHeader = field.getDeclaredAnnotation(SheetHeader.class);
            if (sheetHeader == null) continue;
            Header header = new Header(sheetHeader.name());
            header.setFieldName(field.getName());
            header.setColumnWidth(sheetHeader.width());
            headerList.add(header);
        }
        return headerList;
    }
}

