/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.axolotl.toolkit.tika;

import java.io.IOException;
import java.util.Objects;
import org.apache.tika.mime.MimeType;

public class DetectResult {
    private Boolean detect;
    private String message;
    private MimeType catchMimeType;
    private MimeType wantedMimeType;
    private FileStatus currentFileStatus;

    public DetectResult returnInfo(String msg) {
        this.message = msg;
        return this;
    }

    public DetectResult(boolean detect) {
        this.detect = detect;
        this.currentFileStatus = FileStatus.DETECTED;
    }

    public DetectResult(boolean detect, MimeType wantedMimeType) {
        this.detect = detect;
        this.currentFileStatus = FileStatus.DETECTED;
        this.setWantedMimeType(wantedMimeType);
        if (detect) {
            this.setCatchMimeType(wantedMimeType);
        }
    }

    public DetectResult(boolean detect, FileStatus currentFileStatus, String message) {
        this.detect = detect;
        this.currentFileStatus = currentFileStatus;
        this.message = message;
    }

    public boolean isFileSelfProblem() {
        return this.getDetect() == false && this.currentFileStatus == FileStatus.FILE_SELF_PROBLEM;
    }

    public boolean isFileMetaProblem() {
        return this.getDetect() == false && this.currentFileStatus == FileStatus.FILE_MIME_TYPE_PROBLEM;
    }

    public boolean isDetect() {
        if (Objects.isNull(this.detect)) {
            return this.isWantedMimeType();
        }
        return this.detect;
    }

    public boolean isWantedMimeType() {
        return this.wantedMimeType.equals((Object)this.catchMimeType);
    }

    public void throwException() {
        throw new IOException(this.message);
    }

    public Boolean getDetect() {
        return this.detect;
    }

    public String getMessage() {
        return this.message;
    }

    public MimeType getCatchMimeType() {
        return this.catchMimeType;
    }

    public MimeType getWantedMimeType() {
        return this.wantedMimeType;
    }

    public FileStatus getCurrentFileStatus() {
        return this.currentFileStatus;
    }

    public void setDetect(Boolean detect) {
        this.detect = detect;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCatchMimeType(MimeType catchMimeType) {
        this.catchMimeType = catchMimeType;
    }

    public void setWantedMimeType(MimeType wantedMimeType) {
        this.wantedMimeType = wantedMimeType;
    }

    public void setCurrentFileStatus(FileStatus currentFileStatus) {
        this.currentFileStatus = currentFileStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectResult)) {
            return false;
        }
        DetectResult other = (DetectResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$detect = this.getDetect();
        Boolean other$detect = other.getDetect();
        if (this$detect == null ? other$detect != null : !((Object)this$detect).equals(other$detect)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        MimeType this$catchMimeType = this.getCatchMimeType();
        MimeType other$catchMimeType = other.getCatchMimeType();
        if (this$catchMimeType == null ? other$catchMimeType != null : !this$catchMimeType.equals(other$catchMimeType)) {
            return false;
        }
        MimeType this$wantedMimeType = this.getWantedMimeType();
        MimeType other$wantedMimeType = other.getWantedMimeType();
        if (this$wantedMimeType == null ? other$wantedMimeType != null : !this$wantedMimeType.equals(other$wantedMimeType)) {
            return false;
        }
        FileStatus this$currentFileStatus = this.getCurrentFileStatus();
        FileStatus other$currentFileStatus = other.getCurrentFileStatus();
        return !(this$currentFileStatus == null ? other$currentFileStatus != null : !((Object)((Object)this$currentFileStatus)).equals((Object)other$currentFileStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DetectResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $detect = this.getDetect();
        result = result * 59 + ($detect == null ? 43 : ((Object)$detect).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        MimeType $catchMimeType = this.getCatchMimeType();
        result = result * 59 + ($catchMimeType == null ? 43 : $catchMimeType.hashCode());
        MimeType $wantedMimeType = this.getWantedMimeType();
        result = result * 59 + ($wantedMimeType == null ? 43 : $wantedMimeType.hashCode());
        FileStatus $currentFileStatus = this.getCurrentFileStatus();
        result = result * 59 + ($currentFileStatus == null ? 43 : ((Object)((Object)$currentFileStatus)).hashCode());
        return result;
    }

    public String toString() {
        return "DetectResult(detect=" + this.getDetect() + ", message=" + this.getMessage() + ", catchMimeType=" + this.getCatchMimeType() + ", wantedMimeType=" + this.getWantedMimeType() + ", currentFileStatus=" + this.getCurrentFileStatus() + ")";
    }

    public DetectResult(Boolean detect, String message, MimeType catchMimeType, MimeType wantedMimeType, FileStatus currentFileStatus) {
        this.detect = detect;
        this.message = message;
        this.catchMimeType = catchMimeType;
        this.wantedMimeType = wantedMimeType;
        this.currentFileStatus = currentFileStatus;
    }

    public static enum FileStatus {
        DETECTED(0, "\u6587\u4ef6\u6b63\u5e38"),
        FILE_SELF_PROBLEM(1, "\u6587\u4ef6\u81ea\u8eab\u95ee\u9898"),
        FILE_MIME_TYPE_PROBLEM(2, "\u6587\u4ef6\u5a92\u4f53\u7c7b\u578b\u95ee\u9898"),
        FILE_SUFFIX_PROBLEM(3, "\u6587\u4ef6\u540e\u7f00\u95ee\u9898");

        private final int idx;
        private final String msg;

        public int getIdx() {
            return this.idx;
        }

        public String getMsg() {
            return this.msg;
        }

        private FileStatus(int idx, String msg) {
            this.idx = idx;
            this.msg = msg;
        }
    }
}

