/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.formatting;

import cn.toutatis.xvoid.toolkit.validator.Validator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J(\u0010\t\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u000f"}, d2={"Lcn/toutatis/xvoid/toolkit/formatting/StringToolkit;", "", "()V", "concatString", "", "strArr", "", "separator", "([Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "lineWrap", "str", "length", "", "suffix", "appendTabCount", "void-toolkit"})
public final class StringToolkit {
    @NotNull
    public static final StringToolkit INSTANCE = new StringToolkit();

    private StringToolkit() {
    }

    @JvmStatic
    @Nullable
    public static final String concatString(@NotNull String[] strArr, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)strArr, (String)"strArr");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (strArr.length == 0) {
            return null;
        }
        if (strArr.length == 1) {
            return strArr[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = strArr.length;
        for (int i = 0; i < n; ++i) {
            String s = strArr[i];
            stringBuilder.append(s);
            if (i == ArraysKt.getLastIndex((Object[])strArr)) continue;
            stringBuilder.append(separator);
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String concatString$default(String[] stringArray, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return StringToolkit.concatString(stringArray, string);
    }

    @JvmStatic
    @NotNull
    public static final String lineWrap(@NotNull String str, int length) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringToolkit.lineWrap("", 0, str, length);
    }

    @JvmStatic
    @NotNull
    public static final String lineWrap(@NotNull String suffix, int appendTabCount, @NotNull String str, int length) {
        int t;
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (Validator.strIsBlank(str)) {
            return str;
        }
        if (str.length() < length) {
            return str;
        }
        String separator = System.getProperty("line.separator");
        int times = str.length() / length;
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < times; ++i) {
            if (i != 0) {
                stringBuilder.append(suffix);
            }
            if (i != 0 && appendTabCount > 0) {
                for (t = 0; t < appendTabCount; ++t) {
                    stringBuilder.append("\t");
                }
            }
            String string = str.substring(i * length, (i + 1) * length);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            stringBuilder.append(string).append(separator);
        }
        int endRange = times * length;
        stringBuilder.append(suffix);
        if (appendTabCount > 0) {
            for (t = 0; t < appendTabCount; ++t) {
                stringBuilder.append("\t");
            }
        }
        String string = str.substring(endRange, str.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        stringBuilder.append(string);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

