/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.clazz;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0005J\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcn/toutatis/xvoid/toolkit/clazz/ClassScanner;", "Lorg/springframework/context/ResourceLoaderAware;", "()V", "excludeFilters", "", "Lorg/springframework/core/type/filter/TypeFilter;", "includeFilters", "metadataReaderFactory", "Lorg/springframework/core/type/classreading/MetadataReaderFactory;", "resourcePatternResolver", "Lorg/springframework/core/io/support/ResourcePatternResolver;", "addExcludeFilter", "", "excludeFilter", "addIncludeFilter", "includeFilter", "doScan", "", "Ljava/lang/Class;", "basePackage", "", "matches", "", "metadataReader", "Lorg/springframework/core/type/classreading/MetadataReader;", "resetFilters", "useDefaultFilters", "setResourceLoader", "resourceLoader", "Lorg/springframework/core/io/ResourceLoader;", "Companion", "void-toolkit"})
public final class ClassScanner
implements ResourceLoaderAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TypeFilter> includeFilters = new LinkedList();
    @NotNull
    private final List<TypeFilter> excludeFilters = new LinkedList();
    @NotNull
    private ResourcePatternResolver resourcePatternResolver = (ResourcePatternResolver)new PathMatchingResourcePatternResolver();
    @NotNull
    private MetadataReaderFactory metadataReaderFactory = (MetadataReaderFactory)new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);

    public void setResourceLoader(@NotNull ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        ResourcePatternResolver resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        Intrinsics.checkNotNullExpressionValue((Object)resourcePatternResolver, (String)"getResourcePatternResolver(...)");
        this.resourcePatternResolver = resourcePatternResolver;
        this.metadataReaderFactory = (MetadataReaderFactory)new CachingMetadataReaderFactory(resourceLoader);
    }

    public final void addIncludeFilter(@NotNull TypeFilter includeFilter) {
        Intrinsics.checkNotNullParameter((Object)includeFilter, (String)"includeFilter");
        this.includeFilters.add(includeFilter);
    }

    public final void addExcludeFilter(@NotNull TypeFilter excludeFilter) {
        Intrinsics.checkNotNullParameter((Object)excludeFilter, (String)"excludeFilter");
        this.excludeFilters.add(0, excludeFilter);
    }

    public final void resetFilters(boolean useDefaultFilters) {
        this.includeFilters.clear();
        this.excludeFilters.clear();
    }

    @NotNull
    public final Set<Class<?>> doScan(@NotNull String basePackage) {
        Intrinsics.checkNotNullParameter((Object)basePackage, (String)"basePackage");
        Set classes = new HashSet();
        try {
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage)) + "/**/*.class";
            Resource[] resourceArray = this.resourcePatternResolver.getResources(packageSearchPath);
            Intrinsics.checkNotNullExpressionValue((Object)resourceArray, (String)"getResources(...)");
            for (Resource resource : resourceArray) {
                MetadataReader metadataReader;
                if (!resource.isReadable()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)this.metadataReaderFactory.getMetadataReader(resource), (String)"getMetadataReader(...)");
                if ((this.includeFilters.size() != 0 || this.excludeFilters.size() != 0) && !this.matches(metadataReader)) continue;
                try {
                    Class<?> clazz = Class.forName(metadataReader.getClassMetadata().getClassName());
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
        return classes;
    }

    private final boolean matches(MetadataReader metadataReader) throws IOException {
        for (TypeFilter tf : this.excludeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return false;
        }
        for (TypeFilter tf : this.includeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\"\u0010\t\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00050\u0007\"\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0005H\u0002\u00a2\u0006\u0002\u0010\u000bJA\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\b2\"\u0010\t\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00050\u0007\"\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcn/toutatis/xvoid/toolkit/clazz/ClassScanner$Companion;", "", "()V", "scan", "", "Ljava/lang/Class;", "basePackages", "", "", "annotations", "", "([Ljava/lang/String;[Ljava/lang/Class;)Ljava/util/Set;", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/util/Set;", "void-toolkit"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<Class<?>> scan(String[] basePackages, Class<? extends Annotation> ... annotations) {
            ClassScanner scanner = new ClassScanner();
            if (ArrayUtils.isNotEmpty((Object[])annotations)) {
                int n = annotations.length;
                for (int i = 0; i < n; ++i) {
                    Class<? extends Annotation> annotation = annotations[i];
                    scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
                }
            }
            Set classes = new HashSet();
            for (String s : basePackages) {
                classes.addAll((Collection)scanner.doScan(s));
            }
            return classes;
        }

        @NotNull
        public final Set<Class<?>> scan(@NotNull String basePackages, Class<? extends Annotation> ... annotations) {
            Intrinsics.checkNotNullParameter((Object)basePackages, (String)"basePackages");
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            String[] stringArray = StringUtils.tokenizeToStringArray((String)basePackages, (String)",; ");
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"tokenizeToStringArray(...)");
            return this.scan(stringArray, Arrays.copyOf(annotations, annotations.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

