/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.digest;

import cn.toutatis.xvoid.toolkit.locale.I18n;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.nio.charset.Charset;
import java.security.DigestException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0007J$\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcn/toutatis/xvoid/toolkit/digest/DigestToolkit;", "", "()V", "SHA256_WITH_RSA_ALGORITHM", "", "SHA256withRSASignature", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "aesUseCBCWithBase64", "key", "iv", "data", "", "aesUseECBWithBase64", "decodeBase64ToString", "decryptAESUseCBCWithBase64", "encryptedData", "encodeBase64ToString", "generateSalt", "sha256", "str", "salt", "roll", "", "signSHA256withRSA", "privateKey", "Ljava/security/PrivateKey;", "verifySHA256withRSA", "", "publicKey", "Ljava/security/PublicKey;", "signature", "void-toolkit"})
public final class DigestToolkit {
    @NotNull
    public static final DigestToolkit INSTANCE = new DigestToolkit();
    @NotNull
    public static final String SHA256_WITH_RSA_ALGORITHM = "SHA256withRSA";
    private static final Signature SHA256withRSASignature = Signature.getInstance("SHA256withRSA");

    private DigestToolkit() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] signSHA256withRSA(@NotNull String data, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        SHA256withRSASignature.initSign(privateKey);
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SHA256withRSASignature.update(byArray);
        byte[] byArray2 = SHA256withRSASignature.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"sign(...)");
        return byArray2;
    }

    @JvmStatic
    public static final boolean verifySHA256withRSA(@NotNull String data, @NotNull PublicKey publicKey, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        SHA256withRSASignature.initVerify(publicKey);
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SHA256withRSASignature.update(byArray);
        return SHA256withRSASignature.verify(signature);
    }

    @JvmStatic
    @NotNull
    public static final String aesUseECBWithBase64(@NotNull String key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
        Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"getInstance(...)");
        Cipher cipher2 = cipher;
        cipher2.init(1, secretKeySpec);
        byte[] byArray2 = cipher2.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"doFinal(...)");
        return DigestToolkit.encodeBase64ToString(byArray2);
    }

    @JvmStatic
    @NotNull
    public static final String aesUseCBCWithBase64(@NotNull String key, @NotNull String iv, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        String string2 = iv;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        IvParameterSpec ivSpec = new IvParameterSpec(byArray2);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)secretKeySpec, ivSpec);
        byte[] byArray3 = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"doFinal(...)");
        return DigestToolkit.encodeBase64ToString(byArray3);
    }

    @JvmStatic
    @NotNull
    public static final String decryptAESUseCBCWithBase64(@NotNull String key, @NotNull String iv, @NotNull String encryptedData) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        if (iv.length() != 16) {
            return I18n.translate("security.decrypt.failed");
        }
        String string2 = key;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        String string3 = iv;
        byte[] byArray2 = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        IvParameterSpec ivSpec = new IvParameterSpec(byArray2);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)secretKeySpec, ivSpec);
        try {
            byte[] decryptedBytes = cipher.doFinal(DigestToolkit.decodeBase64ToString(encryptedData));
            Intrinsics.checkNotNull((Object)decryptedBytes);
            byte[] byArray3 = decryptedBytes;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            Charset charset2 = charset;
            string = new String(byArray3, charset2);
        }
        catch (BadPaddingException e) {
            string = I18n.translate("security.decrypt.failed");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String encodeBase64ToString(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Base64.Encoder encoder = Base64.getEncoder();
        String string = encoder.encodeToString(data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decodeBase64ToString(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byArray = decoder.decode(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decodeBase64ToString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byArray = decoder.decode(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @JvmStatic
    @Nullable
    public static final String sha256(@NotNull String str, @Nullable String salt, int roll) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (Validator.strIsBlank(str)) {
            return null;
        }
        if (roll < 0 || roll > 11) {
            String[] stringArray = new String[]{"\u52a0\u5bc6\u6b21\u6570\u9519\u8bef"};
            throw new DigestException(I18n.translate("security.digest.failArgs", stringArray));
        }
        Object saltStr = str + salt;
        String string = saltStr;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        int n = roll + 1;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)DigestUtils.sha256((byte[])bytes), (String)"sha256(...)");
        }
        String string2 = Hex.encodeHexString((byte[])bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeHexString(...)");
        saltStr = string2;
        return saltStr;
    }

    @JvmStatic
    @Nullable
    public static final String sha256(@NotNull String str, @Nullable String salt) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return DigestToolkit.sha256(str, salt, 0);
    }

    @JvmStatic
    @Nullable
    public static final String sha256(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return DigestToolkit.sha256(str, null, 0);
    }

    @JvmStatic
    @NotNull
    public static final String generateSalt() {
        String string = RandomStringUtils.randomAlphanumeric((int)17, (int)29);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomAlphanumeric(...)");
        return string;
    }
}

