/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.file.image;

import cn.toutatis.xvoid.toolkit.file.FileToolkit;
import cn.toutatis.xvoid.toolkit.file.image.PictureQualityDistributionStrategy;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressConfig {
    private final Logger logger = LoggerFactory.getLogger(CompressConfig.class);
    private String configName;

    private CompressConfig() {
    }

    public CompressConfig(String configName) {
        this.configName = configName;
    }

    public CompressContent getConfig() {
        Object path = "compress-config.json";
        if (this.configName == null || ((String)path).equals(this.configName)) {
            return new CompressContent(FileToolkit.getThreadPath() + "/" + (String)path);
        }
        path = FileToolkit.getThreadPath() + "/" + this.configName;
        String fileContent = FileToolkit.getFileContent(new File((String)path));
        JSONObject payload = JSONObject.parseObject((String)fileContent);
        CompressContent compressContent = (CompressContent)payload.toJavaObject(CompressContent.class);
        if (Validator.strIsBlank(compressContent.getLastChooseDir())) {
            File desktopDir = FileSystemView.getFileSystemView().getHomeDirectory();
            String desktopPath = desktopDir.getAbsolutePath();
            compressContent.setLastChooseDir(desktopPath);
            compressContent.saveConfig();
        }
        return compressContent;
    }

    public class CompressContent {
        private String configPath;
        private String title = "XVOID-\u56fe\u7247\u538b\u7f29\u5de5\u5177";
        private Integer width = 600;
        private Integer height = 400;
        private Integer fileViewWidth = 0;
        private Boolean resizable = false;
        private Boolean differentRegular = true;
        private Boolean retainSourceFile = true;
        private String zipType = "0";
        private Integer zipTimes = 5;
        private String lastChooseDir = null;
        private String lastSaveDir = null;
        private String saveFileRenameType = "UUID";
        private PictureQualityDistributionStrategy pictureQualityDistributionStrategy = PictureQualityDistributionStrategy.AVERAGE;

        public CompressContent(String configPath) {
            this.configPath = configPath;
        }

        public PictureQualityDistributionStrategy getPictureQualityDistributionStrategy() {
            return this.pictureQualityDistributionStrategy;
        }

        public void setPictureQualityDistributionStrategy(PictureQualityDistributionStrategy pictureQualityDistributionStrategy) {
            this.pictureQualityDistributionStrategy = pictureQualityDistributionStrategy;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public Integer getFileViewWidth() {
            return this.fileViewWidth;
        }

        public void setFileViewWidth(Integer fileViewWidth) {
            this.fileViewWidth = fileViewWidth;
        }

        public Boolean getResizable() {
            return this.resizable;
        }

        public void setResizable(Boolean resizable) {
            this.resizable = resizable;
        }

        public Boolean getDifferentRegular() {
            return this.differentRegular;
        }

        public void setDifferentRegular(Boolean differentRegular) {
            this.differentRegular = differentRegular;
        }

        public Boolean getRetainSourceFile() {
            return this.retainSourceFile;
        }

        public void setRetainSourceFile(Boolean retainSourceFile) {
            this.retainSourceFile = retainSourceFile;
        }

        public String getZipType() {
            return this.zipType;
        }

        public void setZipType(String zipType) {
            this.zipType = zipType;
        }

        public Integer getZipTimes() {
            return this.zipTimes;
        }

        public void setZipTimes(Integer zipTimes) {
            this.zipTimes = zipTimes;
        }

        public String getLastChooseDir() {
            return this.lastChooseDir;
        }

        public void setLastChooseDir(String lastChooseDir) {
            this.lastChooseDir = lastChooseDir;
        }

        public String getLastSaveDir() {
            return this.lastSaveDir;
        }

        public void setLastSaveDir(String lastSaveDir) {
            this.lastSaveDir = lastSaveDir;
        }

        public String getSaveFileRenameType() {
            return this.saveFileRenameType;
        }

        public void setSaveFileRenameType(String saveFileRenameType) {
            this.saveFileRenameType = saveFileRenameType;
        }

        public void saveConfig() {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.configPath);
                IOUtils.write((String)JSON.toJSONString((Object)this, (boolean)true), (OutputStream)fileOutputStream, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

