/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.file.image;

import cn.toutatis.xvoid.toolkit.file.FileToolkit;
import cn.toutatis.xvoid.toolkit.file.image.CompressConfig;
import cn.toutatis.xvoid.toolkit.file.image.PictureQualityDistributionStrategy;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;

public class ImageCompressToolKit {
    private static final Logger logger = LoggerToolkit.getLogger(ImageCompressToolKit.class);

    public static void linearCompression(File origin, File dist, int maxWidth, int maxHeight, float quality) throws IOException {
        BufferedImage image = ImageIO.read(origin);
        String fileSuffix = FileToolkit.getFileSuffix(origin);
        if ("png".equalsIgnoreCase(fileSuffix)) {
            Iterator<ImageWriter> imageWriterIterator = ImageIO.getImageWritersByFormatName("png");
            ImageWriter writer = imageWriterIterator.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            writeParam.setCompressionMode(2);
            writeParam.setCompressionType("Deflate");
            writeParam.setCompressionQuality(0.1f);
            FileOutputStream fos = new FileOutputStream(dist);
            ImageOutputStream output = ImageIO.createImageOutputStream(fos);
            writer.setOutput(output);
            writer.write(null, new IIOImage(image, null, null), writeParam);
            output.close();
            fos.close();
        } else {
            Image resizedImage = null;
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            int newWidth = Math.max(imageWidth, maxWidth);
            if (imageWidth >= imageHeight) {
                resizedImage = image.getScaledInstance(newWidth, newWidth * imageHeight / imageWidth, 4);
            }
            int newHeight = Math.max(imageHeight, maxHeight);
            if (resizedImage == null && imageHeight >= imageWidth) {
                resizedImage = image.getScaledInstance(newHeight * imageWidth / imageHeight, newHeight, 4);
            }
            Image temp = new ImageIcon(resizedImage).getImage();
            BufferedImage bufferedImage = new BufferedImage(temp.getWidth(null), temp.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(new Color(0, 0, 0, 0));
            graphics2D.fillRect(0, 0, temp.getWidth(null), temp.getHeight(null));
            graphics2D.drawImage(temp, 0, 0, null);
            graphics2D.dispose();
            float softenFactor = 0.05f;
            float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 4.0f, softenFactor, 0.0f, softenFactor, 0.0f};
            Kernel kernel = new Kernel(3, 3, softenArray);
            ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
            bufferedImage = convolveOp.filter(bufferedImage, null);
            ImageIO.write((RenderedImage)bufferedImage, "", new File(""));
            ImageWriter writer = null;
            ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
            Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, "jpg");
            if (iter.hasNext()) {
                writer = iter.next();
            }
            if (writer == null) {
                logger.error("[%s-IMAGE]\u672a\u627e\u5230\u5408\u9002\u7684\u8f93\u5165\u5668[%s]".formatted("XVOID-TOOLKIT", fileSuffix));
                return;
            }
            IIOImage iioImage = new IIOImage(bufferedImage, null, null);
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(quality);
            ImageOutputStream outputStream = ImageIO.createImageOutputStream(dist);
            writer.setOutput(outputStream);
            writer.write(null, iioImage, param);
            outputStream.close();
        }
    }

    public static void thumbnail(File origin, File dist, double scale) throws IOException {
        Thumbnails.of((File[])new File[]{origin}).scale(scale).toFile(dist);
    }

    public static List<String> differentStandardThumbnail(List<File> fileList, CompressConfig.CompressContent config) throws IOException {
        List<File> distinctFileList = fileList.stream().distinct().filter(file -> file.exists() && file.isFile() && FileToolkit.isImg(FileToolkit.getFileSuffix(file.getName()))).collect(Collectors.toList());
        ArrayList<String> filenameList = new ArrayList<String>(distinctFileList.size());
        if (distinctFileList.size() > 0) {
            logger.info("[%s]\u5f85\u751f\u6210 ".formatted("XVOID-TOOLKIT") + distinctFileList.size() + " \u4e2a\u56fe\u50cf\u8d44\u6e90.");
            Integer zipTimes = config.getZipTimes();
            String lastSaveDir = config.getLastSaveDir();
            if (Validator.strNotBlank(lastSaveDir)) {
                File file2 = new File(lastSaveDir);
                if (!file2.exists()) {
                    file2.mkdir();
                }
                if (!file2.exists() || !file2.isDirectory()) {
                    String error = "[%s]\u4fdd\u5b58\u76ee\u5f55\u9519\u8bef.[\u76ee\u6807\u5730\u5740\u4e0d\u662f\u76ee\u5f55\u00d7]".formatted("XVOID-TOOLKIT");
                    logger.error(error);
                    throw new FileNotFoundException(error);
                }
            } else {
                logger.info("[%s]\u4fdd\u5b58\u76ee\u5f55\u9519\u8bef.[\u7a7a\u6587\u4ef6\u5939\u00d7]".formatted("XVOID-TOOLKIT"));
                throw new FileNotFoundException("");
            }
            logger.info("[%s]\u76ee\u6807\u5730\u5740\u6821\u9a8c\u6210\u529f.[\u221a]".formatted("XVOID-TOOLKIT"));
            AtomicInteger count = new AtomicInteger();
            distinctFileList.forEach(item -> {
                String suffix = FileToolkit.getFileSuffix(item);
                String nameType = config.getSaveFileRenameType();
                Object fileName = "UNKNOWN-" + item.hashCode();
                int point = item.getName().lastIndexOf(".");
                if ("UUID".equals(nameType)) {
                    fileName = UUID.randomUUID().toString().replace("-", "");
                } else if ("SOURCE".equals(nameType)) {
                    fileName = item.getName().substring(0, point);
                }
                if (config.getDifferentRegular().booleanValue()) {
                    ArrayList<Double> qualityList = new ArrayList<Double>(zipTimes);
                    if (config.getPictureQualityDistributionStrategy() == PictureQualityDistributionStrategy.EXTREME) {
                        double qualityFactor = 0.75;
                        double qualityPeak = 8.0;
                        double base = 0.0;
                        for (double x = (double)zipTimes.intValue(); x > 0.0; x -= 1.0) {
                            double currentZipQuality = (qualityFactor * Math.pow(x - qualityPeak, 2.0) + base) / 100.0;
                            qualityList.add(currentZipQuality);
                        }
                    } else {
                        double avg = 0.8 / (double)zipTimes.intValue();
                        for (int i = 1; i <= zipTimes; ++i) {
                            double currentZipQuality = (double)i * avg;
                            qualityList.add(currentZipQuality);
                        }
                    }
                    boolean isPng = "png".equalsIgnoreCase(suffix);
                    block19: for (int i = 1; i <= qualityList.size(); ++i) {
                        Double currentQuality = (Double)qualityList.get(i - 1);
                        switch (config.getZipType()) {
                            case "1": {
                                File quality = ImageCompressToolKit.concatFileName(lastSaveDir, (String)fileName, "Q", i, suffix);
                                logger.info("\u6b63\u5728\u538b\u7f29" + item.getName() + "[Q" + i + "]");
                                try {
                                    if (isPng) {
                                        ImageCompressToolKit.linearCompression(item, quality, 0, 0, Float.parseFloat(String.valueOf(currentQuality)));
                                        break;
                                    }
                                    ImageCompressToolKit.linearCompression(item, quality, 0, 0, Float.parseFloat(String.valueOf(currentQuality)));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            case "2": {
                                File ratio = ImageCompressToolKit.concatFileName(lastSaveDir, (String)fileName, "R", i, suffix);
                                logger.info("\u6b63\u5728\u538b\u7f29" + item.getName() + "[R" + i + "]");
                                try {
                                    ImageCompressToolKit.thumbnail(item, ratio, currentQuality);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            default: {
                                try {
                                    File all_ratio = ImageCompressToolKit.concatFileName(lastSaveDir, (String)fileName, "R", i, suffix);
                                    ImageCompressToolKit.thumbnail(item, all_ratio, currentQuality);
                                    logger.info("\u6b63\u5728\u538b\u7f29" + item.getName() + "[R" + i + "]");
                                    File all_quality = ImageCompressToolKit.concatFileName(lastSaveDir, (String)fileName, "Q", i, suffix);
                                    if (isPng) {
                                        if (i != 1) continue block19;
                                        ImageCompressToolKit.linearCompression(item, all_quality, 0, 0, Float.parseFloat(String.valueOf(currentQuality)));
                                    } else {
                                        ImageCompressToolKit.linearCompression(item, all_quality, 0, 0, Float.parseFloat(String.valueOf(currentQuality)));
                                    }
                                    logger.info("\u6b63\u5728\u538b\u7f29" + item.getName() + "[Q" + i + "]");
                                    break;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        count.getAndIncrement();
                    }
                } else {
                    try {
                        ImageCompressToolKit.thumbnail(item, ImageCompressToolKit.concatFileName(lastSaveDir, (String)fileName, "0", 0, suffix), 0.5);
                        ImageCompressToolKit.linearCompression(item, ImageCompressToolKit.concatFileName(lastSaveDir, (String)fileName, "0", 0, suffix), 0, 0, 0.5f);
                        logger.info("\u6b63\u5728\u538b\u7f29" + item.getName() + "[0]");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!config.getRetainSourceFile().booleanValue()) {
                    item.delete();
                }
            });
            logger.info("\u538b\u7f29\u5df2\u5b8c\u6210. [" + count.get() + "]");
        } else {
            logger.info("\u53ef\u6267\u884c\u56fe\u7247\u6570\u91cf\u4e3a0.[\u00d7]");
        }
        return filenameList;
    }

    private static File concatFileName(String dir, String fileName, String middle, int currentTimes, String suffix) {
        StringBuilder builder = new StringBuilder(dir);
        builder.append("\\");
        builder.append(fileName);
        builder.append("_").append(middle).append("_");
        builder.append(currentTimes);
        builder.append(".");
        builder.append(suffix);
        return new File(builder.toString());
    }
}

