/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.formatting;

import cn.toutatis.xvoid.toolkit.file.FileToolkit;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f`\u0010H\u0007J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0007J3\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0001H\u0007J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\bH\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcn/toutatis/xvoid/toolkit/formatting/JsonToolkit;", "", "()V", "DEFAULT_MAX_RECORD", "", "alreadySetMaxRecord", "", "callRecordNumMethodClassName", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "maxRecord", "recordJsonHash", "Ljava/util/HashMap;", "Lcom/alibaba/fastjson/JSONObject;", "Lkotlin/collections/HashMap;", "getBoolean", "obj", "key", "(Lcom/alibaba/fastjson/JSONObject;Ljava/lang/String;)Ljava/lang/Boolean;", "getInnerMap", "getInteger", "(Lcom/alibaba/fastjson/JSONObject;Ljava/lang/String;)Ljava/lang/Integer;", "getString", "getValue", "T", "type", "Ljava/lang/Class;", "(Lcom/alibaba/fastjson/JSONObject;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "parseJsonObject", "file", "Ljava/io/File;", "jsonString", "setMaxRecordNum", "", "num", "void-toolkit"})
public final class JsonToolkit {
    @NotNull
    public static final JsonToolkit INSTANCE = new JsonToolkit();
    public static final int DEFAULT_MAX_RECORD = 1024;
    @NotNull
    private static HashMap<String, JSONObject> recordJsonHash = new HashMap(128);
    private static final Logger logger = LoggerFactory.getLogger(JsonToolkit.class);
    private static int maxRecord = 1024;
    private static boolean alreadySetMaxRecord;
    @NotNull
    private static String callRecordNumMethodClassName;

    private JsonToolkit() {
    }

    @JvmStatic
    @NotNull
    public static final JSONObject parseJsonObject(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JSONObject jSONObject = JSON.parseObject((String)FileToolkit.getFileContent(file));
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"parseObject(...)");
        return jSONObject;
    }

    @JvmStatic
    @NotNull
    public static final JSONObject parseJsonObject(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        JSONObject jSONObject = JSON.parseObject((String)jsonString);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"parseObject(...)");
        return jSONObject;
    }

    @JvmStatic
    @NotNull
    public static final JSONObject parseJsonObject(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        JSONObject jSONObject = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"parseObject(...)");
        return jSONObject;
    }

    @JvmStatic
    @Nullable
    public static final <T> T getValue(@NotNull JSONObject obj, @NotNull String key, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (obj.isEmpty()) {
            return null;
        }
        if (StringsKt.indexOf$default((CharSequence)key, (String)".", (int)0, (boolean)false, (int)6, null) == -1) {
            logger.warn("Please use the getValue method of the native FastJson.JSONObject,this method is used to get value separated by a delimiter[.]");
            return (T)obj.getObject(key, type);
        }
        int n = obj.hashCode();
        String string = key.substring(0, StringsKt.lastIndexOf$default((CharSequence)key, (String)".", (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String keySuffix = n + "-" + string;
        if (recordJsonHash.containsKey(keySuffix)) {
            String string2 = key.substring(StringsKt.lastIndexOf$default((CharSequence)key, (String)".", (int)0, (boolean)false, (int)6, null) + 1, key.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String footKey = string2;
            return (T)((JSONObject)MapsKt.getValue((Map)recordJsonHash, (Object)keySuffix)).getObject(footKey, type);
        }
        String[] stringArray = new String[]{"."};
        List split = StringsKt.split$default((CharSequence)key, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        JSONObject tmpJSONObject = null;
        int index = split.size() - 1;
        for (int i = 0; i < index; ++i) {
            JSONObject jSONObject;
            String ks = (String)split.get(i);
            if (i == 0) {
                jSONObject = obj.getJSONObject(ks);
                if (jSONObject == null) {
                    throw new NoSuchElementException("Please check object has this key [ " + ks + " ]. ");
                }
            } else {
                JSONObject jsonObject;
                JSONObject jSONObject2 = tmpJSONObject;
                Intrinsics.checkNotNull(jSONObject2);
                if (jSONObject2.getJSONObject(ks) == null) {
                    throw new NoSuchElementException("Please check object has this key [ " + ks + " ]. ");
                }
                if (i == index - 1) {
                    ((Map)recordJsonHash).put(keySuffix, jsonObject);
                }
                jSONObject = jsonObject;
            }
            tmpJSONObject = jSONObject;
        }
        if (recordJsonHash.size() > maxRecord) {
            recordJsonHash.clear();
        }
        JSONObject jSONObject = tmpJSONObject;
        Intrinsics.checkNotNull(jSONObject);
        return (T)jSONObject.getObject((String)split.get(CollectionsKt.getLastIndex((List)split)), type);
    }

    @JvmStatic
    @NotNull
    public static final HashMap<String, JSONObject> getInnerMap() {
        return recordJsonHash;
    }

    @JvmStatic
    @Nullable
    public static final String getString(@NotNull JSONObject obj, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return JsonToolkit.getValue(obj, key, String.class);
    }

    @JvmStatic
    @Nullable
    public static final Integer getInteger(@NotNull JSONObject obj, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return JsonToolkit.getValue(obj, key, Integer.TYPE);
    }

    @JvmStatic
    @Nullable
    public static final Boolean getBoolean(@NotNull JSONObject obj, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return JsonToolkit.getValue(obj, key, Boolean.TYPE);
    }

    @JvmStatic
    public static final void setMaxRecordNum(int num) {
        if (!alreadySetMaxRecord) {
            String string = Thread.currentThread().getStackTrace()[2].getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            callRecordNumMethodClassName = string;
            if (num <= 0) {
                logger.warn("You should set a non-zero number to make large iterators more efficient.");
            } else if (num % 2 != 0) {
                logger.warn("You should set this value to the NTH power of 2 for maximum efficiency.");
            }
            alreadySetMaxRecord = true;
            maxRecord = num;
        } else {
            logger.warn("This method can only be called once and cannot be modified.");
            logger.warn("Caller:" + callRecordNumMethodClassName);
        }
    }

    static {
        callRecordNumMethodClassName = "";
    }
}

