/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.locale;

import cn.toutatis.xvoid.toolkit.file.FileToolkit;
import cn.toutatis.xvoid.toolkit.formatting.JsonToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J-\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\u0010\"\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcn/toutatis/xvoid/toolkit/locale/I18n;", "", "()V", "locale", "Ljava/util/Locale;", "logger", "Lorg/slf4j/Logger;", "translationObject", "Lcom/alibaba/fastjson/JSONObject;", "loadLanguageLib", "", "setLocale", "translate", "", "key", "args", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "void-toolkit"})
public final class I18n {
    @NotNull
    public static final I18n INSTANCE = new I18n();
    @NotNull
    private static final Logger logger = LoggerToolkit.getLogger(INSTANCE.getClass());
    private static Locale locale;
    private static JSONObject translationObject;

    private I18n() {
    }

    @JvmStatic
    public static final void setLocale(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        I18n.locale = locale;
        INSTANCE.loadLanguageLib(locale);
    }

    @JvmStatic
    @NotNull
    public static final String translate(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String[] stringArray = new String[]{null};
        return I18n.translate(key, stringArray);
    }

    @JvmStatic
    @NotNull
    public static final String translate(@NotNull String key, String ... args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (Validator.strIsBlank(key)) {
            return "";
        }
        JSONObject jSONObject = translationObject;
        if (jSONObject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"translationObject");
            jSONObject = null;
        }
        String string2 = ((Object)StringsKt.trim((CharSequence)key)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String transStr = JsonToolkit.getString(jSONObject, string2);
        if (transStr != null) {
            if (args.length == 0) {
                return transStr;
            }
            String string3 = transStr;
            Object[] objectArray = new Object[]{args};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        } else {
            string = "";
        }
        return string;
    }

    private final void loadLanguageLib(Locale locale) {
        JSONObject parseJsonObject;
        String path;
        String country = "";
        String string = locale.getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCountry(...)");
        if (((CharSequence)string).length() == 0) {
            String string2 = locale.getLanguage();
            if (Intrinsics.areEqual((Object)string2, (Object)"zh")) {
                country = "CN";
            } else if (Intrinsics.areEqual((Object)string2, (Object)"en")) {
                country = "US";
            }
        } else {
            String string3 = locale.getCountry();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCountry(...)");
            country = string3;
        }
        String filename = "i18n/locale_" + locale.getLanguage() + "_" + country + ".json";
        URL uRL = FileToolkit.getResourceFile(filename);
        String string4 = path = uRL != null ? uRL.getPath() : null;
        if (Validator.strIsBlank(path)) {
            LoggerToolkitKt.warnWithModule(logger, "XVOID-TOOLKIT", "Locale translation file not found [" + filename + "].[SIMPLIFIED_CHINESE] will be used by default locale.");
            Locale locale2 = Locale.SIMPLIFIED_CHINESE;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"SIMPLIFIED_CHINESE");
            I18n.locale = locale2;
            this.loadLanguageLib(locale);
            return;
        }
        String string5 = path;
        Intrinsics.checkNotNull((Object)string5);
        translationObject = parseJsonObject = JsonToolkit.parseJsonObject(new File(string5));
    }

    static {
        Locale locale = Locale.SIMPLIFIED_CHINESE;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"SIMPLIFIED_CHINESE");
        I18n.setLocale(locale);
    }
}

