/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.data;

import cn.hutool.core.util.ReflectUtil;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;

public class DesensitizationToolkit {
    public static <P> List<P> hiddenInfo(List<P> list, String ... fields) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        if (fields.length == 0) {
            return list;
        }
        ArrayList<Map<String, Object>> pl = new ArrayList<Map<String, Object>>(list.size());
        for (P p : list) {
            if (p instanceof Map) {
                Map<String, Object> hm = DesensitizationToolkit.hiddenInfo((Map)p, fields);
                pl.add(hm);
                continue;
            }
            Map fieldMap = ReflectUtil.getFieldMap(p.getClass());
            for (String field : fields) {
                if (!fieldMap.containsKey(field)) continue;
                Field objField = (Field)fieldMap.get(field);
                objField.setAccessible(true);
                try {
                    objField.set(p, DesensitizationToolkit.hiddenInfo(objField.get(p).toString()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            pl.add((Map<String, Object>)p);
        }
        return pl;
    }

    public static Map<String, Object> hiddenInfo(Map<String, Object> map, String ... fields) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        if (fields.length == 0) {
            return map;
        }
        for (String field : fields) {
            if (map.containsKey(field)) {
                Class<?> fieldClass = map.get(field).getClass();
                boolean primitiveOrWrapper = ClassUtils.isPrimitiveOrWrapper(fieldClass);
                if (!primitiveOrWrapper) {
                    throw new IllegalArgumentException(LoggerToolkit.infoWithModule("XVOID-TOOLKIT", "\u8131\u654f\u5b57\u6bb5\u9700\u8981\u57fa\u7840\u7c7b\u578b\u6216\u57fa\u7840\u5305\u88c5\u7c7b"));
                }
            } else {
                throw new IllegalArgumentException(LoggerToolkit.infoWithModule("XVOID-TOOLKIT", "\u8131\u654fmap\u4e0d\u5b58\u5728[%s]\u5b57\u6bb5".formatted(field)));
            }
            String hiddenInfo = DesensitizationToolkit.hiddenInfo(String.valueOf(map.get(field)));
            map.put(field, hiddenInfo);
        }
        return map;
    }

    public static String hiddenInfo(String info) {
        return DesensitizationToolkit.hiddenInfo(info, "*");
    }

    public static String hiddenInfo(String info, String customSymbol) {
        if (Validator.strIsBlank(info)) {
            return null;
        }
        if (customSymbol == null || customSymbol.length() > 1) {
            throw new IllegalArgumentException(LoggerToolkit.infoWithModule("XVOID-TOOLKIT", "\u8131\u654f\u6807\u8bc6\u7b26\u4e0d\u5f97\u4e3a\u7a7a\u6216\u8005\u5927\u4e8e1\u4e2a\u5b57\u7b26"));
        }
        String trimInfo = info.trim();
        int infoLength = trimInfo.length();
        if (infoLength == 0) {
            return trimInfo;
        }
        if (infoLength == 1) {
            return customSymbol;
        }
        if (infoLength == 2) {
            return trimInfo.charAt(0) + customSymbol;
        }
        if (infoLength == 3) {
            return trimInfo.charAt(0) + customSymbol + trimInfo.charAt(2);
        }
        boolean isEvenLengthStr = infoLength % 2 == 0;
        int hiddenLength = infoLength / 3;
        StringBuilder sb = new StringBuilder();
        int startLength = infoLength - 2 * hiddenLength;
        if (!isEvenLengthStr) {
            --startLength;
        }
        for (int i = 0; i < startLength; ++i) {
            sb.append(customSymbol);
        }
        return trimInfo.substring(0, hiddenLength) + sb.toString() + trimInfo.substring(infoLength - hiddenLength + (isEvenLengthStr ? 0 : -1), infoLength);
    }
}

