/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.validator;

import cn.toutatis.xvoid.toolkit.constant.Regex;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007J;\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0015\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u0016J5\u0010\u0017\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0015\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u0018J5\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0015\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\bH\u0007J\u0012\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\"\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0007J!\u0010#\u001a\u00020\u000e2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010%J\u0012\u0010&\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\bH\u0007J\u0012\u0010)\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0007J!\u0010*\u001a\u00020\u000e2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0015\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010+J!\u0010,\u001a\u00020\u000e2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0015\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010+J\u0012\u0010-\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010\bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcn/toutatis/xvoid/toolkit/validator/Validator;", "", "()V", "CN_USERNAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "EN_USERNAME_PATTERN", "SUB_MODULE_NAME", "", "USEFUL_PASSWORD_PATTERN", "logger", "Lorg/slf4j/Logger;", "numPattern", "checkCNUsernameFormat", "", "username", "checkMapContainsKey", "", "map", "", "keys", "", "(Ljava/util/Map;[Ljava/lang/String;)Ljava/util/List;", "checkMapContainsKeyBoolean", "(Ljava/util/Map;[Ljava/lang/String;)Z", "checkMapContainsKeyThrowEx", "", "(Ljava/util/Map;[Ljava/lang/String;)V", "checkUsefulPasswordFormat", "password", "objFieldNotNull", "obj", "objIsNull", "o", "objNotNull", "parametersHaveNull", "params", "([Ljava/lang/Object;)Z", "strIsBlank", "strIsNumber", "str", "strNotBlank", "stringsHasNull", "([Ljava/lang/String;)Z", "stringsNotNull", "validateRegex", "regex", "void-toolkit"})
@SourceDebugExtension(value={"SMAP\nValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Validator.kt\ncn/toutatis/xvoid/toolkit/validator/Validator\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,221:1\n107#2:222\n79#2,22:223\n*S KotlinDebug\n*F\n+ 1 Validator.kt\ncn/toutatis/xvoid/toolkit/validator/Validator\n*L\n52#1:222\n52#1:223,22\n*E\n"})
public final class Validator {
    @NotNull
    public static final Validator INSTANCE = new Validator();
    @NotNull
    private static final Logger logger = LoggerToolkit.getLogger(Validator.class);
    private static final Pattern numPattern = Pattern.compile("-?[0-9]+(\\.[0-9]+)?");
    private static final Pattern CN_USERNAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_\u4e00-\u9fa5]{2,32}$");
    private static final Pattern EN_USERNAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{2,32}$");
    private static final Pattern USEFUL_PASSWORD_PATTERN = Pattern.compile("^(?=.*[A-Za-z])[A-Za-z0-9!@#\\\\$%\\\\^&*()-_+=<>?]{8,32}$");
    @NotNull
    private static final String SUB_MODULE_NAME = "VALIDATOR";

    private Validator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean strNotBlank(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        String s = ((Object)StringsKt.trim((CharSequence)o.toString())).toString();
        if (((CharSequence)s).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        if (Intrinsics.areEqual((Object)"", (Object)s)) return false;
        String string = s.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)"null", (Object)string)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean strIsBlank(@Nullable Object o) {
        String s;
        if (o == null) {
            return true;
        }
        String $this$trim$iv = s = o.toString();
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String trim = string;
        return ((CharSequence)trim).length() == 0 || Intrinsics.areEqual((Object)"null", (Object)trim) || Intrinsics.areEqual((Object)"undefined", (Object)trim);
    }

    @JvmStatic
    public static final boolean objFieldNotNull(@Nullable Object obj) {
        if (obj != null) {
            Class<?> objClass = obj.getClass();
            Method[] methodArray = objClass.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
            Method[] declaredMethods = methodArray;
            if (!(declaredMethods.length == 0)) {
                int methodCount = 0;
                int nullValueCount = 0;
                for (Method declaredMethod : declaredMethods) {
                    String name;
                    Intrinsics.checkNotNullExpressionValue((Object)declaredMethod.getName(), (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)name, (String)"get", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"is", (boolean)false, (int)2, null)) continue;
                    ++methodCount;
                    try {
                        Object invoke = declaredMethod.invoke(obj, new Object[0]);
                        if (invoke != null) continue;
                        ++nullValueCount;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                return methodCount == nullValueCount;
            }
        }
        return false;
    }

    @JvmStatic
    public static final boolean objIsNull(@Nullable Object o) {
        if (o == null) {
            return true;
        }
        return o instanceof Map && ((Map)o).isEmpty() ? true : o instanceof List && ((List)o).isEmpty();
    }

    @JvmStatic
    public static final boolean objNotNull(@Nullable Object o) {
        return !Validator.objIsNull(o);
    }

    @JvmStatic
    public static final boolean parametersHaveNull(Object ... params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        boolean b = false;
        for (Object o : params) {
            if (Validator.strNotBlank(o)) continue;
            b = true;
            break;
        }
        return b;
    }

    @JvmStatic
    public static final boolean stringsHasNull(String ... o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        for (String s : o) {
            if (!Validator.strIsBlank(s)) continue;
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean stringsNotNull(String ... o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        for (String s : o) {
            if (!Validator.strIsBlank(s)) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final boolean strIsNumber(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Matcher matcher = numPattern.matcher(str);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher m = matcher;
        return m.matches();
    }

    @JvmStatic
    public static final boolean checkCNUsernameFormat(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Matcher matcher = CN_USERNAME_PATTERN.matcher(username);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher m = matcher;
        return m.matches();
    }

    @JvmStatic
    public static final boolean checkUsefulPasswordFormat(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Matcher matcher = USEFUL_PASSWORD_PATTERN.matcher(password);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher m = matcher;
        return m.matches();
    }

    @JvmStatic
    @NotNull
    public static final List<String> checkMapContainsKey(@NotNull Map<String, ? extends Object> map, String ... keys) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        List keyList = new ArrayList();
        for (String key : keys) {
            if (map.containsKey(key)) continue;
            keyList.add(key);
        }
        return keyList;
    }

    @JvmStatic
    public static final boolean checkMapContainsKeyBoolean(@NotNull Map<String, ? extends Object> map, String ... keys) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        List<String> checkMapContainsKey = Validator.checkMapContainsKey(map, Arrays.copyOf(keys, keys.length));
        return !(!((Collection)checkMapContainsKey).isEmpty());
    }

    @JvmStatic
    public static final void checkMapContainsKeyThrowEx(@NotNull Map<String, ? extends Object> map, String ... keys) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        List<String> checkMapContainsKey = Validator.checkMapContainsKey(map, Arrays.copyOf(keys, keys.length));
        if (!((Collection)checkMapContainsKey).isEmpty()) {
            String key = checkMapContainsKey.get(0);
            String errorLog = LoggerToolkitKt.errorWithModule(logger, "XVOID-TOOLKIT", SUB_MODULE_NAME, "\u7f3a\u5931\u5c5e\u6027" + key);
            throw new IllegalArgumentException(errorLog);
        }
    }

    @JvmStatic
    public static final boolean validateRegex(@Nullable String regex) {
        return Regex.INSTANCE.validateRegex(regex);
    }
}

