/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.constant;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000bH\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0019H\u0007J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000bH\u0007J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004H\u0007J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\"H\u0007J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0019H\u0007J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\"H\u0007J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcn/toutatis/xvoid/toolkit/constant/Time;", "", "()V", "HMS_COLON_FORMAT_REGEX", "", "SIMPLE_DATE_FORMAT_REGEX", "YMD_HMS_NON_SEPARATOR_TIME_REGEX", "YMD_HORIZONTAL_FORMAT_REGEX", "YMD_NON_SEPARATOR_FORMAT_REGEX", "YMD_SLASH_FORMAT_REGEX", "currentMillis", "", "getCurrentMillis$annotations", "getCurrentMillis", "()J", "currentSeconds", "getCurrentSeconds$annotations", "getCurrentSeconds", "currentTime", "getCurrentTime$annotations", "getCurrentTime", "()Ljava/lang/String;", "simpleDateFormat", "Ljava/text/SimpleDateFormat;", "getCurrentDayLastMillsTime", "Ljava/time/LocalDateTime;", "getCurrentLocalDateTime", "getCurrentTimeByLong", "time", "isBeforeNow", "", "isSameDay", "pattern", "parseData", "Ljava/util/Date;", "str", "parseTimeToMills", "regexTime", "format", "date", "void-toolkit"})
public final class Time {
    @NotNull
    public static final Time INSTANCE = new Time();
    @NotNull
    public static final String YMD_HORIZONTAL_FORMAT_REGEX = "yyyy-MM-dd";
    @NotNull
    public static final String YMD_SLASH_FORMAT_REGEX = "yyyy/MM/dd";
    @NotNull
    public static final String YMD_NON_SEPARATOR_FORMAT_REGEX = "yyyyMMdd";
    @NotNull
    public static final String YMD_HMS_NON_SEPARATOR_TIME_REGEX = "yyyyMMddHHmmss";
    @NotNull
    public static final String HMS_COLON_FORMAT_REGEX = "HH:mm:ss";
    @NotNull
    public static final String SIMPLE_DATE_FORMAT_REGEX = "yyyy-MM-dd HH:mm:ss";
    @NotNull
    private static volatile SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private Time() {
    }

    @NotNull
    public static final synchronized String getCurrentTime() {
        String string = simpleDateFormat.format(System.currentTimeMillis());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getCurrentTime$annotations() {
    }

    public static final long getCurrentMillis() {
        return System.currentTimeMillis();
    }

    @JvmStatic
    public static /* synthetic */ void getCurrentMillis$annotations() {
    }

    public static final long getCurrentSeconds() {
        return INSTANCE.getCurrentMillis() / (long)1000;
    }

    @JvmStatic
    public static /* synthetic */ void getCurrentSeconds$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final synchronized String getCurrentTimeByLong(long time) {
        String string = simpleDateFormat.format(new Date(time));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getCurrentLocalDateTime() {
        String string = LocalDateTime.now().format(DateTimeFormatter.ofPattern(SIMPLE_DATE_FORMAT_REGEX));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String regexTime(@NotNull String format, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = new SimpleDateFormat(format).format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String regexTime(@NotNull String format, long time) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = new SimpleDateFormat(format).format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String regexTime(@NotNull String format, @NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = time.format(DateTimeFormatter.ofPattern(format));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String regexTime(@NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = simpleDateFormat.format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final LocalDateTime getCurrentDayLastMillsTime() {
        LocalDate date = LocalDate.now();
        LocalTime lastTime = LocalTime.MAX;
        LocalDateTime localDateTime = LocalDateTime.of(date, lastTime);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
        return localDateTime;
    }

    @JvmStatic
    @NotNull
    public static final Date parseData(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return Time.parseData(simpleDateFormat, str);
    }

    @JvmStatic
    @NotNull
    public static final Date parseData(@NotNull SimpleDateFormat simpleDateFormat, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)simpleDateFormat, (String)"simpleDateFormat");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Date date = simpleDateFormat.parse(str);
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"parse(...)");
        return date;
    }

    @JvmStatic
    public static final long parseTimeToMills(@NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return time.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    @JvmStatic
    public static final boolean isSameDay(@NotNull String pattern, long time) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return Intrinsics.areEqual((Object)Time.regexTime(pattern, new Date()), (Object)Time.regexTime(pattern, time));
    }

    @JvmStatic
    public static final boolean isBeforeNow(@NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return LocalDateTime.now().isBefore(time);
    }
}

