/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.file;

import cn.toutatis.xvoid.toolkit.log.LoggerToolkitKt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0014\u0010!\u001a\u00020\u00042\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0007J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\bH\u0007J\b\u0010%\u001a\u00020\u0004H\u0007J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0004H\u0007J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040)2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcn/toutatis/xvoid/toolkit/file/FileToolkit;", "", "()V", "RESOURCE_FILE_DIR", "", "TEMP_FILE_DIR", "dirPathMapCache", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "runPath", "createDirectoryOrExist", "dirPath", "exists", "file", "Ljava/io/File;", "findFileInPossibleLocation", "path", "getClassesFile", "Ljava/net/URL;", "filename", "getFileContent", "getFileSuffix", "fileName", "getJarResource", "getJarResourceAsStream", "Ljava/io/InputStream;", "getResourceFile", "getResourceFileAsFile", "getResourceFileAsString", "getRuntimePath", "clazz", "Ljava/lang/Class;", "returnDir", "getThreadPath", "isImg", "suffix", "readFileLines", "", "void-toolkit"})
@SourceDebugExtension(value={"SMAP\nFileToolkit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileToolkit.kt\ncn/toutatis/xvoid/toolkit/file/FileToolkit\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1#2:246\n*E\n"})
public final class FileToolkit {
    @NotNull
    public static final FileToolkit INSTANCE = new FileToolkit();
    private static final Logger logger = LoggerFactory.getLogger(FileToolkit.class);
    @NotNull
    public static final String TEMP_FILE_DIR = "XV_TEMP";
    @NotNull
    public static final String RESOURCE_FILE_DIR = "resources";
    @Nullable
    private static String runPath;
    @NotNull
    private static final HashMap<String, Boolean> dirPathMapCache;

    private FileToolkit() {
    }

    @JvmStatic
    public static final boolean createDirectoryOrExist(@NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        if (dirPathMapCache.containsKey(dirPath)) {
            return true;
        }
        File dirFile = new File(dirPath);
        boolean mkdirSuccess = false;
        if (dirFile.exists()) {
            if (dirFile.isDirectory()) {
                mkdirSuccess = true;
                Boolean bl = mkdirSuccess;
                ((Map)dirPathMapCache).put(dirPath, bl);
            } else {
                boolean mkdir = dirFile.mkdirs();
                if (mkdir) {
                    Boolean bl = mkdirSuccess;
                    ((Map)dirPathMapCache).put(dirPath, bl);
                    mkdirSuccess = true;
                }
            }
        } else {
            boolean mkdir = dirFile.mkdirs();
            if (mkdir) {
                mkdirSuccess = true;
                Boolean bl = mkdirSuccess;
                ((Map)dirPathMapCache).put(dirPath, bl);
            }
        }
        if (!mkdirSuccess) {
            Logger logger = FileToolkit.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            LoggerToolkitKt.warnWithModule(logger, "XVOID-TOOLKIT", dirPath + " \u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25");
        }
        return mkdirSuccess;
    }

    @JvmStatic
    @Nullable
    public static final String getResourceFileAsString(@NotNull String filename) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        URL uRL = FileToolkit.getResourceFile(filename);
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            string = new String(byArray, charset);
        } else {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final URL getResourceFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return Thread.currentThread().getContextClassLoader().getResource(filename);
    }

    @JvmStatic
    @Nullable
    public static final URL getClassesFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String formatFilename = filename;
        if (StringsKt.startsWith$default((String)filename, (String)"/", (boolean)false, (int)2, null)) {
            String string = filename.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            formatFilename = string;
        }
        return new File(INSTANCE.getThreadPath() + formatFilename).toURI().toURL();
    }

    @JvmStatic
    @NotNull
    public static final String getRuntimePath(boolean returnDir) {
        String string;
        CodeSource codeSource = INSTANCE.getClass().getProtectionDomain().getCodeSource();
        File runPath = new File(codeSource.getLocation().toURI().getPath());
        if (returnDir) {
            String string2 = runPath.getParent();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParent(...)");
        } else {
            String string3 = runPath.getPath();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getRuntimePath(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        File runPath = new File(codeSource.getLocation().toURI().getPath());
        String string = runPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getThreadPath() {
        String string;
        if (runPath != null) {
            String string2 = runPath;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            URL uRL = Thread.currentThread().getContextClassLoader().getResource("");
            Intrinsics.checkNotNull((Object)uRL);
            String string3 = runPath = uRL.getPath();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final URL getJarResource(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return INSTANCE.getClass().getClassLoader().getResource(filename);
    }

    @JvmStatic
    @Nullable
    public static final InputStream getJarResourceAsStream(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return INSTANCE.getClass().getClassLoader().getResourceAsStream(filename);
    }

    @JvmStatic
    @Nullable
    public static final File getResourceFileAsFile(@NotNull String filename) {
        File file;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Serializable serializable = FileToolkit.getResourceFile(filename);
        if (serializable != null && (serializable = serializable.toURI()) != null) {
            Serializable it = serializable;
            boolean bl = false;
            file = new File((URI)it);
        } else {
            file = null;
        }
        return file;
    }

    @JvmStatic
    @NotNull
    public static final String getFileContent(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists()) {
            String string = IOUtils.toString((URI)file.toURI(), (Charset)Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        throw new FileNotFoundException(file.getPath() + "\u4e0d\u5b58\u5728.");
    }

    @JvmStatic
    @NotNull
    public static final String getFileSuffix(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = fileName.substring(StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getFileSuffix(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists()) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return FileToolkit.getFileSuffix(string);
        }
        throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
    }

    @JvmStatic
    public static final boolean isImg(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Matcher matcher = Pattern.compile("png|jpg|jpeg").matcher(suffix);
        return matcher.matches();
    }

    @JvmStatic
    public static final boolean exists(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.exists();
    }

    @JvmStatic
    @NotNull
    public static final List<String> readFileLines(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return FilesKt.readLines$default((File)file, null, (int)1, null);
    }

    @JvmStatic
    @NotNull
    public static final File findFileInPossibleLocation(@NotNull String path) {
        URL threadPath;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (new File(path).exists()) {
            File file;
            File $this$findFileInPossibleLocation_u24lambda_u241 = file = new File(path);
            boolean bl = false;
            logger.info("Found the file!this file has a clear path!Nice!");
            return file;
        }
        URL resourcesFile = FileToolkit.getResourceFile(path);
        if (resourcesFile != null && new File(resourcesFile.toURI()).exists()) {
            File $this$findFileInPossibleLocation_u24lambda_u241;
            File $this$findFileInPossibleLocation_u24lambda_u242 = $this$findFileInPossibleLocation_u24lambda_u241 = new File(resourcesFile.toURI());
            boolean bl = false;
            logger.info("Found the file!this file is a resource file,please use getResource method! ");
            return $this$findFileInPossibleLocation_u24lambda_u241;
        }
        URL jarResource = FileToolkit.getJarResource(path);
        if (jarResource != null && new File(jarResource.toURI()).exists()) {
            File $this$findFileInPossibleLocation_u24lambda_u242;
            File $this$findFileInPossibleLocation_u24lambda_u243 = $this$findFileInPossibleLocation_u24lambda_u242 = new File(jarResource.toURI());
            boolean bl = false;
            logger.info("Found the file!this file is a JAR package file,please use getJarResource method! ");
            return $this$findFileInPossibleLocation_u24lambda_u242;
        }
        URL uRL = threadPath = FileToolkit.getClassesFile(path);
        URI uRI = uRL != null ? uRL.toURI() : null;
        Intrinsics.checkNotNull((Object)uRI);
        if (new File(uRI).exists()) {
            File file;
            File $this$findFileInPossibleLocation_u24lambda_u244 = file = new File(threadPath.toURI());
            boolean bl = false;
            logger.info("Found the file!this file is a runtime path file,please use getClassesFile method! ");
            return file;
        }
        throw new FileNotFoundException("Can't find [" + path + "] this file location. QAQ");
    }

    static {
        dirPathMapCache = new HashMap(32);
    }
}

