/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.http;

import cn.toutatis.xvoid.toolkit.log.LoggerToolkit;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002J\u0006\u0010\u000e\u001a\u00020\bJ&\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0013H\u0002JB\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007JB\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\r2\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcn/toutatis/xvoid/toolkit/http/HttpToolkit;", "", "()V", "httpClient", "Lokhttp3/OkHttpClient;", "logger", "Lorg/slf4j/Logger;", "addHeader", "", "request", "Lokhttp3/Request$Builder;", "headers", "", "", "asyncGet", "concatMapParameters", "url", "queries", "getResponseBody", "Lokhttp3/Request;", "post", "parameters", "syncGet", "params", "void-toolkit"})
@SourceDebugExtension(value={"SMAP\nHttpToolkit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpToolkit.kt\ncn/toutatis/xvoid/toolkit/http/HttpToolkit\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,115:1\n1#2:116\n215#3,2:117\n*S KotlinDebug\n*F\n+ 1 HttpToolkit.kt\ncn/toutatis/xvoid/toolkit/http/HttpToolkit\n*L\n112#1:117,2\n*E\n"})
public final class HttpToolkit {
    @NotNull
    public static final HttpToolkit INSTANCE = new HttpToolkit();
    @NotNull
    private static final Logger logger = LoggerToolkit.getLogger(HttpToolkit.class);
    @NotNull
    private static OkHttpClient httpClient = new OkHttpClient();

    private HttpToolkit() {
    }

    @JvmStatic
    @Nullable
    public static final String syncGet(@NotNull String url, @Nullable Map<String, String> params, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request.Builder builder = new Request.Builder();
        String urlWithParams = INSTANCE.concatMapParameters(url, params);
        builder.url(urlWithParams);
        INSTANCE.addHeader(builder, headers);
        Request request = builder.build();
        String responseBody = INSTANCE.getResponseBody(request);
        return responseBody;
    }

    public static /* synthetic */ String syncGet$default(String string, Map map, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            map2 = null;
        }
        return HttpToolkit.syncGet(string, map, map2);
    }

    public final void asyncGet() {
    }

    @JvmStatic
    @Nullable
    public static final String post(@NotNull String url, @Nullable Map<String, String> parameters, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        FormBody.Builder builder = new FormBody.Builder(null, 1, null);
        Map<String, String> map = parameters;
        if (!(map == null || map.isEmpty())) {
            for (String key : parameters.keySet()) {
                if (parameters.get(key) != null) {
                    String it;
                    boolean bl = false;
                    builder.add(key, it);
                }
            }
        }
        Request.Builder requestBuilder = new Request.Builder();
        INSTANCE.addHeader(requestBuilder, headers);
        Request request = requestBuilder.url(url).post((RequestBody)builder.build()).build();
        return INSTANCE.getResponseBody(request);
    }

    public static /* synthetic */ String post$default(String string, Map map, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            map2 = null;
        }
        return HttpToolkit.post(string, map, map2);
    }

    private final String concatMapParameters(String url, Map<String, String> queries) {
        StringBuilder urlBuilder = new StringBuilder(url);
        Map<String, String> map = queries;
        if (!(map == null || map.isEmpty())) {
            boolean firstParameterFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (firstParameterFlag) {
                    urlBuilder.append('?' + key + '=' + value);
                    firstParameterFlag = false;
                    continue;
                }
                urlBuilder.append('&' + key + '=' + value);
            }
        }
        String string = urlBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getResponseBody(Request request) {
        String message = null;
        try {
            Closeable closeable = (Closeable)httpClient.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                if (response.isSuccessful()) {
                    message = Objects.requireNonNull(response.body()).string();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u5bf9\u5916\u8bf7\u6c42\u5931\u8d25,\u8bf7\u67e5\u8be2\u539f\u56e0[URL:" + request.url() + ']');
        }
        return message;
    }

    private final void addHeader(Request.Builder request, Map<String, String> headers) {
        block1: {
            Map<String, String> map = headers;
            if (map == null) break block1;
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String k = entry.getKey();
                String v = entry.getValue();
                request.addHeader(k, v);
            }
        }
    }
}

