/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcn/toutatis/xvoid/toolkit/http/RequestToolkit;", "", "()V", "getIpAddress", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "void-toolkit"})
public final class RequestToolkit {
    @NotNull
    public static final RequestToolkit INSTANCE = new RequestToolkit();

    private RequestToolkit() {
    }

    @JvmStatic
    @Nullable
    public static final String getIpAddress(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String ipAddress = null;
        try {
            ipAddress = request.getHeader("x-forwarded-for");
            if (ipAddress == null || ((CharSequence)ipAddress).length() == 0 || StringsKt.equals((String)"unknown", (String)ipAddress, (boolean)true)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ((CharSequence)ipAddress).length() == 0 || StringsKt.equals((String)"unknown", (String)ipAddress, (boolean)true)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((ipAddress == null || ((CharSequence)ipAddress).length() == 0 || StringsKt.equals((String)"unknown", (String)ipAddress, (boolean)true)) && Intrinsics.areEqual((Object)(ipAddress = request.getRemoteAddr()), (Object)"127.0.0.1")) {
                InetAddress inet = null;
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                InetAddress inetAddress = inet;
                Intrinsics.checkNotNull((Object)inetAddress);
                ipAddress = inetAddress.getHostAddress();
            }
            if (ipAddress != null && ipAddress.length() > 15 && StringsKt.indexOf$default((CharSequence)ipAddress, (String)",", (int)0, (boolean)false, (int)6, null) > 0) {
                String string = ipAddress.substring(0, StringsKt.indexOf$default((CharSequence)ipAddress, (String)",", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                ipAddress = string;
            }
        }
        catch (Exception e) {
            ipAddress = "";
        }
        return ipAddress;
    }
}

