/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.validator;

import cn.toutatis.xvoid.achievable.filter.WordSearchFilter;
import cn.toutatis.xvoid.achievable.filter.WordSearchResult;
import cn.toutatis.xvoid.structure.tree.TrieNode;
import cn.toutatis.xvoid.toolkit.validator.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcn/toutatis/xvoid/toolkit/validator/SensitiveWordFilter;", "Lcn/toutatis/xvoid/achievable/filter/WordSearchFilter;", "()V", "rootNode", "Lcn/toutatis/xvoid/structure/tree/TrieNode;", "", "addSearchWord", "", "word", "", "search", "", "Lcn/toutatis/xvoid/achievable/filter/WordSearchResult;", "text", "void-toolkit"})
@SourceDebugExtension(value={"SMAP\nSensitiveWordFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SensitiveWordFilter.kt\ncn/toutatis/xvoid/toolkit/validator/SensitiveWordFilter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,61:1\n215#2,2:62\n*S KotlinDebug\n*F\n+ 1 SensitiveWordFilter.kt\ncn/toutatis/xvoid/toolkit/validator/SensitiveWordFilter\n*L\n57#1:62,2\n*E\n"})
public final class SensitiveWordFilter
implements WordSearchFilter {
    @NotNull
    private final TrieNode<Character> rootNode = new TrieNode();

    public void addSearchWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        TrieNode current = this.rootNode;
        char[] cArray = word.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            current.childrenNodes().putIfAbsent(Character.valueOf(c), new TrieNode());
            Object v = current.childrenNodes().get(Character.valueOf(c));
            Intrinsics.checkNotNull(v);
            current = (TrieNode)v;
        }
        current.setEndNode(true);
    }

    @NotNull
    public List<WordSearchResult> search(@Nullable String text) {
        List filteredWords = new ArrayList();
        if (Validator.strIsBlank(text)) {
            return filteredWords;
        }
        StringBuilder currentWord = new StringBuilder();
        TrieNode<Character> current = this.rootNode;
        int idx = 0;
        LinkedHashMap records = new LinkedHashMap();
        while (true) {
            String string = text;
            Intrinsics.checkNotNull((Object)string);
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            if (idx >= cArray.length) break;
            char currentCharacter = text.charAt(idx);
            boolean treeExist = current.childrenNodes().containsKey(Character.valueOf(currentCharacter));
            if (treeExist) {
                Object v = current.childrenNodes().get(Character.valueOf(currentCharacter));
                Intrinsics.checkNotNull(v);
                current = (TrieNode<Character>)v;
                currentWord.append(currentCharacter);
                if (current.isEndNode()) {
                    String word;
                    Intrinsics.checkNotNullExpressionValue((Object)currentWord.toString(), (String)"toString(...)");
                    ArrayList positionList = null;
                    if (!records.containsKey(word)) {
                        positionList = new ArrayList();
                        ((Map)records).put(word, positionList);
                    } else {
                        Object v2 = records.get(word);
                        Intrinsics.checkNotNull(v2);
                        positionList = (ArrayList)v2;
                    }
                    int i = idx - word.length();
                    if (i <= 0) {
                        i = 0;
                    }
                    positionList.add(i);
                }
            } else {
                if (((CharSequence)currentWord).length() > 0) {
                    --idx;
                }
                currentWord = new StringBuilder();
                current = this.rootNode;
            }
            ++idx;
        }
        Map $this$forEach$iv = records;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String word = (String)entry.getKey();
            ArrayList positionList = (ArrayList)entry.getValue();
            filteredWords.add(new WordSearchResult((List)positionList, word));
        }
        return filteredWords;
    }
}

