/*
 * Decompiled with CFR 0.152.
 */
package cn.toutatis.xvoid.toolkit.validator;

import java.util.HashMap;
import java.util.Map;

public class DFAFilter {
    private final Map<Character, Map> sensitiveWordsMap = new HashMap<Character, Map>();
    private static final char EOS = '\u0000';

    public void addSensitiveWord(String word) {
        Map currentMap = this.sensitiveWordsMap;
        for (char c : word.toCharArray()) {
            if (!currentMap.containsKey(Character.valueOf(c))) {
                currentMap.put(Character.valueOf(c), new HashMap());
            }
            currentMap = currentMap.get(Character.valueOf(c));
        }
        currentMap.put((Character)Character.valueOf('\u0000'), null);
    }

    public void buildFilter(String[] sensitiveWords) {
        for (String word : sensitiveWords) {
            this.addSensitiveWord(word);
        }
    }

    public String filter(String text) {
        StringBuilder result = new StringBuilder();
        int start = 0;
        while (start < text.length()) {
            int end;
            Map currentMap = this.sensitiveWordsMap;
            for (end = start; end < text.length() && currentMap.containsKey(Character.valueOf(text.charAt(end))); ++end) {
                if (!(currentMap = currentMap.get(Character.valueOf(text.charAt(end)))).containsKey(Character.valueOf('\u0000'))) continue;
                for (int i = start; i <= end; ++i) {
                    result.append('*');
                }
                start = end + 1;
                break;
            }
            if (end != start) continue;
            result.append(text.charAt(start));
            ++start;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        String[] sensitiveWords = new String[]{"\u654f\u611f\u8bcd1", "\u654f\u611f\u8bcd2", "\u654f\u611f\u8bcd*"};
        DFAFilter dfaFilter = new DFAFilter();
        dfaFilter.buildFilter(sensitiveWords);
        String text = "\u8fd9\u662f\u4e00\u4e2a\u6d4b\u8bd5\uff0c\u5305\u542b\u654f\u611f\u8bcd1\uff0c\u654f\u611f\u8bcd2\uff0c\u654f\u611f\u8bcd*\u4ee5\u53ca\u5176\u4ed6\u8bcd\u8bed\u3002";
        String filteredText = dfaFilter.filter(text);
        System.out.println(filteredText);
    }
}

